//=============================================================================
// HA&KARifle
//=============================================================================
class HAnKARifle extends FFWeapon;

#exec MESH IMPORT MESH=SteinFruchtAnimated ANIVFILE=MODELS\SteinFruchtAnimated_a.3d DATAFILE=MODELS\SteinFruchtAnimated_d.3d UnMirror=1
#exec MESH ORIGIN MESH=SteinFruchtAnimated X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=All STARTFRAME=1 NUMFRAMES=105
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Select STARTFRAME=96 NUMFRAMES=8 GROUP=Select
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Still STARTFRAME=104 NUMFRAMES=1 
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Shoot STARTFRAME=1 NUMFRAMES=28
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Stab STARTFRAME=29 NUMFRAMES=11
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Reload STARTFRAME=41 NUMFRAMES=48
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Down STARTFRAME=90 NUMFRAMES=5

#exec TEXTURE IMPORT NAME=Steinfrucht FILE=Steinfrucht.pcx GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=HandGlove FILE=SimpleGloveHandTexture.pcx GROUP="Skins" LODSET=2

#exec MESHMAP NEW MESHMAP=SteinFruchtAnimated MESH=SteinFruchtAnimated
#exec MESHMAP SCALE MESHMAP=SteinFruchtAnimated X=0.005 Y=0.005 Z=0.01

#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=3 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=5 TEXTURE=HandGlove

#exec MESH IMPORT MESH=SteinFruchtAnimatedL ANIVFILE=MODELS\SteinFruchtAnimated_a.3d DATAFILE=MODELS\SteinFruchtAnimated_d.3d
#exec MESH ORIGIN MESH=SteinFruchtAnimatedL X=0 Y=0 Z=0 YAW=128 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=All STARTFRAME=1 NUMFRAMES=105
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Select STARTFRAME=96 NUMFRAMES=8 GROUP=Select
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Still STARTFRAME=104 NUMFRAMES=1 
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Shoot STARTFRAME=1 NUMFRAMES=28
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Stab STARTFRAME=29 NUMFRAMES=11
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Reload STARTFRAME=41 NUMFRAMES=48
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Down STARTFRAME=90 NUMFRAMES=5

#exec MESHMAP NEW MESHMAP=SteinFruchtAnimatedL MESH=SteinFruchtAnimatedL
#exec MESHMAP SCALE MESHMAP=SteinFruchtAnimatedL X=0.005 Y=0.005 Z=0.01

#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=3 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=5 TEXTURE=HandGlove

#exec MESH IMPORT MESH=SteinFruchtPickup ANIVFILE=MODELS\SteinFruchtPickup_a.3d DATAFILE=MODELS\SteinFruchtPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=SteinFruchtPickup X=0 Y=0 Z=0 YAW=64 
#exec MESH SEQUENCE MESH=SteinFruchtPickup SEQ=All         STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtPickup SEQ=Still        STARTFRAME=0   NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=SteinFruchtPickup X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=3 TEXTURE=Steinfrucht

#exec MESH IMPORT MESH=SteinFruchtHand ANIVFILE=MODELS\SteinFruchtPickup_a.3d DATAFILE=MODELS\SteinFruchtPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=SteinFruchtHand X=270 Y=-30 Z=-70 YAW=135 
#exec MESH SEQUENCE MESH=SteinFruchtHand SEQ=All         STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtHand SEQ=Still        STARTFRAME=0   NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=SteinFruchtHand X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=3 TEXTURE=Steinfrucht

#exec TEXTURE IMPORT NAME=MuzzleFlash2 FILE=TEXTURES\NewMuz2.PCX GROUP="Rifle" MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=IconRifle FILE=TEXTURES\HUD\WpnRifle.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseRifle FILE=TEXTURES\HUD\UseRifle.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=RReticle FILE=TEXTURES\rifleret.PCX GROUP="Icons" MIPS=OFF FLAGS=2 LODSET=2

#exec AUDIO IMPORT FILE="Sounds\SniperRifle\SniperFire.wav" NAME="SniperFire" GROUP="SniperRifle"

#exec MESH IMPORT MESH=muzzsr3 ANIVFILE=MODELS\muzzle2_a.3d DATAFILE=MODELS\Muzzle2_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=muzzsr3 MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=muzzsr3 X=0 Y=980 Z=-75 YAW=64
#exec MESH SEQUENCE MESH=muzzsr3 SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=muzzsr3 SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=muzzsr3 MESH=muzzsr3
#exec MESHMAP SCALE MESHMAP=muzzsr3 X=0.04 Y=0.1 Z=0.08
#exec TEXTURE IMPORT NAME=Muzzy3 FILE=MODELS\Muzzy3.PCX GROUP=Skins

var vector OwnerLocation;
var float StillTime, StillStart;

////////////////////////////////////////////////////
//////////////////Functions/////////////////////////
////////////////////////////////////////////////////

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'SteinFruchtAnimatedL';
	else
		Mesh = mesh'SteinFruchtAnimated';
}

simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}


simulated function PlayFiring()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Shoot',0.5 + 0.5 * FireAdjust, 0.05);
	if ( (PlayerPawn(Owner) != None) 
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}


simulated function PlayAltFiring()
{
	if (Owner != None)
	{
		if ( Affector != None )
			Affector.FireEffect();
		PlayOwnedSound(AltFireSound, SLOT_Misc, 1.7*Pawn(Owner).SoundDampening,,,);
		PlayAnim('Stab',1.0, 0.05);
	}
}

function AltFire( float Value )
{
	Gotostate('AltFiring');
	bCanClientFire = true;
	bPointing=True;
	Pawn(Owner).PlayRecoil(FiringSpeed);
	TraceAltFire();
	ClientAltFire(Value);
}

function TraceAltFire()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local actor Other;
	local Projectile P;
	local float speed;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, AimError, False, False);	
	EndTrace = StartTrace + 180 * vector(AdjustedAim); 
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);
	ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim), Y, Z);

	// push aside projectiles
	ForEach VisibleCollidingActors(class'Projectile', P, 550, Owner.Location)
		if ( ((P.Physics == PHYS_Projectile) || (P.Physics == PHYS_Falling))
			&& (Normal(P.Location - Owner.Location) Dot X) > 0.9 )
		{
			P.speed = VSize(P.Velocity);
			if ( P.Velocity Dot Y > 0 )
				P.Velocity = P.Speed * Normal(P.Velocity + (750 - VSize(P.Location - Owner.Location)) * Y);
			else	
				P.Velocity = P.Speed * Normal(P.Velocity - (750 - VSize(P.Location - Owner.Location)) * Y);
		}
}

function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector realLoc;
	local float scale;

	if ( (Other == None) || (Other == Owner) || (Other == self) || (Owner == None) )
		return;

	realLoc = Owner.Location + CalcDrawOffset();
	scale = (180 - VSize(realLoc - HitLocation))/180;
	if ( (Other == Level) || Other.IsA('Mover') )
	{
	}
	else
	{
		Other.TakeDamage(120 * scale, Pawn(Owner), HitLocation, 30000.0 * X * scale, MyDamageType);
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}
}


function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);	
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 10000 * X; 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}



function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;

	s = Spawn(class'UT_ShellCase',, '', Owner.Location + CalcDrawOffset() + 30 * X + (2.8 * FireOffset.Y+5.0) * Y - Z * 1);
	if ( s != None ) 
	{
		s.DrawScale = 2.0;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	}

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(45,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
	ProcessTraceHitEffect(Other, ConsumableAmmo(AmmoType), HitLocation, HitNormal);
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if (P.bFire == 0)
			bPointing = false;
	}
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}
////////////////////////////////////////////////////////
/////////////////////States/////////////////////////////
////////////////////////////////////////////////////////
state NormalFire
{ ignores Fire, AltFire;
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state AltFiring
{ ignores Fire, AltFire;

}
state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			Pawn(Owner).PlayRecoil(FiringSpeed);
			TraceFire(0.0);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}

	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) {
		Fire(0.0);
	}
	if ( Pawn(Owner).bAltFire!=0 ) {
		AltFire(0.0);
	}
	Disable('AnimEnd');
	PlayIdleAnim();
}

// End Class
//=============================================================================

defaultproperties
{
     WeaponDescription="Classification: Long Range Ballistic\n\nRegular Fire: Fires a high powered plum. Can kill instantly when applied to the cranium of opposing forces. \n\nSecondary Fire: Meeles the fork in to someone. Causes huge damage!!"
     AmmoName=Class'FoodFightWeapons.PlumCan'
     PickupAmmoCount=8
     bInstantHit=True
     bAltInstantHit=True
     FiringSpeed=1.800000
     FireOffset=(Y=-5.000000,Z=-2.000000)
     MyDamageType=shot
     AltDamageType=Decapitated
     shakemag=400.000000
     shaketime=0.150000
     shakevert=8.000000
     AIRating=0.540000
     RefireRate=0.600000
     AltRefireRate=1.000000
     FireSound=Sound'Botpack.SniperRifle.SniperFire'
     AltFireSound=Sound'Botpack.SniperRifle.SniperFire'
     SelectSound=Sound'UnrealI.Rifle.RiflePickup'
     DeathMessage="%o shouldn't have messed with the HA&KA ranger %k...."
     NameColor=(R=0,G=0)
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashY=0.110000
     FlashO=0.014000
     FlashC=0.031000
     FlashLength=0.013000
     FlashS=256
     MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
     AutoSwitchPriority=5
     InventoryGroup=9
     PickupMessage="You got a HA&KA Steinfrucht."
     ItemName="HA&KA Steinfrucht"
     PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
     PlayerViewMesh=LodMesh'FoodFightWeapons.SteinFruchtAnimated'
     PlayerViewScale=2.000000
     BobDamping=0.975000
     PickupViewMesh=LodMesh'FoodFightWeapons.SteinFruchtPickup'
     ThirdPersonMesh=LodMesh'FoodFightWeapons.SteinFruchtHand'
     StatusIcon=Texture'Botpack.Icons.UseRifle'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
     MuzzleFlashScale=0.100000
     MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseRifle'
     Mesh=LodMesh'FoodFightWeapons.SteinFruchtPickup'
     bNoSmooth=False
     CollisionRadius=32.000000
     CollisionHeight=8.000000
}
