
class JellyJumper extends TournamentWeapon;

#exec MESH IMPORT MESH=JellyJumpPlatformPickup ANIVFILE=MODELS\JellyJumpPlatformPickup_a.3d DATAFILE=MODELS\JellyJumpPlatformPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=JellyJumpPlatformPickup X=0 Y=0 Z=0

#exec MESH LODPARAMS MESH=JellyJumpPlatformPickup STRENGTH=0
#exec MESH SEQUENCE MESH=JellyJumpPlatformPickup SEQ=All STARTFRAME=0 NUMFRAMES=100
#exec MESH SEQUENCE MESH=JellyJumpPlatformPickup SEQ=Still STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=JellyJumpPlatformPickup SEQ=Select STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=JellyJumpPlatformPickup SEQ=Down STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=JellyJumpPlatformPickup SEQ=Bounce STARTFRAME=2 NUMFRAMES=14

#exec MESHMAP NEW MESHMAP=JellyJumpPlatformPickup MESH=JellyJumpPlatformPickup
#exec MESHMAP SCALE MESHMAP=JellyJumpPlatformPickup X=0.025 Y=0.025 Z=0.05

#exec TEXTURE IMPORT NAME=jelly FILE=Textures/jelly.bmp GROUP=Skins FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=JellyJumpPlatformPickup NUM=1 TEXTURE=jelly
#exec MESHMAP SETTEXTURE MESHMAP=JellyJumpPlatformPickup NUM=2 TEXTURE=jelly


var JellyJumperPad TTarget;
var float TossForce;
var Weapon PreviousWeapon;
var float MaxTossForce;
var bool bBotMoveFire;

function float RateSelf( out int bUseAltMode )
{
    return -2; 
}
/*
function BringUp()
{
    PreviousWeapon = None;
    Super.BringUp();
}

function RaiseUp(Weapon OldWeapon)
{
    if ( OldWeapon == self )
        PreviousWeapon = None;
    else
        PreviousWeapon = OldWeapon;
    Super.BringUp();
}
*/

function SetSwitchPriority(pawn Other)
{
    AutoSwitchPriority = 0;
}

function Fire( float Value )
{
   if ( bBotMoveFire )
      return;

   if (  TTarget == None )
   {
   		bPointing=True;
      	bCanClientFire = true;
      	ClientFire(value);
      	Pawn(Owner).PlayRecoil(FiringSpeed);
      	ThrowTarget();
      	ReturnToPreviousWeapon();
    		Pawn(Owner).DeleteInventory(Self);
   }
}

function ReturnToPreviousWeapon()
{
    if ( (PreviousWeapon == None) || ((PreviousWeapon.AmmoType != None) && (PreviousWeapon.AmmoType.AmmoAmount <=0)) )
        Pawn(Owner).SwitchToBestWeapon();
    else
    {
        Pawn(Owner).PendingWeapon = PreviousWeapon;
        PutDown();
    }
}

function ThrowTarget()
{
    local Vector Start, X,Y,Z;

    Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
    Pawn(Owner).ViewRotation = Pawn(Owner).AdjustToss(TossForce, Start, 0, true, true);
    GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
    TTarget = Spawn(class'JellyJumperPad',,, Start);
    if (TTarget!=None)
        TTarget.Throw(Pawn(Owner), MaxTossForce, Start);
    else GotoState('Idle');
}

state NormalFire
{
    ignores fire, altfire, AnimEnd;

    function bool PutDown()
    {
        return True;
    }

Begin:
    Sleep(0.1);
    if ( (Pawn(Owner).bFire != 0) && (Pawn(Owner).bAltFire != 0) )
        ReturnToPreviousWeapon();
}


state Idle
{
    function AnimEnd()
    {
        PlayIdleAnim();
    }

    function bool PutDown()
    {
        return True;
    }

Begin:
    bPointing=False;
    if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
    Disable('AnimEnd');
    FinishAnim();
    PlayIdleAnim();
}

defaultproperties
{
   ItemName="JellyJumper"
   bCanThrow=False
     	MaxTossForce=400.000000
     	PickupAmmoCount=1
      PlayerViewOffset=(X=5.000000,Y=-2.200000,Z=-5.000000)
   FiringSpeed=1.000000
   FireOffset=(X=15.000000,Y=-13.000000,Z=-7.000000)
   AIRating=-1.000000
   FireSound=Sound'Botpack.Translocator.ThrowTarget'
   AutoSwitchPriority=0
   PickupMessage="You got the Jelly Jumper!"
   RespawnTime=30.000000
   PlayerViewScale=0.4
   ThirdPersonScale=0.6
   PlayerViewMesh=JellyJumpPlatformPickup
   PickupViewMesh=JellyJumpPlatformPickup
   ThirdPersonMesh=JellyJumpPlatformPickup
     	StatusIcon=Texture'Botpack.Icons.UseTrans'  //fix
     	Icon=Texture'Botpack.Icons.UseTrans'
   Mesh=JellyJumpPlatformPickup
   bNoSmooth=False
   CollisionRadius=30.000000
   CollisionHeight=15.000000
   Mass=10.000000
   WeaponDescription="Jelly jump pad for placeable jump spot"
}
