class JellyJumperPad extends Decoration;

#exec AUDIO IMPORT FILE="Sounds\JellySpring.WAV" NAME=JellySpring

var float Disruption, SpawnTime;
var() float DisruptionThreshold, speed;
var pawn Disruptor;
var translocator Master;
var Actor DesiredTarget;
var bool bAlreadyHit, bTempDamage;
var vector RealLocation;
var Decal Shadow;
var int jumpsleft;
var sound ImpactSound;

Replication
{
    UnReliable if ( Role == ROLE_Authority )
        RealLocation, jumpsleft;
}

simulated function Destroyed()
{
    if ( Shadow != None )
        Shadow.Destroy();
    Super.Destroyed();
}

function bool Disrupted()
{
    return ( Disruption > DisruptionThreshold );
}

function DropFrom(vector StartLocation)
{
    if ( !SetLocation(StartLocation) )
        return; 

    SetPhysics(PHYS_Falling);
    GotoState('PickUp');
}

simulated singular function ZoneChange( ZoneInfo NewZone )
{
    local float splashsize;
    local actor splash;

    if( NewZone.bWaterZone )
    {
        if( !Region.Zone.bWaterZone && (Velocity.Z < -200) )
        {
            // Else play a splash.
            splashSize = FClamp(0.0001 * Mass * (250 - 0.5 * FMax(-600,Velocity.Z)), 1.0, 3.0 );
            if( NewZone.EntrySound != None )
                PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
            if( NewZone.EntryActor != None )
            {
                splash = Spawn(NewZone.EntryActor); 
                if ( splash != None )
                {
                    splash.DrawScale = splashSize;
                    splash.RemoteRole = ROLE_None;
                }
            }
        }
    }
}

function Throw(Pawn Thrower, float force, vector StartPosition)
{
   local vector dir;

   dir = vector(Thrower.ViewRotation);
   dir.Z = dir.Z + 0.35 * (1 - Abs(dir.Z));
   Velocity = 400 * Normal(dir);
   bBounce = true;
   DropFrom(StartPosition);
}

auto state Pickup
{
    simulated function Timer()
    {
        local Pawn P;

        if ((Physics == PHYS_None) && (Role != ROLE_Authority) && (RealLocation != Location) && (RealLocation != vect(0,0,0)))
                SetLocation(RealLocation);

        //disruption effect
        if ( Disrupted() )
        {
            Spawn(class'Electricity',,,Location + Vect(0,0,6));
            PlaySound(sound'TDisrupt', SLOT_None, 4.0);
        }
        AnimEnd();
        SetTimer(1 + 2 * FRand(), false);
    }

    simulated event Landed( vector HitNormal )
    {
        local rotator newRot;

        SetTimer(2.5, false);
        newRot = Rotation;
        newRot.Pitch = 0;
        newRot.Roll = 0;
        SetRotation(newRot);
        if ( Role == ROLE_Authority )
        {
            RemoteRole = ROLE_DumbProxy;
            RealLocation = Location;
            Disable('Tick');
        }
    }       

    event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
    {
        SetPhysics(PHYS_Falling);
        Velocity = Momentum/Mass;
        Velocity.Z = FMax(Velocity.Z, 0.7 * VSize(Velocity));

        if ( Level.Game.bTeamGame && (EventInstigator != None) && (EventInstigator.PlayerReplicationInfo != None)
            && (EventInstigator.PlayerReplicationInfo.Team == Instigator.PlayerReplicationInfo.Team) )
            return;

        Disruption += Damage;
        Disruptor = EventInstigator;
        if ( !Disrupted() )
            SetTimer(0.3, false);
    }

    singular function Touch( Actor Other )
    {
        local bool bMasterTouch;
        local vector NewPos;

        if ( !Other.bIsPawn )
        {
            if ( (Physics == PHYS_Falling) && !Other.IsA('Inventory') && !Other.IsA('Triggers') && !Other.IsA('NavigationPoint') )
                HitWall(-1 * Normal(Velocity), Other);
            return;
        }
        bMasterTouch = ( Other == Instigator );
        if ( bMasterTouch )
            return;
        NewPos = Other.Location;
        NewPos.Z = Location.Z;
        SetLocation(NewPos);
        Velocity = vect(0,0,0);
        if ( Level.Game.bTeamGame && (Instigator.PlayerReplicationInfo.Team == Pawn(Other).PlayerReplicationInfo.Team) )
            return;
    }

    simulated function HitWall (vector HitNormal, actor Wall)
    {
        if ( bAlreadyHit )
        {
            bBounce = false;
            return;
        }
        bAlreadyHit = ( HitNormal.Z > 0.7 );
        PlaySound(ImpactSound, SLOT_Misc);    // hit wall sound
        Velocity = 0.3*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
        speed = VSize(Velocity);
    }

    simulated function Tick(float DeltaTime)
    {
        if ( Level.bHighDetailMode && (Shadow == None)
            && (PlayerPawn(Instigator) != None) && (ViewPort(PlayerPawn(Instigator).Player) != None) )
            Shadow = spawn(class'TargetShadow',self,,,rot(16384,0,0));

        if ( Role != ROLE_Authority )
        {
            Disable('Tick');
            return;
        }
        if ( (DesiredTarget == None) || (Master == None) )
        {
            Disable('Tick');
            return;
        }

        if ( (Abs(Location.X - DesiredTarget.Location.X) < Master.Owner.CollisionRadius) && (Abs(Location.Y - DesiredTarget.Location.Y) < Master.Owner.CollisionRadius) )
        {
            if ( !FastTrace(DesiredTarget.Location, Location) )
                return; 

            Disable('Tick');
        }
    }

    function EndState()
    {
        DesiredTarget = None;
    }


	function Bump( actor Other )
	{
   	local float speed, oldZ;
   	local ut_SpriteSmokePuff b;
    
		if(Pawn(Other)!=None)
   	{
   		log(jumpsleft);
      	Instigator = Pawn(Other);
      	Instigator.AddVelocity(600*vect(0,0,1));
      	PlayAnim( 'Bounce', 0.65 );
      	PlaySound(sound'Jellyspring');
      	if (Instigator.IsA('Pawn'))
      	{
      		jumpsleft = jumpsleft - 1;
      		if (jumpsleft <=0)
      		{
      			b = spawn(class'UT_SpriteSmokePuff',,,Location);
					b.RemoteRole = ROLE_None;
      			Self.Destroy();
      		}
      	}
   	}
	}
}

defaultproperties
{
	jumpsleft=15
   bStatic=False
   bUnlit=True
   DrawType=DT_Mesh
   //RemoteRole=ROLE_SimulatedProxy
     DisruptionThreshold=65
     ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
     bBounce=True
     bProjTarget=true
     Mass=50.000000
     bNetTemporary=false
     LifeSpan=+000.000000
   Mesh=JellyJumpPlatformPickup
	CollisionRadius=30.000000
   CollisionHeight=15.000000
   bCollideActors=True
   bCollideWorld=True
   bBlockActors=True
   bBlockPlayers=True
   Mass=100.000000
   ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
}
