
class JuiceBottleApple extends JuiceBottleOrange;

#exec TEXTURE IMPORT NAME=Applebottle FILE=Textures\Applebottle.BMP GROUP=Skins

State Sleeping
{
    ignores Touch;

    function BeginState()
    {
        BecomePickup();
        bHidden = true;
        LightBrightness = 0;
        LightRadius = 0;

    }
    function EndState()
    {
        local int i;

        bSleepTouch = false;
        for ( i=0; i<4; i++ )
            if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
                bSleepTouch = true;
      LightBrightness = 153;
      LightRadius = 6;
    }           
Begin:
    Sleep( ReSpawnTime );
    PlaySound( RespawnSound );  
    Sleep( Level.Game.PlaySpawnEffect(self) );
    GoToState( 'Pickup' );
}


defaultproperties
{
   PickupSound=sound'Botpack.Pickups.UTHealth'
   bSuperHeal=true
   bRotatingPickup=True
   HealingAmount=12
   RespawnTime=30.000000
   CollisionRadius=+00010.000000
   CollisionHeight=+00016.000000
   PickupMessage="You picked up an Apple Juice Bottle +"
   PickupViewMesh=JuiceBottle
   PickupViewScale=1.000000
   Mesh=JuiceBottle
   Texture=Applebottle
   MultiSkins(0)=Applebottle
   MultiSkins(1)=Applebottle
   MultiSkins(2)=Applebottle
   DrawScale=0.750000
   ScaleGlow=2.000000
   ItemName="AppleJuiceBottle"
   LightType=LT_Steady
   LightEffect=LE_SlowWave
   LightBrightness=153
   LightHue=100
   LightSaturation=0
   LightRadius=6
}