class ObjectsFlames expands Actor;

#exec AUDIO IMPORT NAME="PawnBurn" FILE=EFFECTS\PawnBurn.wav GROUP="FlameT"
#exec AUDIO IMPORT NAME="OtherBurn" FILE=EFFECTS\OtherBurn.wav GROUP="FlameT"

#exec TEXTURE IMPORT NAME=TranslucentInvisible FILE=EFFECTS\TranslucentInvisible.bmp GROUP=Skins FLAGS=2 LODSET=2

#exec AUDIO IMPORT NAME="PosFireSteam" FILE=EFFECTS\PosFireSteam.wav GROUP="FlameT"

var float MoreDamage;
var bool HealthGiver;
var Actor DamVic;

replication
{
	// Things the server should send to the client.
	reliable if(Role==ROLE_Authority)
		MoreDamage, HealthGiver;
}

simulated function PostBeginPlay()
{
	local int i;

	if (Region.Zone.bWaterZone) //Flames cannot exist underwater
		Destroy();

	if (Owner != None)
	{
		if (Owner.IsA('Pawn') || Owner.IsA('Carcass'))
			AmbientSound = Sound'PawnBurn';
		else
		{
			AmbientSound = Sound'OtherBurn';
			SoundVolume *= 2;
		}

		if (Owner.IsA('Decoration') && !Owner.IsA('Vehicle') && !Owner.IsA('StrangeShell'))
		{
			For (i=0; i<8; i++)
				Owner.MultiSkins[i] = Texture'TranslucentInvisible';
		}
	}
	SetTimer(0.2,True);
}

simulated function Timer()
{
	local RisingFlames F;
	local Actor A;
	local bool bOwnedSome;
	
	if (Owner != None)
	{
		ForEach VisibleCollidingActors (Class'Actor', A, 32, Owner.Location)
		{
			if (A == Owner)
				bOwnedSome = True;
		}
	}

	If (Owner == None || !bOwnedSome)
	{
		Destroy();
		return;
	}
	else if (Owner.bHidden)
	{
		Destroy();
		return;
	}

	if (Level.NetMode != NM_DedicatedServer)
	{
		F = Spawn(Class'RisingFlames', Owner,, Owner.Location, Owner.Rotation);
		F.Mesh = Owner.Mesh;
		F.AnimSequence = Owner.AnimSequence;
		F.AnimFrame = Owner.AnimFrame;
	}

	
	if (Role == ROLE_Authority)
	{
		HurtRadiusX(FMax(1.0,MoreDamage), 48.0, 'Burned', 0.0, Location);
	}

	If (Region.Zone.bWaterZone)
	{
		PlaySound(Sound'PosFireSteam',,10.0,,2200);
		Destroy();
	}
}


//Special HurtRadius - With Health giving implementation
//******************************************************************************************************************

function HurtRadiusX( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
   local actor Victims;
   local float damageScale, dist;
   local vector dir;
   local Pawn P;
    
   if( bHurtEntry )
      return;

   bHurtEntry = true;
   foreach VisibleCollidingActors( class 'Actor', Victims, DamageRadius, HitLocation )
   {
      if( Victims != self )
      {
         dir = Victims.Location - HitLocation;
         dist = FMax(1,VSize(dir));
         dir = dir/dist;
         damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
         Victims.TakeDamage(damageScale * DamageAmount,Instigator,Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
				(damageScale * Momentum * dir),DamageName);
      }
	}
   bHurtEntry = false;
}

defaultproperties
{
   bHidden=True
   Physics=PHYS_Trailer
   RemoteRole=Role_SimulatedProxy
   LifeSpan=5.00
   SoundVolume=96
   LightType=LT_Steady
   LightEffect=LE_NonIncidence
   LightBrightness=100
   LightRadius=8
}
