class PNutTracer extends MTracer;

#exec TEXTURE IMPORT NAME=PNutTracer FILE=Textures/PNutTracer.BMP GROUP=Skins

simulated function HitWall (vector HitNormal, actor Wall)
{
   if ( Role == ROLE_Authority )
   {
      if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
         Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');

      MakeNoise(1.0);
   }
   Explode(Location + ExploWallOut * HitNormal, HitNormal);
	Spawn(class'PNutWallHitEffect',self,,Location, Rotator(HitNormal));
}

defaultproperties
{
	speed=+6000.0
   MaxSpeed=+6000.0
   MultiSkins(1)=Texture'PNutTracer'
}