//=============================================================================
// PapriCannonGun
//=============================================================================
class PapriCannonGun extends FFWeapon;

#exec MESH IMPORT MESH=PapriCannonAnim ANIVFILE=MODELS\PapricannonAnimated_a.3d DATAFILE=MODELS\PapricannonAnimated_d.3d X=0 Y=0 Z=0 UnMirror=1 
//#exec MESH ORIGIN MESH=PapricannonAnimated X=0 Y=0 Z=0  //Default
#exec MESH ORIGIN MESH=PapriCannonAnim X=10 Y=-10 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=All STARTFRAME=0 NUMFRAMES=48
//Was numframes=5
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=Shoot STARTFRAME=1 NUMFRAMES=32
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=Reload STARTFRAME=6 NUMFRAMES=27
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=Deselect STARTFRAME=33 NUMFRAMES=6
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=Select STARTFRAME=39 NUMFRAMES=9
#exec MESH SEQUENCE MESH=PapricannonAnim SEQ=Still STARTFRAME=48 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=PapriCannonUVMap FILE=PapricannonUVmap2.pcx GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=HandGlove FILE=SimpleGloveHandTexture.pcx GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=PapriNadeUVmap FILE=PapriNadeUVmap.pcx GROUP=Skins FLAGS=2

//#exec MESHMAP SCALE MESHMAP=PapricannonAnimated X=0.1 Y=0.1 Z=0.2  //Default
#exec MESHMAP SCALE MESHMAP=PapriCannonAnim X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnim NUM=1 TEXTURE=PapriNadeUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnim NUM=2 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnim NUM=3 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnim NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnim NUM=5 TEXTURE=PapriCannonUVMap


#exec MESH IMPORT MESH=PapriCannonAnimL ANIVFILE=MODELS\PapricannonAnimated_a.3d DATAFILE=MODELS\PapricannonAnimated_d.3d
#exec MESH ORIGIN MESH=PapriCannonAnimL X=10 Y=10 Z=0 YAW=128 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=All STARTFRAME=0 NUMFRAMES=48
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=Shoot STARTFRAME=1 NUMFRAMES=5
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=Reload STARTFRAME=6 NUMFRAMES=27
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=Deselect STARTFRAME=33 NUMFRAMES=6
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=Select STARTFRAME=39 NUMFRAMES=9
#exec MESH SEQUENCE MESH=PapricannonAnimL SEQ=Still STARTFRAME=48 NUMFRAMES=1


#exec MESHMAP SCALE MESHMAP=PapriCannonAnimL X=0.01 Y=0.01 Z=0.02
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnimL NUM=1 TEXTURE=PapriNadeUVMap
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnimL NUM=2 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnimL NUM=3 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnimL NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonAnimL NUM=5 TEXTURE=PapriCannonUVMap

// PICKUP
#exec MESH IMPORT MESH=PapriCannonPickup ANIVFILE=MODELS\PapricannonPickup_a.3d DATAFILE=MODELS\PapricannonPickup_d.3d X=0 Y=0 Z=0 UnMirror=1
#exec MESH ORIGIN MESH=PapriCannonPickup X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PapriCannonPickup SEQ=All     STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=PapriCannonPickup SEQ=Still        STARTFRAME=0   NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=PapriCannonPickup MESH=PapriCannonPickup
// Strength added to fix mesh problems
#exec MESH LODPARAMS MESH=PapriCannonPickup STRENGTH=0.25
#exec MESHMAP SCALE MESHMAP=PapriCannonPickup X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonPickup NUM=1 TEXTURE=PapriCannonUVMap

// 3RD PERSON
#exec MESH IMPORT MESH=PapriCannonHand ANIVFILE=MODELS\PapricannonPickup_a.3d DATAFILE=MODELS\PapricannonPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=PapriCannonHand X=125 Y=-4 Z=-100 YAW=135 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PapriCannonHand SEQ=All     STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=PapriCannonHand SEQ=Still        STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=PapriCannonHand MESH=PapriCannonHand
#exec MESHMAP SCALE MESHMAP=PapriCannonHand X=0.05 Y=0.05 Z=0.10
#exec MESHMAP SETTEXTURE MESHMAP=PapriCannonHand NUM=1 TEXTURE=PapriCannonUVMap


#exec TEXTURE IMPORT NAME=IconBio FILE=TEXTURES\HUD\WpnBio.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseBio FILE=TEXTURES\HUD\UseBio.PCX GROUP="Icons" MIPS=OFF


#exec AUDIO IMPORT FILE="Sounds\biorifle\biopowerupmix1.WAV" NAME="BioAltRep" GROUP="BioRifle"
#exec AUDIO IMPORT FILE="Sounds\paprifire.WAV" NAME="paprifire" GROUP="PapriCannon"
#exec AUDIO IMPORT FILE="Sounds\nadebump.WAV" NAME="nadebump" GROUP="PapriCannon"


var Projectile currentShot;

// Removed this since there is no running anim
/*
simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;
	if ( (Owner != None) && (VSize(Owner.Velocity) > 10) )
		PlayAnim('Still',0.3,0.3);
	else
		TweenAnim('Still', 1.0);
	Enable('AnimEnd');
}
*/

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local vector EnemyDir;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	bUseAltMode = 0;
	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	if ( EnemyDist > 1400 )
		return 0;

	bRetreating = ( ((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.6 );
	if ( (EnemyDist > 600) && (EnemyDir.Z > -0.4 * EnemyDist) )
	{
		// only use if enemy not too far and retreating
		if ( !bRetreating )
			return 0;

		return AIRating;
	}

	bUseAltMode = int( FRand() < 0.3 );

	if ( bRetreating || (EnemyDir.Z < -0.7 * EnemyDist) )
		return (AIRating + 0.18);
	return AIRating;
}

function float SuggestAttackStyle()
{
	return -0.3;
}

function float SuggestDefenseStyle()
{
	return -0.4;
}

function Fire(float Value)
{
   if ( AmmoType == None )
      GiveAmmo(Pawn(Owner));

   if ( AmmoType.UseAmmo(1) )
   {
      Gotostate('NormalFire');
      bCanClientFire = true;
      ClientFire(Value);
     currentShot = ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
   }
}

simulated function PlayFiring()
{
   PlayOwnedSound(FireSound, SLOT_Misc, 1.7*Pawn(Owner).SoundDampening);
   PlayAnim('Shoot',0.4, 0.05);
}

function AltFire( float Value )
{
   bPointing=True;
   if ( currentShot != None )
   {
      GoToState('AltFiring');
      bCanClientFire = true;
      ClientAltFire(Value);
      currentShot.Timer();
      currentShot=None;
   }
}

simulated function PlayAltFiring()
{
//  Needs a recoding to accomodate the remote detonation
//   PlayOwnedSound(Sound'Botpack.BioRifle.BioAltRep', SLOT_Misc, 1.3*Pawn(Owner).SoundDampening);    //loading goop
//   PlayAnim('Eject',0.4,0.05);
}

simulated function PlayReloading()
{
//Removed this because I hooked the fire and reload anims together
}


defaultproperties
{
     WeaponDescription="Classification: Modification of a simple pump set to launch hot and sweet papri nades.\n\nPrimary Fire: Fires a papri nade to the opponent.\n\nSecondary Fire: Blast off the papri nade dispatched in the air."
     AmmoName=Class'FoodFightWeapons.PapriNadeCylinder'
     PickupAmmoCount=5
     bAltWarnTarget=True
     bRapidFire=False
     FiringSpeed=1.000000
     FireOffset=(X=12.000000,Y=-11.000000,Z=-6.000000)
     ProjectileClass=Class'FoodFightWeapons.PapriNade'
     AIRating=0.600000
     RefireRate=0.50000
     AltRefireRate=1.00000
     FireSound=Sound'paprifire'
     AltFireSound=Sound'UnrealI.BioRifle.GelShot'
     CockingSound=Sound'UnrealI.BioRifle.GelLoad'
     SelectSound=Sound'UnrealI.BioRifle.GelSelect'
     DeathMessage="%o was blasted by the red hot thing thrown by %k"
     AutoSwitchPriority=2
     InventoryGroup=5
     PickupMessage="You got the Papri cannon."
     ItemName="Papri cannon"
     //PlayerViewOffset=(X=1.700000,Y=-0.850000,Z=-0.950000)   //Default
     PlayerViewOffset=(X=2.900000,Y=-1.5000,Z=-0.950000)
     PlayerViewMesh=LodMesh'FoodFightWeapons.PapriCannonAnim'
     BobDamping=0.972000
     PickupViewMesh=LodMesh'FoodFightWeapons.PapriCannonPickup'
     ThirdPersonMesh=LodMesh'FoodFightWeapons.PapriCannonHand'
     StatusIcon=Texture'Botpack.Icons.UseBio'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseBio'
     Mesh=LodMesh'FoodFightWeapons.PapriCannonAnim'
     bNoSmooth=False
     CollisionHeight=19.000000
     //ADDS
     PlayerViewScale=0.25
     ThirdPersonScale=0.60
     //Multiskins(1)=Texture'FoodFightWeapons.Skins.PapriNadeUVmap
}
