class PapriChunk1 extends Fragment1;

#exec TEXTURE IMPORT NAME=NadeChunk FILE=Textures/NadeChunk.BMP GROUP=Skins

var float SmokeRate;

simulated function Tick(float DeltaTime)
{
   local BlackSmoke b;

   if (FRand()<0.1)
   {
      b = Spawn(class'BlackSmoke');
      b.DrawScale = FRand()*0.05+1.5;
      b.RemoteRole = ROLE_None;
   }
}

auto state Flying
{
   simulated function timer()
   {
      GoToState('Dying');
   }

   simulated function Touch(actor Other)
   {
      if (Pawn(Other)==None) Return;
      if (!Pawn(Other).bIsPlayer) Destroy();
   }

   simulated singular function ZoneChange( ZoneInfo NewZone )
   {
      local float splashsize;
      local actor splash;

      if ( NewZone.bWaterZone )
      {
         Velocity = 0.2 * Velocity;
         splashSize = 0.0005 * (250 - 0.5 * Velocity.Z);
         if ( Level.NetMode != NM_DedicatedServer )
         {
            if ( NewZone.EntrySound != None )
               PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
            if ( NewZone.EntryActor != None )
            {
               splash = Spawn(NewZone.EntryActor);
               if ( splash != None )
                  splash.DrawScale = 4 * splashSize;
            }
         }
         if (bFirstHit)
         {
            bFirstHit=False;
            bRotatetoDesired=True;
            bFixedRotationDir=False;
            DesiredRotation.Pitch=0;
            DesiredRotation.Yaw=FRand()*65536;
            DesiredRotation.roll=0;
         }
            
         RotationRate = 0.2 * RotationRate;
         GotoState('Dying');
      }
      if ( NewZone.bPainZone && (NewZone.DamagePerSec > 0) )
         Destroy();
   }

   simulated function BeginState()
   {
      RandSpin(125000);
      if (RotationRate.Pitch>-10000&&RotationRate.Pitch<10000)
         RotationRate.Pitch=10000;
      if (RotationRate.Roll>-10000&&RotationRate.Roll<10000)
         RotationRate.Roll=10000;
      Mesh = Fragments[int(FRand()*numFragmentTypes)];
      if ( Level.NetMode == NM_Standalone )
         LifeSpan = 20 + 40 * FRand();
      SetTimer(5.0,True);
		Velocity = (Vector(FRand() * Rotation) * (400 + 200 * FRand()) );
   }
}

state Dying
{
   simulated function HitWall (vector HitNormal, actor HitWall)
   {
      Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
      speed = VSize(Velocity);
      if (bFirstHit && speed<400)
      {
         bFirstHit=False;
         bRotatetoDesired=True;
         bFixedRotationDir=False;
         DesiredRotation.Pitch=0;
         DesiredRotation.Yaw=FRand()*65536;
         DesiredRotation.roll=0;
      }
      RotationRate.Yaw = RotationRate.Yaw*0.75;
      RotationRate.Roll = RotationRate.Roll*0.75;
      RotationRate.Pitch = RotationRate.Pitch*0.75;
      if ( (Velocity.Z < 50) && (HitNormal.Z > 0.7) )
      {
         SetPhysics(PHYS_none);
         bBounce = false;
      }
      else If (speed > 80)
      {
         if (FRand()<0.5) PlaySound(ImpactSound, SLOT_None, 0.5+FRand()*0.5,, 300, 0.85+FRand()*0.3);
         else PlaySound(MiscSound, SLOT_None, 0.5+FRand()*0.5,, 300, 0.85+FRand()*0.3);
      }
   }

   function TakeDamage( int Dam, Pawn instigatedBy, Vector hitlocation,Vector momentum, name damageType)
   {
   }

   simulated function BeginState()
   {
      SetTimer(1.5,True);
      SetCollision(true, false, false);
   }
}

simulated function CalcVelocity(vector Momentum, float ExplosionSize)
{
	local vector X;

   Velocity = X * (((FRand()* 100) * Vector(Rotation)) * Speed );
}

defaultproperties
{
   Fragments(0)=LodMesh'ChipM'
   numFragmentTypes=1
   CollisionRadius=+00022.000000
   CollisionHeight=+00002.000000
   Physics=PHYS_Falling
   MultiSkins(1)=Texture'NadeChunk'
   speed=+02200.000000
   AmbientSound=Sound'AmbAncient.looping.fire6'
   SoundRadius=20
   ImpactSound=nadebump
   MiscSound=nadebump
}

