
class RedBlobEffects extends Effects;

#exec TEXTURE IMPORT NAME=RedBlob1 FILE=Textures\RedBlob1.bmp GROUP=Effects
#exec TEXTURE IMPORT NAME=RedBlob2 FILE=Textures\RedBlob2.bmp GROUP=Effects
#exec TEXTURE IMPORT NAME=RedBlob3 FILE=Textures\RedBlob3.bmp GROUP=Effects
#exec TEXTURE IMPORT NAME=RedBlob4 FILE=Textures\RedBlob4.bmp GROUP=Effects
#exec TEXTURE IMPORT NAME=RedBlob5 FILE=Textures\RedBlob5.bmp GROUP=Effects

var() texture BlobTypes[5];

simulated function Setup(vector WallNormal)
{
   Texture = BlobTypes[Rand(5)];
   Velocity = VRand()*140*FRand()+WallNormal*250;
   DrawScale = FRand()*0.3 + 0.2;
}

auto state Explode
{
   simulated function Landed( vector HitNormal )
   {
      Destroy();
   }

   simulated function HitWall( vector HitNormal, actor Wall )
   {
      Destroy();
   }
}

defaultproperties
{
   BlobTypes(0)=Texture'RedBlob1'
	BlobTypes(1)=Texture'RedBlob2'
	BlobTypes(2)=Texture'RedBlob3'
   BlobTypes(3)=Texture'RedBlob4'
   BlobTypes(4)=Texture'RedBlob5'
   Physics=PHYS_Falling
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=7.000000
   DrawType=DT_Sprite
   Style=STY_Translucent
   Texture=Texture'RedBlob1'
   bUnlit=True
   bMeshCurvy=False
   CollisionRadius=4.000000
   CollisionHeight=4.000000
   bCollideWorld=True
   bBounce=True
   NetPriority=2.000000
   bHighDetail=true
}