class RedGlobBig extends RedGlob;

var int NumSplash;
var vector SpawnPoint;

auto state Flying
{
   function ProcessTouch (Actor Other, vector HitLocation)
   {
	 	local ObjectsFlames F;
		local bool bThere;
		
		if (!Region.Zone.bWaterZone)
		{
   	   if ( (Other.IsA('Pawn') || (Other.IsA('Decoration') || (Other.IsA('Carcass')))))
			{
				if (Other.DrawScale < 1.25 && Other.DrawScale > 0.75)
				{
					ForEach RadiusActors(Class'ObjectsFlames', F, 8.0, Other.Location)
					{
						if (F.Owner == Other)
						{
							bThere=True;
							break;
						}
					}
					if (!bThere)
						F = Spawn(Class'ObjectsFlames', Other,, Other.Location);
				}
			}
		}
      if ( Other.IsA('RedGlobSplash') )
         return;
      if ( Pawn(Other)!=Instigator || bOnGround)
         Global.Timer();
   }
   simulated function HitWall( vector HitNormal, actor Wall )
	{
      SetPhysics(PHYS_None);
      MakeNoise(1);
      bOnGround = True;
      PlaySound(ImpactSound);
      SetWall(HitNormal, Wall);
      if ( DrawScale > 1 )
         NumSplash = int(2 * DrawScale) - 1;
      SpawnPoint = Location + 5 * HitNormal;
      DrawScale= FMin(DrawScale, 3.0);
      if ( NumSplash > 0 )
      {
         SpawnSplash();
         if ( NumSplash > 0 )
         	SpawnSplash();
      }
      GoToState('OnSurface');
	}
}

function SpawnSplash()
{
   local vector Start;

   NumSplash--;
   Start = SpawnPoint + 4 * VRand();
   Spawn(class'RedGlobSplash',,,Start,Rotator(Start - Location));
}

state OnSurface
{
   function Tick(float DeltaTime)
   {
      if ( NumSplash > 0 )
      {
         SpawnSplash();
         if ( NumSplash > 0 )
            SpawnSplash();
         else
            Disable('Tick');
      }
      else
         Disable('Tick');
   }

	function ProcessTouch (Actor Other, vector HitLocation)
   {
		local ObjectsFlames F;
		local bool bThere;
		
		if (!Region.Zone.bWaterZone)
		{
   	   if ( (Other.IsA('Pawn') || (Other.IsA('Decoration') || (Other.IsA('Carcass')))))
			{
				if (Other.DrawScale < 1.25 && Other.DrawScale > 0.75)
				{
					ForEach RadiusActors(Class'ObjectsFlames', F, 8.0, Other.Location)
					{
						if (F.Owner == Other)
						{
							bThere=True;
							break;
						}
					}
					if (!bThere)
						F = Spawn(Class'ObjectsFlames', Other,, Other.Location);
				}
			}
		}
      if ( Other.IsA('RedGlobSplash') )
         return;
      GotoState('Exploding');
   }
}

defaultproperties
{
   speed=+00700.000000
   Damage=+0025.000000
   MomentumTransfer=30000
}
