class RisingFlames expands Projectile;

#exec TEXTURE IMPORT NAME=Flames_01 FILE=EFFECTS\Flames_01.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_02 FILE=EFFECTS\Flames_02.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_03 FILE=EFFECTS\Flames_03.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_04 FILE=EFFECTS\Flames_04.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_05 FILE=EFFECTS\Flames_05.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_06 FILE=EFFECTS\Flames_06.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_07 FILE=EFFECTS\Flames_07.bmp GROUP=Effects FLAGS=2
#exec TEXTURE IMPORT NAME=Flames_08 FILE=EFFECTS\Flames_08.bmp GROUP=Effects FLAGS=2

simulated function PostBeginPlay()
{
	if (Owner!=None)
		Mesh = Owner.Mesh;
}

simulated function Tick( float DeltaTime)
{
	ScaleGlow = (Default.LifeSpan - LifeSpan) * 4;
	DrawScale = LifeSpan * Default.DrawScale;
}

auto state Flying
{
   simulated function HitWall (vector HitNormal, actor Wall);
   simulated function ProcessTouch (Actor Other, Vector HitLocation);

   function BeginState()
   {
      local vector Dir;

      Dir = vector(rot(16384,0,0));
      Velocity = speed * Dir;
      Acceleration = Dir * 50;
   }
}

defaultproperties
{
   speed=50.00
   MaxSpeed=150.00
   bOwnerNoSee=True
   RemoteRole=Role_SimulatedProxy
   LifeSpan=1.00
   Style=STY_Translucent
   Texture=Texture'Flames_01'
   DrawScale=0.35
   bUnlit=True
   bParticles=True
   bRandomFrame=True
   MultiSkins(0)=Texture'Flames_01'
   MultiSkins(1)=Texture'Flames_02'
   MultiSkins(2)=Texture'Flames_03'
   MultiSkins(3)=Texture'Flames_04'
   MultiSkins(4)=Texture'Flames_05'
   MultiSkins(5)=Texture'Flames_06'
   MultiSkins(6)=Texture'Flames_07'
   MultiSkins(7)=Texture'Flames_08'
   bCollideActors=False
}