
class SaladThrower extends FFWeapon;

#exec MESH IMPORT MESH=SaladThrowerUpdate ANIVFILE=MODELS\SaladThrowerUpdate_a.3d DATAFILE=MODELS\SaladThrowerUpdate_d.3d X=0 Y=0 Z=0 UnMirror=1
#exec MESH ORIGIN MESH=SaladThrowerUpdate X=-400 Y=-125 Z=120 YAW=-9 ROLL=0 PITCH=12

#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=All      STARTFRAME=0    NUMFRAMES=155
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Still    STARTFRAME=0    NUMFRAMES=1
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Shoot    STARTFRAME=1    NUMFRAMES=18
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Shake    STARTFRAME=19   NUMFRAMES=10
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Reload   STARTFRAME=29   NUMFRAMES=105
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Deselect STARTFRAME=135  NUMFRAMES=11
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Down     STARTFRAME=135  NUMFRAMES=11
#exec MESH SEQUENCE MESH=SaladThrowerUpdate SEQ=Select   STARTFRAME=146  NUMFRAMES=10

#exec MESH    SEQUENCE  MESH=SaladThrowerUpdate    SEQ=All STARTFRAME=0 NUMFRAMES=160
#exec MESHMAP NEW       MESHMAP=SaladThrowerUpdate MESH=SaladThrowerUpdate
#exec MESH    LODPARAMS MESH=SaladThrowerUpdate    STRENGTH=0
#exec MESHMAP SCALE     MESHMAP=SaladThrowerUpdate X=0.01875 Y=0.01875 Z=0.0375
#exec TEXTURE IMPORT    NAME=SaladThrowerUVmap     FILE=Textures/SaladThrowerUVmap.bmp GROUP=Skins FLAGS=2

#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=1 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=2 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=3 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=4 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=5 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerUpdate NUM=6 TEXTURE=SaladBagT

//Pickup Mesh
#exec MESH IMPORT MESH=SaladThrowerPickup ANIVFILE=MODELS\SaladThrowerPickup_a.3d DATAFILE=MODELS\SaladThrowerPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=10 UnMirror=1
#exec MESH ORIGIN MESH=SaladThrowerPickup X=0 Y=0 Z=-150

#exec MESHMAP NEW MESHMAP=SaladThrowerPickup MESH=SaladThrowerPickup
#exec MESHMAP SCALE MESHMAP=SaladThrowerPickup X=0.05 Y=0.05 Z=0.10
#exec MESH LODPARAMS MESH=SaladThrowerPickup STRENGTH=0

#exec MESH SEQUENCE MESH=SaladThrowerPickup SEQ=All    STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=SaladThrowerPickup SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=SaladThrowerPickup SEQ=Select STARTFRAME=0  NUMFRAMES=1

#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerPickup NUM=1 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerPickup NUM=2 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerPickup NUM=3 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerPickup NUM=4 TEXTURE=SaladThrowerUVmap

// 3rd Person
#exec MESH IMPORT MESH=SaladThrowerThird ANIVFILE=MODELS\SaladThrowerPickup_a.3d DATAFILE=MODELS\SaladThrowerPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=10 UnMirror=1
#exec MESH ORIGIN MESH=SaladThrowerThird X=-700 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0

#exec MESHMAP NEW MESHMAP=SaladThrowerThird MESH=CanOpenerBean
#exec MESH LODPARAMS MESH=SaladThrowerThird STRENGTH=0
#exec MESHMAP SCALE MESHMAP=SaladThrowerThird X=0.025 Y=0.025 Z=0.05
#exec MESH SEQUENCE MESH=SaladThrowerThird SEQ=All     STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=SaladThrowerThird SEQ=Still   STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=SaladThrowerThird SEQ=Select  STARTFRAME=0   NUMFRAMES=1

#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerThird NUM=1 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerThird NUM=2 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerThird NUM=3 TEXTURE=SaladThrowerUVmap
#exec MESHMAP SETTEXTURE MESHMAP=SaladThrowerThird NUM=4 TEXTURE=SaladThrowerUVmap

#exec AUDIO IMPORT FILE="Sounds\throwerfireA.Wav" NAME=throwerfireA GROUP="SaladThrower"
#exec AUDIO IMPORT FILE="Sounds\throwerfireB.Wav" NAME=throwerfireB GROUP="SaladThrower"
#exec AUDIO IMPORT FILE="Sounds\ThrowerReload.Wav" NAME=ThrowerReload GROUP="SaladThrower"
#exec AUDIO IMPORT FILE="Sounds\ThrowerGrind.Wav" NAME=ThrowerGrind GROUP="SaladThrower"

#exec TEXTURE IMPORT NAME=ThrowerIcon FILE=TEXTURES\ThrowerIcon.bmp GROUP="Icons" MIPS=OFF

var int ChargeSize;
var float Count;
var class<Projectile> projectiles[9];
var float TimesShot;

function float SuggestAttackStyle()
{
	local bot B;

	B = Bot(Owner);
	if ( (B != None) && B.bNovice )
		return 0.2;
	return 0.4;
}

function float SuggestDefenseStyle()
{
	return -0.3;
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, rating;
	local vector EnemyDir;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}
	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	rating = FClamp(AIRating - (EnemyDist - 450) * 0.001, 0.2, AIRating);
	if ( Pawn(Owner).Enemy.IsA('StationaryPawn') )
	{
		bUseAltMode = 0;
		return AIRating + 0.3;
	}
	if ( EnemyDist > 900 )
	{
		bUseAltMode = 0;
		if ( EnemyDist > 2000 )
		{
			if ( EnemyDist > 3500 )
				return 0.2;
			return (AIRating - 0.3);
		}			
		if ( EnemyDir.Z < -0.5 * EnemyDist )
		{
			bUseAltMode = 1;
			return (AIRating - 0.3);
		}
	}
	else if ( (EnemyDist < 750) && (Pawn(Owner).Enemy.Weapon != None) && Pawn(Owner).Enemy.Weapon.bMeleeWeapon )
	{
		bUseAltMode = 0;
		return (AIRating + 0.3);
	}
	else if ( (EnemyDist < 340) || (EnemyDir.Z > 30) )
	{
		bUseAltMode = 0;
		return (AIRating + 0.2);
	}
	else
		bUseAltMode = int( FRand() < 0.65 );
	return rating;
}

function Fire( float Value )
{
	local Vector Start, X,Y,Z;
	local Bot B;
	local Pawn P;
	local int i;

	if ( AmmoType == None )
	{
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{
		bCanClientFire = true;
      bPointing=True;
      Start = Owner.Location + CalcDrawOffset();
      B = Bot(Owner);
      P = Pawn(Owner);
      P.PlayRecoil(FiringSpeed);
      Owner.MakeNoise(2.0 * P.SoundDampening);
      AdjustedAim = P.AdjustAim(AltProjectileSpeed, Start, AimError, True, bWarnTarget);
      GetAxes(AdjustedAim,X,Y,Z);
      Spawn(class'WeaponLight',,'',Start+X*20,rot(0,0,0));
      Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
      for (i = 0; i< 7; i++)
		{
         ProjectileClass = projectiles[Rand(9)];
			//Spawn(ProjectileClass,,, Start - 2 * VRand(), AdjustedAim);
			Spawn(ProjectileClass,,, Start - 2 * VRand(), AdjustedAim);
		}
		ClientFire(Value);
		Gotostate('NormalFire');
	}
}

function AltFire( float Value )
{
	local Vector Start, X,Y,Z;
	local Bot B;
	local Pawn P;
	local int i;

   if ( AmmoType == None )
   {
        GiveAmmo(Pawn(Owner));
   }
   if (AmmoType.UseAmmo(2))
	{
		bCanClientFire = true;
      bPointing=True;
      Start = Owner.Location + CalcDrawOffset();
      B = Bot(Owner);
      P = Pawn(Owner);
      P.PlayRecoil(FiringSpeed);
      Owner.MakeNoise(2.0 * P.SoundDampening);
      AdjustedAim = P.AdjustAim(AltProjectileSpeed, Start, AimError, True, bWarnTarget);
      GetAxes(AdjustedAim,X,Y,Z);
      Spawn(class'WeaponLight',,'',Start+X*20,rot(0,0,0));
      Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
      for (i = 0; i< 18; i++)
		{
         ProjectileClass = projectiles[Rand(9)];
			Spawn(ProjectileClass,,, Start - 2 * VRand(), AdjustedAim);
		}
		TraceAltFire();
		ClientAltFire(Value);
		Gotostate('AltFiring');
	}
}

function TraceAltFire()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local actor Other;
	local Projectile P;
	local float speed;
	local actor a;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, AimError, False, False);	
	EndTrace = StartTrace + 120 * vector(AdjustedAim);
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);
	ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim), Y, Z);
}

function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector realLoc;
	local float scale;
	local actor a;

	if ( (Other == None) || (Other == Owner) || (Other == self) || (Owner == None) )
		return;

	realLoc = Owner.Location + CalcDrawOffset();
	scale = (180 - VSize(realLoc - HitLocation))/180;
	if (Other == Level)
	{
		a = Spawn(class'ut_RingExplosion',,,HitLocation+HitNormal, Rotator(HitNormal));
   	a.DrawScale=0.50;
   	a.RemoteRole = ROLE_None;
   	// HammerJump
		if (Owner.Physics == PHYS_Falling)
	   	Owner.Velocity.Z += 600;
	}
}

simulated function PlayFiring()
{
   TimesShot = TimesShot - 1;
   PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim( 'Shoot', 0.9, 0.05);
   bMuzzleFlash++;
}

simulated function PlayAltFiring()
{
	TimesShot = TimesShot - 2;
   PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim( 'Shoot', 0.9, 0.05);
   bMuzzleFlash++;
}

state NormalFire
{
	ignores Fire;

   function AnimEnd()
   {
      if (AnimSequence == 'Shoot' && TimesShot <= 0)
      {
         TimesShot = 8;
         PlayReloading();
      }
      else if (AnimSequence == 'Reload')
      {
         PlayAnim('Shake', 0.2, 0.0);   //Is this shake you meant?
         PlayOwnedSound(Sound'ThrowerGrind', SLOT_None, Pawn(Owner).SoundDampening*3.0);
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }

Begin:
   FinishAnim();
   ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

   if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0))
   {
      Gotostate('Idle');
   }
   Finish();
}

state ClientFiring
{
   //Same as in NormalFire state, but simulated
   simulated function AnimEnd()
   {
      if (AnimSequence == 'Shoot' && TimesShot <= 0)
      {
         TimesShot = 8;
         PlayReloading();
      }
      else if (AnimSequence == 'Reload')
      {
         PlayAnim('Shake', 0.2, 0.0);   //Is this shake you meant?
         PlayOwnedSound(Sound'ThrowerGrind', SLOT_None, Pawn(Owner).SoundDampening*3.0);
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state ClientAltFiring
{
   simulated function AnimEnd()
   {
      if (AnimSequence == 'Shoot' && TimesShot <= 0)
      {
         TimesShot = 8;
         PlayReloading();
      }
      else if (AnimSequence == 'Reload')
      {
         PlayOwnedSound(Sound'ThrowerGrind', SLOT_None, Pawn(Owner).SoundDampening*3.0);
         PlayAnim('Shake', 0.2, 0.0);   //Is this shake you meant?
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state AltFiring
{
	ignores AltFire;

   function AnimEnd()
   {
      if (AnimSequence == 'Shoot' && TimesShot <= 0)
      {
         TimesShot = 8;
         PlayReloading();
      }
      else if (AnimSequence == 'Reload')
      {
         PlayOwnedSound(Sound'ThrowerGrind', SLOT_None, Pawn(Owner).SoundDampening*3.0);
         PlayAnim('Shake', 0.2, 0.0);   //Is this shake you meant?
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }

Begin:
   FinishAnim();
   ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

   if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0))
   {
      Gotostate('Idle');
   }
   Finish();
}

simulated function PlayReloading()
{
   PlayOwnedSound(Sound'ThrowerReload', SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim('Reload',0.5,0.05);
}

simulated function PostRender(canvas C)
{
	local PlayerPawn P;
   local float Scale;
   local font CanvasFont;

   Super.PostRender(C);
   P = PlayerPawn(Owner);
   if ( (P != None) )
   {
		Scale = C.ClipX/640;
      C.SetPos(C.ClipX - 32 * Scale, C.ClipY - 192 * Scale);
      C.Style = ERenderStyle.STY_Translucent;
		C.DrawIcon(Texture'FFAmmoClip', Scale/2);
      C.Font = C.LargeFont;
		C.SetPos(C.ClipX - 22 * Scale, C.ClipY - 180 * Scale);
		C.DrawText(int(TimesShot), false);
	}
}

defaultproperties
{
   WeaponDescription="Classification: Salad Maker\n\nPrimary Fire: Some amount of salad is thrown forward with force and sausage.\n\nSecondary Fire: Can load up huge amount of salad to be thrown forward, enough to bury the opponent under it. Gives the owner a backlift, useful for jumping or saving from fall death."
   InstFlash=-0.400000
   InstFog=(X=650.000000,Y=450.000000,Z=190.000000)
   AmmoName=Class'FoodFightWeapons.SaladPack'
   PickupAmmoCount=18
   bWarnTarget=True
   bAltWarnTarget=True
   bSplashDamage=True
   FiringSpeed=1.000000
   FireOffset=(X=10.000000,Y=-11.000000,Z=-15.000000)
   ProjectileClass=Class'FoodFightWeapons.CucumberChunk'
   projectiles(0)=Class'FoodFightWeapons.CucumberChunk'
   projectiles(1)=Class'FoodFightWeapons.OnionsChunk'
   projectiles(2)=Class'FoodFightWeapons.CucumberChunk'
   projectiles(3)=Class'FoodFightWeapons.TomatoHalfChunk'
   projectiles(4)=Class'FoodFightWeapons.TomatoSliceChunk'
   projectiles(5)=Class'FoodFightWeapons.Lettuce1'
   projectiles(6)=Class'FoodFightWeapons.Lettuce2'
   projectiles(7)=Class'FoodFightWeapons.Lettuce3'
   projectiles(8)=Class'FoodFightWeapons.Lettuce4'
   //projectiles(9)=Class'FoodFightWeapons.OnionsChunk'

   aimerror=600.000000
   shakemag=350.000000
   shaketime=0.150000
   shakevert=8.500000
   AIRating=0.750000
   FireSound=throwerfireB
   AltFireSound=throwerfireA
   CockingSound=Sound'UnrealI.flak.load1'
   SelectSound=Sound'UnrealI.flak.pdown'
   Misc2Sound=Sound'UnrealI.flak.Hidraul2'
   DeathMessage="%o was buried under the load of %k's salad."
   NameColor=(G=96,B=0)
   bDrawMuzzleFlash=True
   MuzzleScale=2.000000
   FlashY=0.160000
   FlashO=0.015000
   FlashC=0.100000
   FlashLength=0.020000
   FlashS=256
   MFTexture=Texture'Botpack.Skins.Flakmuz'
   AutoSwitchPriority=8
   InventoryGroup=8
   PickupMessage="You got the Salad Thrower."
   ItemName="Salad Thrower"
   PlayerViewOffset=(X=1.500000,Y=-1.000000,Z=-1.650000)
   PlayerViewMesh=SaladThrowerUpdate
   PlayerViewScale=1.200000
   BobDamping=0.972000
   PickupViewMesh=SaladThrowerPickup
   Mesh=LodMesh'FoodFightWeapons.SaladThrowerPickup'
   ThirdPersonMesh=SaladThrowerThird
   StatusIcon=ThrowerIcon
   bMuzzleFlashParticles=True
   MuzzleFlashStyle=STY_Translucent
   MuzzleFlashMesh=LodMesh'Botpack.muzzFF3'
   MuzzleFlashScale=0.400000
   MuzzleFlashTexture=Texture'Botpack.Skins.MuzzyFlak'
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
   Icon=Texture'Botpack.Icons.UseFlak'
   bNoSmooth=False
   CollisionRadius=32.000000
   CollisionHeight=23.000000
   LightBrightness=228
   LightHue=30
   LightSaturation=71
   LightRadius=14
   TimesShot=8
}
