

class SauceStream extends ShockBeam;

#exec TEXTURE IMPORT NAME=Sauce FILE=Textures/Sauce.BMP

var vector MoveAmount;
var int NumPuffs;

replication
{
   unreliable if( Role==ROLE_Authority )
      MoveAmount, NumPuffs;
}

simulated function Tick( float DeltaTime )
{
   if ( Level.NetMode  != NM_DedicatedServer )
   {
      ScaleGlow = (Lifespan/Default.Lifespan)*1.0;
      AmbientGlow = ScaleGlow * 210;
   }
}


simulated function PostBeginPlay()
{
   if ( Level.NetMode != NM_DedicatedServer )
      SetTimer(0.05, false);
}

simulated function Timer()
{
   local SauceStream r;
    
   if (NumPuffs>0)
   {
      r = Spawn(class'SauceStream',,,Location+MoveAmount);
      r.RemoteRole = ROLE_None;
      r.NumPuffs = NumPuffs -1;
      r.MoveAmount = MoveAmount;
   }
}

defaultproperties
{
   bUnlit=true
   Physics=PHYS_Rotating
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=0.270000
   Rotation=(Roll=20000)
   DrawType=DT_Mesh
   Style=STY_Translucent
   Texture=Sauce
   Mesh=Mesh'Botpack.Shockbm'
   DrawScale=0.440000
   bParticles=True
   bMeshCurvy=False
   bFixedRotationDir=True
   RotationRate=(Roll=1000000)
   DesiredRotation=(Roll=20000)
}
