
class SaucierHitEffect extends UT_HeavyWallHitEffect;

var vector SurfaceNormal;

simulated function SpawnEffects()
{
   local Actor A;
   local int j;
   local int NumSparks;
   local vector Dir;

   if ( Level.NetMode != NM_DedicatedServer )
   {
      spawn(class'RedMark',,,Location, rotator(SurfaceNormal));
   	Spawn(class'RedGelPuff',,,Location+SurfaceNormal*8);
	}

   NumSparks = rand(MaxSparks + 3);

   Dir = Vector(Rotation);

   Spawn(class'RedMark');
   A = Spawn(class'UT_SpriteSmokePuff',,,Location + 8 * Vector(Rotation));
   A.RemoteRole = ROLE_None;

   if ( Region.Zone.bWaterZone || Level.bDropDetail )
      return;
   if ( FRand() < 0.4 )
      Spawn(class'UT_Sparks');
   if ( NumSparks > 0 )
      for (j=0; j<NumSparks; j++)
         spawn(class'UT_Spark',,,Location + 8 * Vector(Rotation));
}

defaultproperties
{
   ChipOdds=+0.5
   MaxSparks=4
   MaxChips=6
   DrawScale=0.00001
}
