
class ToastChips extends BulletImpact;

var() int MaxChips, MaxSparks;
var float ChipOdds;
var rotator RealRotation;

replication
{
	unreliable if( Role==ROLE_Authority )
		RealRotation;
}

simulated function SpawnSound()
{
}

simulated function SpawnEffects()
{
	local Actor A;
	local int j;
	local int NumSparks;

	if ( Role == ROLE_Authority )
		RealRotation = Rotation;
	else
		SetRotation(RealRotation);

	SpawnSound();

	NumSparks = rand(MaxSparks);
	if ( !Level.bDropDetail )
		for ( j=0; j<MaxChips; j++ )
			if ( FRand() < ChipOdds ) 
			{
				NumSparks--;
				A = spawn(class'Chip');
				if ( A != None )
				{
					A.RemoteRole = ROLE_None;
               a.velocity.z = a.velocity.z + 460;a.drawscale=0.1;a.lifespan=40.0;
				}
			}
}

Auto State StartUp
{
	simulated function Tick(float DeltaTime)
	{
		if ( Instigator != None )
			MakeNoise(0.3);
		SpawnEffects();
		Disable('Tick');
	}
}

defaultproperties
{
    MaxChips=40
    ChipOdds=1.00
    bNetOptional=True
    DrawScale=2.00
}