//=============================================================================
// Canopener
//=============================================================================
class Canopener extends FFWeapon;

var int currentAmmo;
var() localized class<ammo> AmmoNames[3];
var int currentAmmoBeforeTryingSwitch;
var Ammo ammoBeforeTryingSwitch;

var() int hitdamage;
var  float AltAccuracy;
var bool bFirstFire;
var() texture MuzzleFlashVariations[5];

////////////////////////////////////////////////////
//////////////////Functions/////////////////////////
////////////////////////////////////////////////////
function bool HandlePickupQuery( inventory Item )
{
	local Pawn P;
	local Ammo ammunition;
	local int OldAmmo;
	if ( (Item.class == class) ) 
	{
		if ( Weapon(item).bWeaponStay && (!Weapon(item).bHeldItem || Weapon(item).bTossedOut) )
			return true;
		P = Pawn(Owner);
		ammunition = Ammo(p.FindInventoryType(Weapon(Item).AmmoName));
		if ( ammunition != None ) {
			OldAmmo = ammunition.AmmoAmount;
			if ( ammunition.AddAmmo(Weapon(Item).PickUpAmmoCount) && (OldAmmo == 0) 
			       && (P.Weapon.class != item.class) && !P.bNeverSwitchOnPickup ) {
				WeaponSet(P);
			}
		}
		else
		{
			ammunition = Spawn(Weapon(Item).AmmoName);	// Create ammo type required		
			P.AddInventory(ammunition);		// and add to player's inventory
			ammunition.BecomeItem();
			ammunition.AmmoAmount = PickUpAmmoCount; 
			ammunition.GotoState('Loaded');
		}
		if (!bWeaponUp && (AmmoType == None || AmmoType.AmmoAmount == 0)) {
			switchAmmo(1);
		}
		P.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
		Item.PlaySound(Item.PickupSound);
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		Item.SetRespawn();
		return true;
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function Weapon WeaponChange( byte F )
{	
	local Pawn P;
	P = Pawn(Owner);
	if(InventoryGroup == F ) {
		if ((AmmoType != none && AmmoType.AmmoAmount > 0) || switchAmmo(1)) {
			return self;
		} else {
			return none;
		}
	}
	super.WeaponChange(F);
}

simulated function AnimEnd()
{
	if ( (Level.NetMode == NM_Client) && (Mesh != PickupViewMesh) )
	{
		PlaySelect();
	}
	else
		Super.AnimEnd();
}

// Return the switch priority of the weapon (normally AutoSwitchPriority, but may be
// modified by environment (or by other factors for bots)
function float SwitchPriority() 
{
	local float temp;
	local int bTemp;

	if ( !Owner.IsA('PlayerPawn') )
		return RateSelf(bTemp);
	else if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
	{
		if ( Pawn(Owner).Weapon == self )
			return -0.5;
		else
			return -1;
	}
	else
		return AutoSwitchPriority;
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;
	local vector realLoc;

	realLoc = Owner.Location + CalcDrawOffset();
	s = Spawn(class'UT_ShellCase',, '', realLoc + 20 * X + FireOffset.Y * Y + Z);
	if ( s != None )
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	if ((Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( FRand() < 0.2 )
			X *= 5;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, MyDamageType);
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
		else
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);

	}		
	ProcessTraceHitEffect(Other, ConsumableAmmo(AmmoType), HitLocation, HitNormal);
}

function setHand(float Hand)
{
	super.setHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'AutoML';
	else
		Mesh = mesh'AutoMR';
}


function TraceFire( float Accuracy )
{
	local vector RealOffset;

	RealOffset = FireOffset;
	FireOffset *= 0.35;
	if ( Owner.IsA('Bot') && !Bot(Owner).bNovice )
		Accuracy = FMax(Accuracy, 0.45);
	Super.TraceFire(Accuracy);
	FireOffset = RealOffset;
}

function Fire(float Value)
{
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) )
	{
		GotoState('NormalFire');
		bCanClientFire = true;
		bPointing=True;
		ClientFire(value);
		Pawn(Owner).PlayRecoil(FiringSpeed);
		TraceFire(0.2);
	}
}

simulated function PlayFiring()
{
	PlayOwnedSound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	bMuzzleFlash++;
	PlayAnim('Shoot', RefireRate, 0.02);
}

function AltFire( float Value )
{
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
		currentAmmo=0;
	}
	else {
		Gotostate('AltFiring');
	}
}

function bool switchAmmo(int tries) {
	local Pawn p;
	if( bWeaponUp ) {
		PlayAnim('T2', AltRefireRate, 0.02);
	}
	if (tries == 1) {
		ammoBeforeTryingSwitch = AmmoType;
		currentAmmoBeforeTryingSwitch = currentAmmo;
	}
	p = Pawn(Owner);
	if(tries > 2) {
		AmmoType = ammoBeforeTryingSwitch;
		currentAmmo = currentAmmoBeforeTryingSwitch;
		p.ClientMessage("No more ammo!!", 'Pickup');
		return false;
	}
	if(currentAmmo == 2) {
		currentAmmo = -1;
	}
	currentAmmo++;
	AmmoType = Ammo(p.FindInventoryType(AmmoNames[currentAmmo]));
	if(AmmoType == None || AmmoType.AmmoAmount <= 0) {
		return switchAmmo(tries + 1);
	} else {
		ammoBeforeTryingSwitch.Gotostate('Idle2');
		AmmoType.Gotostate('Active');
		p.ClientMessage("Ammo switched to"@AmmoType.ItemName);
		PlayOwnedSound(AltFireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
		AmmoName = AmmoNames[currentAmmo];
		if (currentAmmo == 0) {
			RefireRate=0.800000;
			HitDamage=17;
		} else
		if (currentAmmo == 1) {
			RefireRate=1.500000;
			HitDamage=10;
		} else
		if (currentAmmo == 2) {
			RefireRate=0.400000;
			HitDamage=100;
		}
		return true;
	}
}

function GiveAmmo(Pawn p) {
	super.GiveAmmo(p);
	switchAmmo(1);
}
///////////////////////////////////////////////////////
////////Events ////////////////////////////////////////
///////////////////////////////////////////////////////
event float BotDesireability(Pawn Bot)
{
	local Enforcer AlreadyHas;
	local float desire;

	desire = MaxDesireability + Bot.AdjustDesireFor(self);
	if ( (!bHeldItem || bTossedOut) && bWeaponStay )
		return 0;
	if ( (Bot.Weapon == None) || (Bot.Weapon.AIRating <= 0.4) )
		return 2*desire;
	return desire;
}

simulated event RenderOverlays(canvas Canvas)
{
	local PlayerPawn PlayerOwner;
	local int realhand;

	if ( (bMuzzleFlash > 0) && !Level.bDropDetail )
		MFTexture = MuzzleFlashVariations[Rand(5)];
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
			return;
		realhand = PlayerOwner.Handedness;
		if (  (Level.NetMode == NM_Client) && (realHand == 2) )
		{
			bHideWeapon = true;
			return;
		}
		if ( !bHideWeapon )
		{
			if ( Mesh == mesh'AutoML' )
				PlayerOwner.Handedness = 1;
		}
	}
	if ( (PlayerOwner == None) || (PlayerOwner.Handedness == 0) )
	{
		if ( AnimSequence == 'Shot2' )
		{
			FlashO = -2 * Default.FlashO;
			FlashY = Default.FlashY * 2.5;
		}
		else
		{
			FlashO = 1.9 * Default.FlashO;
			FlashY = Default.FlashY;
		}
	}
	else if ( AnimSequence == 'Shot2' )
	{
		FlashO = Default.FlashO * 0.3;
		FlashY = Default.FlashY * 2.5;
	}
	else
	{
		FlashO = Default.FlashO;
		FlashY = Default.FlashY;
	}
	Super.RenderOverlays(Canvas);
	if ( PlayerOwner != None )
		PlayerOwner.Handedness = realhand;
}
////////////////////////////////////////////////////////
/////////////////////States/////////////////////////////
////////////////////////////////////////////////////////
state Active
{
	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) ) 
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}


Begin:
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	bCanClientFire = true;
	if ( (Level.Netmode != NM_Standalone) && (Owner != None)
		&& Owner.IsA('TournamentPlayer')
		&& (PlayerPawn(Owner).Player != None)
		&& !PlayerPawn(Owner).Player.IsA('ViewPort') )
	{
		if ( Pawn(Owner).bFire != 0 )
			TournamentPlayer(Owner).SendFire(self);
		else if ( !bChangeWeapon )
			TournamentPlayer(Owner).UpdateRealWeapon(self);
	} 
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire, Animend;
End:
bWeaponUp = False;
}

state Idle
{
	
	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}
	
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) && !switchAmmo(1)) {
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	}
	if ( Pawn(Owner).bFire!=0 ) Global.Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) Global.AltFire(0.0);	
}

state NormalFire
{
ignores Fire, AltFire;

Begin:
	FinishAnim();
	Finish();
}


state AltFiring {
	ignores AltFire;

Begin:
	switchAmmo(1);
End:
	Gotostate('Active');
}

// End Class
//=============================================================================

defaultproperties
{
     ItemName="Canopener"
     PickupMessage="You picked up a Canopener!"
     hitdamage=17
     AmmoNames(0)=Class'FoodFightWeapons.KidneyBeanCan'
     AmmoNames(1)=Class'FoodFightWeapons.SweetCherryCan'
     AmmoNames(2)=Class'FoodFightWeapons.HalapenjoCan'
     AmmoName=Class'FoodFightWeapons.KidneyBeanCan'
     currentAmmo=0;
     MuzzleFlashVariations(0)=Texture'Botpack.Skins.Muz1'
     MuzzleFlashVariations(1)=Texture'Botpack.Skins.Muz2'
     MuzzleFlashVariations(2)=Texture'Botpack.Skins.Muz3'
     MuzzleFlashVariations(3)=Texture'Botpack.Skins.Muz4'
     MuzzleFlashVariations(4)=Texture'Botpack.Skins.Muz5'
     WeaponDescription="Classification: Tin can opener\n\nPrimary Fire: Based on the ammo type chosen, fires a single, accurate bean to the opponent.\n\nSecondary Fire: Switch ammo to any one of the three types - Kidney beans, Sweet cherry and Halapenjo. \n\nTechniques: \n Kidney beans - normal mode.\n The sweet cherry - Many bullets and fast firing mode, but less damage as the beans.\n Halapenjo (very rare) - Only 7 bullets, but one shot, one kill."
     InstFlash=-0.200000
     InstFog=(X=325.000000,Y=225.000000,Z=95.000000)
     PickupAmmoCount=30
     bInstantHit=True
     bAltInstantHit=True
     FiringSpeed=1.500000
     FireOffset=(Y=-10.000000,Z=-4.000000)
     MyDamageType=shot
     shakemag=200.000000
     shakevert=4.000000
     AIRating=0.250000
     RefireRate=0.800000
     AltRefireRate=0.870000
     FireSound=Sound'Botpack.enforcer.E_Shot'
     AltFireSound=Sound'Botpack.enforcer.Cocking'
     CockingSound=Sound'Botpack.enforcer.Cocking'
     SelectSound=Sound'Botpack.enforcer.Cocking'
     DeathMessage="%k emptied whole can of beans over %o with the %w."
     NameColor=(R=200,G=200)
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashY=0.100000
     FlashO=0.020000
     FlashC=0.035000
     FlashLength=0.020000
     FlashS=128
     MFTexture=Texture'Botpack.Skins.Muz1'
     AutoSwitchPriority=2
     InventoryGroup=2
     PlayerViewOffset=(X=3.300000,Y=-2.000000,Z=-3.000000)
     PlayerViewMesh=LodMesh'Botpack.AutoML'
     PickupViewMesh=LodMesh'Botpack.MagPick'
     ThirdPersonMesh=LodMesh'Botpack.AutoHand'
     StatusIcon=Texture'Botpack.Icons.UseAutoM'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzEF3'
     MuzzleFlashScale=0.080000
     MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseAutoM'
     bHidden=True
     Mesh=LodMesh'Botpack.MagPick'
     bNoSmooth=False
     CollisionRadius=24.000000
     CollisionHeight=12.000000
     Mass=15.000000
}
