class ConsumableAmmo extends TournamentAmmo
		abstract;

var int healthGained;
var int comboState;
var FFWeapon myWeapon;
var class<FFProjectileDeco> spawnAtHitLoc;
var int AmountPerCan;
var int remainingInCan;
var class<Scorch> splat;

function bool UseAmmo(int AmountNeeded)
{
	if (AmmoAmount < AmountNeeded)
	{
		return False;   // Can't do it
	}
	if (remainingInCan == 0) {
		myWeapon.PlayReloading();
		if(AmountPerCan >= AmmoAmount) {
			remainingInCan = AmmoAmount;
		} else {
			remainingInCan = AmountPerCan;
		}
		return False;
	} else {
		remainingInCan -= AmountNeeded;
		AmmoAmount -= AmountNeeded;
	}
	return True;
}

state Active 
{
	function Tick (float deltaTime) {
		local PlayerPawn p;
		if (comboState == 0 && Pawn(Owner).weapon.bWeaponUp) {
			comboState = 1;
			myWeapon = FFWeapon(Pawn(Owner).weapon);
		} 
		if ( Owner.IsA('PlayerPawn') && comboState != 0 )
		{
			p = PlayerPawn(Owner);
			if(comboState == 5) {
				comboState=1;
				if(p.Health < p.Default.Health)
					if(UseAmmo(1)) {
						p.Health = p.Health + healthGained;
						if(p.Health > p.Default.Health) {
							p.Health = p.Default.Health;
						}
					}
			}
			if(p.bWasForward && comboState == 4) {
				comboState = 5;
			}
			if(p.bWasBack && comboState == 3) {
				comboState = 4;
			}
			if(p.bWasForward && comboState == 2) {
				comboState = 3;
			}
			if(p.bWasBack && comboState == 1) {
				comboState = 2;
			}
		}
	}
	function EndState() {
		comboState = 0;
	}
}
defaultproperties
{
	healthGained=10
	comboState=0
	splat=class'Pock'
}
