//=============================================================================
// PeanutGun, MTracer for making the effect for bean
//=============================================================================
class PeanutGun extends FFWeapon;

//Old
/*
#exec MESH IMPORT MESH=PeanutGunAnim ANIVFILE=MODELS\PnutGunAni_a.3d DATAFILE=MODELS\PnutGunAni_d.3d X=0 Y=0 Z=0 UnMirror=1 
#exec MESH ORIGIN MESH=PeanutGunAnim X=10 Y=-10 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=All     STARTFRAME=0   NUMFRAMES=91
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Select  STARTFRAME=84   NUMFRAMES=6 GROUP=Select
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Still   STARTFRAME=91  NUMFRAMES=1
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Shoot  STARTFRAME=1  NUMFRAMES=14
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Idle    STARTFRAME=90  NUMFRAMES=1
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Down    STARTFRAME=78  NUMFRAMES=5
#exec MESH SEQUENCE MESH=PeanutGunAnim SEQ=Reload    STARTFRAME=15  NUMFRAMES=63
*/

#exec MESH IMPORT MESH=P-NutGunAnimated ANIVFILE=MODELS\P-NutGunAnimated_a.3d DATAFILE=MODELS\P-NutGunAnimated_d.3d X=0 Y=0 Z=0 UnMirror=1
#exec MESH ORIGIN MESH=P-NutGunAnimated X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=All STARTFRAME=0 NUMFRAMES=73
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=Still STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=3Shot STARTFRAME=2 NUMFRAMES=11
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=AutoFire STARTFRAME=13 NUMFRAMES=7
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=Reload STARTFRAME=19 NUMFRAMES=45
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=Deselect STARTFRAME=63 NUMFRAMES=5
#exec MESH SEQUENCE MESH=P-NutGunAnimated SEQ=Select STARTFRAME=67 NUMFRAMES=7

#exec TEXTURE IMPORT NAME=PgunUVmap FILE=PgunUVmap.pcx GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=HandGlove FILE=SimpleGloveHandTexture.pcx GROUP="Skins" LODSET=2

#exec MESHMAP NEW MESHMAP=P-NutGunAnimated MESH=P-NutGunAnimated
#exec MESHMAP SCALE MESHMAP=P-NutGunAnimated X=0.1 Y=0.1 Z=0.2
// old: X=0.017 Y=0.017 Z=0.034
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimated NUM=1 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimated NUM=2 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimated NUM=3 TEXTURE=HandGlove

// Left Hand
#exec MESH IMPORT MESH=P-NutGunAnimatedL ANIVFILE=MODELS\P-NutGunAnimated_a.3d DATAFILE=MODELS\P-NutGunAnimated_d.3d
#exec MESH ORIGIN MESH=P-NutGunAnimatedL X=10 Y=10 Z=0 YAW=128 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=All STARTFRAME=0 NUMFRAMES=73
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=Still STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=3Shot STARTFRAME=2 NUMFRAMES=11
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=AutoFire STARTFRAME=13 NUMFRAMES=7
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=Reload STARTFRAME=19 NUMFRAMES=45
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=Deselect STARTFRAME=63 NUMFRAMES=5
#exec MESH SEQUENCE MESH=P-NutGunAnimatedL SEQ=Select STARTFRAME=67 NUMFRAMES=7

#exec MESHMAP SCALE MESHMAP=P-NutGunAnimatedL X=0.017 Y=0.017 Z=0.034
// Double check this scale setting
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimatedL NUM=1 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimatedL NUM=2 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=P-NutGunAnimatedL NUM=3 TEXTURE=HandGlove

// Is this needed or is it a reimport?
#exec TEXTURE IMPORT NAME=Muz1 FILE=MODELS\muz1.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz2 FILE=MODELS\muz2.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz3 FILE=MODELS\muz3.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz4 FILE=MODELS\muz4.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz5 FILE=MODELS\muz5.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz6 FILE=MODELS\muz6.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz7 FILE=MODELS\muz7.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz8 FILE=MODELS\muz8.PCX GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Muz9 FILE=MODELS\muz9.PCX GROUP="Skins" LODSET=2

// Pickup
/*   OLD
#exec MESH IMPORT MESH=PeanutGunPickup ANIVFILE=MODELS\PnutGunPickUp_a.3d DATAFILE=MODELS\PnutGunPickUp_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=PeanutGunPickup X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PeanutGunPickup SEQ=All     STARTFRAME=0  NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=PeanutGunPickup MESH=PeanutGunPickup
#exec MESHMAP SCALE MESHMAP=PeanutGunPickup X=0.25 Y=0.25 Z=0.5
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunPickup NUM=1 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunPickup NUM=2 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunPickup NUM=3 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunPickup NUM=4 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunPickup NUM=5 TEXTURE=PgunUVmap
*/

#exec MESH IMPORT MESH=P-NutGunPickUp ANIVFILE=MODELS\P-NutGunPickUp_a.3d DATAFILE=MODELS\P-NutGunPickUp_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=P-NutGunPickUp X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=P-NutGunPickUp SEQ=All STARTFRAME=0 NUMFRAMES=1
//#exec MESH SEQUENCE MESH=P-NutGunPickUp SEQ=??? STARTFRAME=0 NUMFRAMES=1

#exec MESH IMPORT MESH=PeanutGunHand ANIVFILE=MODELS\P-NutGunPickUp_a.3d DATAFILE=MODELS\P-NutGunPickUp_d.3d X=0 Y=0 Z=0 LODSTYLE=10
#exec MESH ORIGIN MESH=PeanutGunHand X=25 Y=-4 Z=-5 YAW=135 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=PeanutGunHand SEQ=All     STARTFRAME=0  NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=PeanutGunHand MESH=PeanutGunHand
#exec MESHMAP SCALE MESHMAP=PeanutGunHand X=0.15 Y=0.15 Z=0.30
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunHand NUM=1 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunHand NUM=2 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunHand NUM=3 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunHand NUM=4 TEXTURE=PgunUVmap
#exec MESHMAP SETTEXTURE MESHMAP=PeanutGunHand NUM=5 TEXTURE=PgunUVmap

#exec TEXTURE IMPORT NAME=IconMini FILE=TEXTURES\HUD\WpnMini.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseMini FILE=TEXTURES\HUD\UseMini.PCX GROUP="Icons" MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\Minigun\RegFire.Wav" NAME=M2RegFire GROUP="Minigun2"
#exec AUDIO IMPORT FILE="Sounds\Minigun\AltFire.Wav" NAME=M2AltFire GROUP="Minigun2"
#exec AUDIO IMPORT FILE="Sounds\Minigun\WindDown.Wav" NAME=M2WindDown GROUP="Minigun2"

#exec MESH IMPORT MESH=MuzzFlash3 ANIVFILE=MODELS\muzzle2_a.3d DATAFILE=MODELS\Muzzle2_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=muzzFlash3 MINVERTS=8 STRENGTH=0.7 ZDISP=800.0 

#exec MESH ORIGIN MESH=MuzzFlash3 X=0 Y=940 Z=0 YAW=64
#exec MESH SEQUENCE MESH=MuzzFlash3 SEQ=All                      STARTFRAME=0 NUMFRAMES=9
#exec MESH SEQUENCE MESH=MuzzFlash3 SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=9
#exec MESHMAP NEW    MESHMAP=MuzzFlash3 MESH=MuzzFlash3
#exec MESHMAP SCALE MESHMAP=MuzzFlash3 X=0.08 Y=0.08 Z=0.16
#exec TEXTURE IMPORT NAME=Muzzy FILE=MODELS\Muzzy.PCX GROUP=Skins

var float ShotAccuracy, LastShellSpawn;
var int Count;
var bool bOutOfAmmo, bFiredShot;
var() texture MuzzleFlashVariations[10];

////////////////////////////////////////////////////
//////////////////Functions/////////////////////////
////////////////////////////////////////////////////
function setHand(float Hand)
{
	if ( Hand == 2 )
	{
		FireOffset.Y = 0;
		bHideWeapon = true;
		return;
	}
	else
		bHideWeapon = false;
	PlayerViewOffset = Default.PlayerViewOffset * 100;
	FireOffset.Y = Hand * Default.FireOffset.Y;
	PlayerViewOffset.Y *= Hand;
	if ( Hand == 1 )
		Mesh = mesh(DynamicLoadObject("P-NutGunAnimatedL", class'Mesh'));
	else
	{
		Mesh = mesh'P-NutGunAnimated';
		if ( Hand == 0 )
		{
			PlayerViewOffset.X = Default.PlayerViewOffset.X * 95;
			PlayerViewOffset.Z = Default.PlayerViewOffset.Z * 105;
		}
	}
}


function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}

	dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location); 
	bUseAltMode = 1;
	if ( dist > 1200 )
	{
		if ( dist > 1700 )
			bUseAltMode = 0;
		return (AIRating * FMin(Pawn(Owner).DamageScaling, 1.5) + FMin(0.0001 * dist, 0.3)); 
	}
	AIRating *= FMin(Pawn(Owner).DamageScaling, 1.5);
	return AIRating;
}


function GenerateBullet()
{
	LightType = LT_Steady;
	bFiredShot = true;
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ClientInstantFlash( -0.2, vect(325, 225, 95));
	if ( AmmoType.UseAmmo(1) ) 
		TraceFire(ShotAccuracy);
	else
		GotoState('FinishFire');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (10000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	Count++;
	if ( Count == 3 )
	{
		Count = 0;
		if ( VSize(HitLocation - StartTrace) > 250 )
			Spawn(class'MTracer',,, StartTrace + 96 * AimDir,rotator(EndTrace - StartTrace));
	}
	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local int rndDam;

	if ( (Other!=self) && (Other!=Owner) && (Other != None) ) 
	{
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9); 
		else
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);

		if ( Other.IsA('Bot') && (FRand() < 0.2) )
			Pawn(Other).WarnTarget(Pawn(Owner), 500, X);
		rndDam = 9 + Rand(6);
		if ( FRand() < 0.2 )
			X *= 2.5;
		Other.TakeDamage(rndDam, Pawn(Owner), HitLocation, rndDam*500.0*X, MyDamageType);
	}
	ProcessTraceHitEffect(Other, ConsumableAmmo(AmmoType), HitLocation, HitNormal);
}

function Fire( float Value )
{
	Enable('Tick');
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(0) )
	{
		SoundVolume = 255*Pawn(Owner).SoundDampening;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		bCanClientFire = true;
		bPointing=True;
		ShotAccuracy = 0.4;
		ClientFire(value);
		GotoState('NormalFire');
	}
	else GoToState('Idle');
}

function AltFire( float Value )
{
	Enable('Tick');
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(0) )
	{
		bPointing=True;
		bCanClientFire = true;
		ShotAccuracy = 0.2;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		SoundVolume = 255*Pawn(Owner).SoundDampening;		
		ClientAltFire(value);	
		GoToState('AltFiring');		
	}
	else GoToState('Idle');	
}

simulated function PlayFiring()
{	
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	PlayAnim('Shoot',1 + 0.6 * FireAdjust, 0.1);
	AmbientGlow = 250;
	AmbientSound = FireSound;
	bSteadyFlash3rd = true;
}

simulated function PlayAltFiring()
{
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	PlayAnim('Shoot',1 + 0.3 * FireAdjust, 0.1);
	AmbientGlow = 250;
	AmbientSound = FireSound;
	bSteadyFlash3rd = true;
}

////////////////////////////////////////////////////
//////////////////States////////////////////////////
////////////////////////////////////////////////////
state FinishFire
{
	function Fire(float F) {}
	function AltFire(float F) {}

	function ForceFire()
	{
		bForceFire = true;
	}

	function ForceAltFire()
	{
		bForceAltFire = true;
	}

Begin:
	FinishAnim();
	Finish();
}

state NormalFire
{
	function Tick( float DeltaTime )
	{
		if (Owner==None) 
			AmbientSound = None;
		if (Pawn(Owner).bFire==0 && Pawn(Owner).bAltFire==0)
			GotoState('FinishFire');
	}

	function AnimEnd()
	{
		LoopAnim('Shoot',1.9);
		if (Pawn(Owner).Weapon != self) GotoState('');
		else if ( Pawn(Owner).bAltFire!=0 && AmmoType.AmmoAmount>0)
			Global.AltFire(0);
	}

	function BeginState()
	{
		AmbientGlow = 250;
		AmbientSound = FireSound;
		bSteadyFlash3rd = true;
		Super.BeginState();
	}	

	function EndState()
	{
		bSteadyFlash3rd = false;
		AmbientGlow = 0;
		LightType = LT_None;
		AmbientSound = None;
		Super.EndState();
	}

Begin:
	Sleep(0.2);
	GenerateBullet();
	Goto('Begin');
}

state ClientFiring
{
	simulated function AnimEnd()
	{
		if ( (Pawn(Owner) == None) || (AmmoType.AmmoAmount <= 0) )
		{
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else if ( Pawn(Owner).bFire != 0 )
			Global.ClientFire(0);
		else if ( Pawn(Owner).bAltFire != 0 )
			Global.ClientAltFire(0);
		else
		{
			GotoState('ClientFinish');
		}
	}

	simulated function BeginState()
	{
		AmbientSound = FireSound;
		bSteadyFlash3rd = true;
	}

	simulated function EndState()
	{
		bSteadyFlash3rd = false;
		Super.EndState();
	}
}

state ClientFinish
{
	simulated function bool ClientFire(float Value)
	{
		bForceFire = bForceFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		return bForceFire;
	}

	simulated function bool ClientAltFire(float Value)
	{
		bForceAltFire = bForceAltFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		return bForceAltFire;
	}

	simulated function AnimEnd()
	{
		if ( bCanClientFire && (PlayerPawn(Owner) != None) && (AmmoType.AmmoAmount > 0) )
		{
			if ( bForceFire || (Pawn(Owner).bFire != 0) )
			{
				Global.ClientFire(0);
				return;
			}
			else if ( bForceAltFire || (Pawn(Owner).bAltFire != 0) )
			{
				Global.ClientAltFire(0);
				return;
			}
		}			
		GotoState('');
		Global.AnimEnd();
	}

	simulated function EndState()
	{
		bSteadyFlash3rd = false;
		bForceFire = false;
		bForceAltFire = false;
		AmbientSound = None;
	}

	simulated function BeginState()
	{
		bSteadyFlash3rd = false;
		bForceFire = false;
		bForceAltFire = false;
	}
}

state ClientAltFiring
{
	simulated function AnimEnd()
	{
		if ( (Pawn(Owner) == None) || (AmmoType.AmmoAmount <= 0) )
		{
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else if ( Pawn(Owner).bAltFire != 0 )
		{
			if ( (AnimSequence != 'Shoot') || !bAnimLoop )
			{	
				AmbientSound = AltFireSound;
				SoundVolume = 255*Pawn(Owner).SoundDampening;
				LoopAnim('Shoot',1.9);
			}
			else if ( AmbientSound == None )
				AmbientSound = FireSound;

			if ( Affector != None )
				Affector.FireEffect();
			if ( PlayerPawn(Owner) != None )
				PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		}
		else if ( Pawn(Owner).bFire != 0 )
			Global.ClientFire(0);
		else
		{
			bSteadyFlash3rd = false;
			GotoState('ClientFinish');
		}
	}

	simulated function BeginState()
	{
		bSteadyFlash3rd = true;
		AmbientSound = FireSound;
	}

	simulated function EndState()
	{
		bSteadyFlash3rd = false;
		Super.EndState();
	}
}

state AltFiring
{
	function Tick( float DeltaTime )
	{
		if (Owner==None) 
		{
			AmbientSound = None;
			GotoState('Pickup');
		}			

		if	( bFiredShot && ((pawn(Owner).bAltFire==0) || bOutOfAmmo) ) 
			GoToState('FinishFire');
	}

	function AnimEnd()
	{
		if ( (AnimSequence != 'Shoot') || !bAnimLoop )
		{	
			AmbientSound = AltFireSound;
			SoundVolume = 255*Pawn(Owner).SoundDampening;
			LoopAnim('Shoot',1.9);
		}
		else if ( AmbientSound == None )
			AmbientSound = FireSound;
		if ( Affector != None )
			Affector.FireEffect();
	}

	function BeginState()
	{
		Super.BeginState();
		AmbientSound = FireSound;
		AmbientGlow = 250;
		bFiredShot = false;
		bSteadyFlash3rd = true;
	}	

	function EndState()
	{
		bSteadyFlash3rd = false;
		AmbientGlow = 0;
		LightType = LT_None;
		AmbientSound = None;
		Super.EndState();
	}

Begin:
	Sleep(0.1);
	if ( AnimSequence == 'Shoot' )
		Goto('FastShoot');
	Goto('Begin');
FastShoot:
	Sleep(0.03);
	GenerateBullet();
	Sleep(0.03);
	GenerateBullet();
	Sleep(0.03);
	GenerateBullet();
	Goto('Begin');
}

state Idle
{

Begin:
	if (Pawn(Owner).bFire!=0 && AmmoType.AmmoAmount>0) Fire(0.0);
	if (Pawn(Owner).bAltFire!=0 && AmmoType.AmmoAmount>0) AltFire(0.0);	
	LoopAnim('Idle',0.2,0.9);
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	Disable('AnimEnd');	
}

// End Class
//=============================================================================

defaultproperties
{
     MuzzleFlashVariations(0)=Texture'Botpack.Skins.Muz1'
     MuzzleFlashVariations(1)=Texture'Botpack.Skins.Muz2'
     MuzzleFlashVariations(2)=Texture'Botpack.Skins.Muz3'
     MuzzleFlashVariations(3)=Texture'Botpack.Skins.Muz4'
     MuzzleFlashVariations(4)=Texture'Botpack.Skins.Muz5'
     MuzzleFlashVariations(5)=Texture'Botpack.Skins.Muz6'
     MuzzleFlashVariations(6)=Texture'Botpack.Skins.Muz7'
     MuzzleFlashVariations(7)=Texture'Botpack.Skins.Muz8'
     MuzzleFlashVariations(8)=Texture'Botpack.Skins.Muz9'
     MuzzleFlashVariations(9)=Texture'Botpack.Skins.Muz9'
     WeaponDescription="Classification: Peanut Gun"
     AmmoName=Class'FoodFightWeapons.PeanutCan'
     PickupAmmoCount=30
     bInstantHit=True
     bAltInstantHit=True
     bRapidFire=True
     FireOffset=(X=8.000000,Y=-5.000000,Z=-4.000000)
     MyDamageType=shot
     shakemag=135.000000
     shakevert=8.000000
     AIRating=0.730000
     RefireRate=0.990000
     AltRefireRate=0.990000
     FireSound=Sound'Botpack.minigun2.M2RegFire'
     AltFireSound=Sound'Botpack.minigun2.M2AltFire'
     SelectSound=Sound'UnrealI.Minigun.MiniSelect'
     Misc1Sound=Sound'Botpack.minigun2.M2WindDown'
     DeathMessage="%k's %w turned %o into a leaky sausage with peanuts."
     NameColor=(B=0)
     bDrawMuzzleFlash=True
     MuzzleScale=2.000000
     FlashY=0.180000
     FlashO=0.022000
     FlashC=0.006000
     FlashLength=0.200000
     FlashS=128
     MFTexture=Texture'Botpack.Skins.Muz9'
     AutoSwitchPriority=7
     InventoryGroup=7
     PickupMessage="You got the Peanut gun."
     ItemName="Peanut Gun"
     PlayerViewOffset=(X=2.100000,Y=-0.350000,Z=-1.700000)
     PlayerViewMesh=LodMesh'PeanutGunAnim'
     BobDamping=0.975000
     PickupViewMesh=LodMesh'FoodFightWeapons.PeanutGunPickup'
     ThirdPersonMesh=LodMesh'FoodFightWeapons.PeanutGunHand'
     StatusIcon=Texture'Botpack.Icons.UseMini'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.MuzzFlash3'
     MuzzleFlashScale=0.250000
     MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseMini'
     Mesh=LodMesh'FoodFightWeapons.PeanutGunPickup'
     bNoSmooth=False
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=34.000000
     CollisionHeight=8.000000
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=28
     LightSaturation=32
     LightRadius=6
}
