//=============================================================================
// Toastanator.
//=============================================================================
class Toastanator extends FFWeapon;

#exec MESH IMPORT MESH=BRifle2 ANIVFILE=MODELS\Biorifle2_a.3D DATAFILE=MODELS\BioRifle2_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BRifle2 X=0 Y=0 Z=0 YAW=67 ROLL=6 PITCH=0
#exec MESH SEQUENCE MESH=BRifle2 SEQ=All       STARTFRAME=0   NUMFRAMES=90
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Select    STARTFRAME=0   NUMFRAMES=22 RATE=45 GROUP=Select
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Still     STARTFRAME=22  NUMFRAMES=1
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Walking   STARTFRAME=23  NUMFRAMES=18
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Charging  STARTFRAME=41  NUMFRAMES=30
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Loaded    STARTFRAME=70  NUMFRAMES=1
#exec MESH SEQUENCE MESH=BRifle2 SEQ=UnLoading STARTFRAME=71  NUMFRAMES=1
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Fire      STARTFRAME=72  NUMFRAMES=9
#exec MESH SEQUENCE MESH=BRifle2 SEQ=Down      STARTFRAME=80  NUMFRAMES=10
#exec TEXTURE IMPORT NAME=JBRifle2 FILE=MODELS\Bio.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JBRifle21 FILE=MODELS\Bio1.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JBRifle22 FILE=MODELS\Bio2.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JBRifle23 FILE=MODELS\Bio3.PCX GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JBRifle24 FILE=MODELS\Bio4.PCX GROUP=Skins LODSET=2
#exec MESHMAP SCALE MESHMAP=BRifle2  X=0.0025 Y=0.0018 Z=0.005
#exec MESHMAP SETTEXTURE MESHMAP=BRifle2 NUM=0 TEXTURE=JBRifle21
#exec MESHMAP SETTEXTURE MESHMAP=BRifle2 NUM=1 TEXTURE=JBRifle22
#exec MESHMAP SETTEXTURE MESHMAP=BRifle2 NUM=2 TEXTURE=JBRifle23
#exec MESHMAP SETTEXTURE MESHMAP=BRifle2 NUM=3 TEXTURE=JBRifle24

#exec MESH IMPORT MESH=BRifle2Pick ANIVFILE=MODELS\Biopick_a.3D DATAFILE=MODELS\Biopick_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BRifle2Pick X=0 Y=0 Z=0 YAW=64
#exec MESH SEQUENCE MESH=BRifle2pick SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=BRifle2pick SEQ=Still  STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=BRifle2pick X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=BRifle2pick NUM=1 TEXTURE=JBRifle2

#exec MESH IMPORT MESH=BRifle23 ANIVFILE=MODELS\Biohand_a.3D DATAFILE=MODELS\Biohand_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BRifle23 X=15 Y=280 Z=-80 YAW=64 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=BRifle23 SEQ=All  STARTFRAME=0  NUMFRAMES=11
#exec MESH SEQUENCE MESH=BRifle23 SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=BRifle23 SEQ=Fire  STARTFRAME=1  NUMFRAMES=10
#exec MESHMAP SCALE MESHMAP=BRifle23 X=0.035 Y=0.035 Z=0.07
#exec MESHMAP SETTEXTURE MESHMAP=BRifle23 NUM=1 TEXTURE=JBRifle2

#exec TEXTURE IMPORT NAME=IconBio FILE=TEXTURES\HUD\WpnBio.PCX GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseBio FILE=TEXTURES\HUD\UseBio.PCX GROUP="Icons" MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\biorifle\biopowerupmix1.WAV" NAME="BioAltRep" GROUP="BioRifle"

var int breadCount;
var float totalTime;
var float ReloadDelay;
var int altMax;
////////////////////////////////////////////////////
//////////////////Functions/////////////////////////
////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;
	if ( (Owner != None) && (VSize(Owner.Velocity) > 10) )
		PlayAnim('Walking',0.3,0.3);
	else 
		TweenAnim('Still', 1.0);
	Enable('AnimEnd');
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local vector EnemyDir;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	bUseAltMode = 0;
	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	if ( EnemyDist > 1400 )
		return 0;

	bRetreating = ( ((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.6 );
	if ( (EnemyDist > 600) && (EnemyDir.Z > -0.4 * EnemyDist) )
	{
		// only use if enemy not too far and retreating
		if ( !bRetreating )
			return 0;

		return AIRating;
	}

	bUseAltMode = int( FRand() < 0.3 );

	if ( bRetreating || (EnemyDir.Z < -0.7 * EnemyDist) )
		return (AIRating + 0.18);
	return AIRating;
}

function float SuggestAttackStyle()
{
	return -0.3;
}

function float SuggestDefenseStyle()
{
	return -0.4;
}

function Fire(float Value) {
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) ) 
	{
		Gotostate('NormalFire');
		bCanClientFire = true;
		ClientFire(Value);
	}
}

simulated function PlayFiring()
{
	PlayOwnedSound(FireSound, SLOT_Misc, 1.7*Pawn(Owner).SoundDampening);	//shoot goop
	PlayAnim('Fire',0.4, 0.05);
}

function AltFire( float Value )
{
	bPointing=True;
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) ) 
	{
		GoToState('AltFiring');
		bCanClientFire = true;
		ClientAltFire(Value);
	}
}

simulated function PlayAltFiring()
{
	PlayOwnedSound(Sound'Botpack.BioRifle.BioAltRep', SLOT_Misc, 1.3*Pawn(Owner).SoundDampening);	 //loading goop	
	PlayAnim('Charging',0.24,0.05);
}


// Finish a firing sequence
function Finish()
{
	local bool bForce, bForceAlt;

	bForce = bForceFire;
	bForceAlt = bForceAltFire;
	bForceFire = false;
	bForceAltFire = false;

	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
	{
		Pawn(Owner).bAltFire = 0;
		Super.Finish();
	}
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if ( (Pawn(Owner).bFire!=0) || bForce )
		Global.Fire(0);
	else if ( (Pawn(Owner).bAltFire!=0) || bForceAlt )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}


////////////////////////////////////////////////////////
/////////////////////States/////////////////////////////
////////////////////////////////////////////////////////
state ClientAltFiring
{
	simulated function Tick(float DeltaTime)
	{
		if ( !bCanClientFire || (Pawn(Owner) == None) )
			GotoState('');
		else if ( Pawn(Owner).bAltFire == 0 )
		{
			PlayFiring();
		}
	}

	simulated function AnimEnd()
	{
		TweenAnim('Loaded', 0.5);
	}
}

state AltFiring
{
	ignores AnimEnd, AltFire;

	function Tick( float DeltaTime )
	{       
		totalTime += deltaTime;
		if ( totalTime > AltRefireRate )
		{
			totalTime = 0;
			if ( breadCount < altMax && AmmoType.UseAmmo(1))
			{
				breadCount += 1;
				if ( (PlayerPawn(Owner) == None) && (FRand() < 0.2) )
					GoToState('ShootLoad');
			}
		}
		if( (pawn(Owner).bAltFire==0) )
			GoToState('ShootLoad');
	}

	function BeginState()
	{       
		altMax = (ConsumableAmmo(AmmoType)).remainingInCan + 1;
		totalTime = 0;
		breadCount = 1;
	}

Begin:  
	FinishAnim();
}

state NormalFire
{
	ignores AnimEnd, Fire;

	function BeginState()
	{
		breadCount = 1;
		Gotostate('ShootLoad');
	}
}

state ShootLoad
{ ignores Fire, AltFire;
	function ForceFire()
	{
		bForceFire = true;
	}

	function ForceAltFire()
	{
		bForceAltFire = true;
	}

	function AnimEnd()
	{
		Finish();
	}

	function BeginState()
	{
		local int i; 
		for (i = 0 ; i < breadCount ; i++) {
			ProjectileFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
		}
		breadCount=0;
	}
Begin:
	Sleep(ReloadDelay);
	FinishAnim();
	Finish();
}


defaultproperties
{
     WeaponDescription="Classification: Used to make toasts at home\n\nPrimary Fire: Loads up a single toast and fires it when real hot.\n\nSecondary Fire: Can launch four hot and sweet looking toasts to take out the whole team at once.."
     AmmoName=Class'FoodFightWeapons.BreadPack'
     PickupAmmoCount=8
     bAltWarnTarget=True
     bRapidFire=False
     FiringSpeed=1.000000
     FireOffset=(X=12.000000,Y=-11.000000,Z=-6.000000)
     ProjectileClass=Class'FoodFightWeapons.BreadSlice'
     AltProjectileClass=Class'FoodFightWeapons.BreadSlice'
     AIRating=0.600000
     ReloadDelay=3.00000
     RefireRate=0.50000
     AltRefireRate=1.00000
     FireSound=Sound'UnrealI.BioRifle.GelShot'
     AltFireSound=Sound'UnrealI.BioRifle.GelShot'
     CockingSound=Sound'UnrealI.BioRifle.GelLoad'
     SelectSound=Sound'UnrealI.BioRifle.GelSelect'
     DeathMessage="%o was toasted.. %k makes really tasty stuff at home."
     AutoSwitchPriority=3
     InventoryGroup=4
     PickupMessage="You got the Toastanator."
     ItemName="Toastanator"
     PlayerViewOffset=(X=1.700000,Y=-0.850000,Z=-0.950000)
     PlayerViewMesh=LodMesh'Botpack.BRifle2'
     BobDamping=0.972000
     PickupViewMesh=LodMesh'Botpack.BRifle2Pick'
     ThirdPersonMesh=LodMesh'Botpack.BRifle23'
     StatusIcon=Texture'Botpack.Icons.UseBio'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseBio'
     Mesh=LodMesh'Botpack.BRifle2Pick'
     bNoSmooth=False
     CollisionHeight=19.000000
}
