
class RelicDeathInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=nskull FILE=Textures\nskull.bmp

function PostBeginPlay()
{
	Super.PostBeginPlay();
	//LoopAnim('Bob', 0.5);
}

function DropInventory()
{
	if ( Pawn(Owner).Health > 0 )
		Super.DropInventory();
	else
		Destroy();
}

function Destroyed()
{
	local Pawn Victim;
	local DeathWave DW;

	Victim = Pawn(Owner);

	if ( (Victim != None) && (Victim.Health <= 0) )
	{
	 	DW = Spawn(class'DeathWave', , , Victim.Location + vect(0,0,50), Victim.Rotation);
		DW.Instigator = Victim;
	}
	Super.Destroyed();
}

auto state Pickup
{
	function Landed(Vector HitNormal)
	{
		Super.Landed(HitNormal);
		//LoopAnim('Bob', 0.5);
	}
}

defaultproperties
{
    bRotatingPickup=True
    PickupMessage="Vengeance Relic: Nuclear blast on death!"
    PickupViewMesh=Mesh'oneupA'
    PickupViewScale=0.70
    PickupSound=Sound'GoRetribution'
    Icon=Texture'DeathTile'
    Mesh=Mesh'oneupA'
    MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.RedShield'
    MultiSkins(1)=Texture'nskull'
    CollisionHeight=40.00
    RotationRate=(Pitch=12250,Yaw=-12000,Roll=-12500),
}
