
class RelicRadiationInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=radrelic FILE=Textures\radrelic.bmp

var int PHealth, PArmor;
var int ShowCharge;
var config int bRespawnTime;

state Activated
{
	function endstate()
	{
		local Inventory S;
		local PlayerPawn P;
	
		P = PlayerPawn(Owner);
		//P.ReducedDamageType = '';

		bActive = false;
		
		PlaySound(DeActivateSound);

		Owner.SetDefaultDisplayProperties();
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			UT_Shieldbelt(S).MyEffect.bHidden = false;
		PHealth = 0;
		PArmor = 0;
	}

	function Activate()
	{
		bActive = true;
		SetOwnerDisplay();
	}

	function SetOwnerDisplay()
	{
		if ( !bActive )
			return;
		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.Damage.Pulsehit',true,true);
	}

	function ChangedWeapon()
	{
		if ( !bActive )
			return;
		if( Inventory != None )
			Inventory.ChangedWeapon();
		if ( Pawn(Owner).Weapon != None )
			Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.Damage.Pulsehit',true,true);
	}

	function Timer()
	{
		Charge -= 1;
		RRgib();
		Pawn(Owner).Visibility = 10;
		Owner.AmbientGlow = 250; 
		Owner.LightEffect=LE_Rotor;//NonIncidence
		Owner.LightBrightness=64;
		Owner.LightHue=80;
		Owner.LightRadius=32;
		Owner.LightSaturation=240;
		Owner.LightType=LT_Steady;
		Pawn(Owner).DamageScaling = 3.0;
		ShowCharge = Charge;
		if (Charge<-0)
		{
			Owner.AmbientGlow = Owner.Default.AmbientGlow;
			Owner.LightType = LT_None;
			Pawn(Owner).DamageScaling = 1.0;
			UsedUp();
		}
		if ( Charge < 12 && Charge > 0 )
			Owner.PlaySound(Sound'BotPack.ChatSound.NewBeep');
	}

	function BeginState()
	{
		local Inventory S;

		bActive = true;
		PlaySound(ActivateSound,,4.0);
		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.Damage.Pulsehit',false,true);
		SetTimer(0.5,True);
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			   UT_Shieldbelt(S).MyEffect.bHidden = true;
	}

	simulated function Tick(float DT) 
	{
		local PlayerPawn P;
	
		P = PlayerPawn(Owner);
		Super.Tick(DT);
		//P.ReducedDamageType = 'All';
	}
}

state DeActivated
{
Begin:
}

State Sleeping
{
    ignores Touch;

    function BeginState()
    {
        BecomePickup();
        bHidden = true;
    }
    function EndState()
    {
        local int i;

        bSleepTouch = false;
        for ( i=0; i<4; i++ )
            if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
                bSleepTouch = true;
    }           
Begin:
    Sleep( bReSpawnTime );
    PlaySound( RespawnSound );  
    Sleep( Level.Game.PlaySpawnEffect(self) );
    GoToState( 'Pickup' );
}

function RRgib()
{
   local vector Start, HitLocation, X;
   local PlayerPawn P;
   local Bot B;
   local Vector EndFlashFog;
	local float f;

   EndFlashFog.X=60;
	EndFlashFog.Y=1;	
	EndFlashFog.Z=0;

   Start = Pawn(Owner).Location;
   foreach RadiusActors(class'PlayerPawn', P, 750, Start)
	{
		if ((P != self) && (P != None) && (P.PlayerReplicationInfo.Team != Pawn(Owner).PlayerReplicationInfo.Team))
		{
			if (P.Health > 0)
			{
         	P.TakeDamage( 5, Pawn(Owner), HitLocation, 60000*X, 'slashed');
      		P.PlaySound(Sound'fFieldh2',,4.0);
      		P.ClientFlash( 2, 1000*EndFlashFog );
      		return;
      	}
		}
	}
	foreach RadiusActors(class'Bot', B, 750, Start)
	{
		if ((B != self) && (B != None) && (B.PlayerReplicationInfo.Team != Pawn(Owner).PlayerReplicationInfo.Team))
      {
      	if (B.Health > 0)
      	{
		   	B.TakeDamage( 5, Pawn(Owner), HitLocation, 60000*X, 'slashed');
      		B.PlaySound(Sound'fFieldh2',,4.0);
      		return;
      	}
      }
	}

}

defaultproperties
{
   bRespawnTime=1
   ShellSkin=None
   ExpireMessage="Your aura is exhausted."
   bRotatingPickup=True
   PickupMessage="Radiation Relic: Enemies nearby suffer!"
   ItemName="Radiation"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Charge=90
   PickupSound=Sound'Gonew_mutant'
   ActivateSound=Sound'Botpack.Pickups.UTSuperHeal'
   DeActivateSound=Sound'UnrealI.Generic.Teleport1'
   Icon=Texture'RadiationTile'
   Mesh=Mesh'oneupA'
   bCollideWhenPlacing=True
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.N_Shield'
   MultiSkins(1)=Texture'radrelic'
   CollisionRadius=32.00
   CollisionHeight=40.00
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=-12250,Yaw=12000,Roll=12500),
}
