
class RelicRedemptionInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=angelw FILE=Textures\angelw.bmp
#exec AUDIO IMPORT FILE="Sounds\freelife.WAV" NAME="freelife"
#exec AUDIO IMPORT FILE="Sounds\LastSecondSave.WAV" NAME="LastSecondSave"

function inventory PrioritizeArmor( int Damage, name DamageType, vector HitLocation )
{
	local int ArmorDamage, PointNumber, PointCount;
	local Pawn Victim;
	local NavigationPoint NP;

	Victim = Pawn(Owner);

	if ( (Victim == None) || (Victim.Health - Damage > 0) )
		return Super.PrioritizeArmor(Damage, DamageType, HitLocation);

	// Redeem this poor soul.
	Spawn(class'RelicSpawnEffect', Victim,, Victim.Location, Victim.Rotation);
	Victim.ReceiveLocalizedMessage( class'RedemptionMessage',, Victim.PlayerReplicationInfo, Victim.PlayerReplicationInfo );
   if (Victim.IsA('PlayerPawn'))
		PlayerPawn(Victim).SetFOVAngle(170);
   Victim.Health = 100;
   Owner.PlaySound(Sound'LastSecondSave');

	// Move the relic.
	Victim.DeleteInventory(self);
	Destroy();
	NextArmor = None;
	Return self;
}

// Absorb damage.
function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	if ( Pawn(Owner) != None )
		Pawn(Owner).Health = 100;
	return 0;
}

defaultproperties
{
   bRotatingPickup=True
   PickupMessage="Redemption Relic: You get a free life!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Mesh=Mesh'oneupA'
   PickupSound=Sound'freelife'
   Icon=Texture'FreeLifeTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.RedShield'
   MultiSkins(1)=Texture'angelw'
   CollisionHeight=40.00
   RotationRate=(Pitch=12250,Yaw=-12000,Roll=12500),
}
