class RelicRegenerationInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=regeneration FILE=Textures\regeneration.bmp
#exec TEXTURE IMPORT NAME=RegenerationTile FILE=Textures\RegenerationTile.bmp
#exec AUDIO IMPORT FILE="Sounds\RegenHiss.WAV" NAME="RegenHiss" GROUP="Relics"
#exec AUDIO IMPORT FILE="Sounds\Unstoppable.WAV" NAME="Unstoppable" GROUP="Relics"

var vector InstFog;
var float InstFlash;

state Activated
{
	function Timer()
	{
		if ( (Owner != None) && Owner.bIsPawn )
		{
			if ( Pawn(Owner).Health < 150 )
			{
				Pawn(Owner).Health = FMin(150, Pawn(Owner).Health + 10);
				FlashShell(0.3);
				if ( Owner.IsA('PlayerPawn') )
				{
					PlayerPawn(Owner).ClientPlaySound(sound'RegenHiss', False);
					PlayerPawn(Owner).ClientInstantFlash(InstFlash, InstFog);
				}
			}
		}

		Super.Timer();
	}

	function BeginState()
	{
		Super.BeginState();
		SetTimer(2.0, True);
	}

	function EndState()
	{
		SetTimer(0.0, False);
		Super.EndState();
	}
}

defaultproperties
{
   InstFog=(X=475.00,Y=325.00,Z=145.00),
   InstFlash=-0.40
   ShellSkin=None
   bRotatingPickup=True
   PickupMessage="You picked up the Regeneration Relic!"
   ItemName="Regeneration"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
	PickupSound=Sound'Unstoppable'
	Icon=Texture'RegenerationTile'
   Mesh=Mesh'oneupA'
   bCollideWhenPlacing=True
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.BlueShield'
   MultiSkins(1)=Texture'regeneration'
   CollisionRadius=32.00
   CollisionHeight=40.00
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=12250,Yaw=12000,Roll=-12500),
}
