
class RelicSpeedInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=cheetah FILE=Textures\cheetah.bmp
#exec AUDIO IMPORT FILE="Sounds\SpeedWind.WAV" NAME="SpeedWind"

function PickupFunction(Pawn Other)
{
	Super.PickupFunction(Other);
	ShellEffect = Spawn(ShellType, Owner,,Owner.Location, Owner.Rotation);
}

state Activated
{
	function BeginState()
	{
		SetTimer(0.2, True);

		Super.BeginState();

		// Alter player's stats.
		Pawn(Owner).AirControl = 0.65;
		Pawn(Owner).JumpZ *= 1.2;
		Pawn(Owner).GroundSpeed *= 1.4;
		Pawn(Owner).WaterSpeed *= 1.4;
		Pawn(Owner).AirSpeed *= 1.4;
		Pawn(Owner).Acceleration *= 1.4;

		// Add wind blowing.
		Pawn(Owner).AmbientSound = sound'SpeedWind';
		Pawn(Owner).SoundRadius = 64;
	}

	function EndState()
	{
		local float SpeedScale;
		SetTimer(0.0, False);

		Super.EndState();

		if ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bMegaSpeed )
			SpeedScale = 1.3;
		else
			SpeedScale = 1.0;

		// Restore player's stats.
		Pawn(Owner).AirControl = DeathMatchPlus(Level.Game).AirControl;
		Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * Level.Game.PlayerJumpZScaling();
		Pawn(Owner).GroundSpeed = Pawn(Owner).Default.GroundSpeed * SpeedScale;
		Pawn(Owner).WaterSpeed = Pawn(Owner).Default.WaterSpeed * SpeedScale;
		Pawn(Owner).AirSpeed = Pawn(Owner).Default.AirSpeed * SpeedScale;
		Pawn(Owner).Acceleration = Pawn(Owner).Default.Acceleration * SpeedScale;

		// Remove sound.
		Pawn(Owner).AmbientSound = None;
	}
}

defaultproperties
{
   ShellType=Class'speedshell'
   bRotatingPickup=True
   PickupMessage="Speed Relic: You can really move now!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Mesh=Mesh'oneupA'
   PickupSound=Sound'GoSpeed'
   Icon=Texture'SpeedTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.GreenShield'
   MultiSkins(1)=Texture'cheetah'
   CollisionHeight=40.00
   RotationRate=(Pitch=-12250,Yaw=12000,Roll=12500),
}
