// Footsteps code taken from Relics2 package

class RelicStealthInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=stealth FILE=Textures\stealth.bmp
#exec TEXTURE IMPORT NAME=StealthTile FILE=Textures\StealthTile.bmp
#exec AUDIO IMPORT FILE="Sounds\Headhunter.WAV" NAME="Headhunter"

var sound ownerAmbientSound, ownerFootstep1, ownerFootstep2, ownerFootstep3, ownerLand;
var float ownerSoundDampening;
var int ownerSoundRadius;

function bool HandlePickupQuery( Inventory Item )
{
	if(Item.IsA('Dampener'))
		return true;
	return super.HandlePickupQuery(Item);
}

function PickupFunction(Pawn Other)
{
	local Inventory I;

	super.PickupFunction(Other);
	for(I = Owner.Inventory; I != None; I = I.Inventory)
	{
		if(I.IsA('Dampener'))
			I.Destroy();
	}
}

state Activated
{
	function BeginState()
	{
		local Inventory I;

		SetTimer(0.2, true);
		super.BeginState();
		ownerSoundDampening = Pawn(Owner).SoundDampening;
		Pawn(Owner).SoundDampening = 0.05;

		ownerAmbientSound = Pawn(Owner).AmbientSound;
		Pawn(Owner).AmbientSound = None;

		ownerSoundRadius = Pawn(Owner).SoundRadius;
		Pawn(Owner).SoundRadius = 0;

		if(TournamentPlayer(Owner) != None)
		{
			ownerFootstep1 = TournamentPlayer(Owner).FootStep1;
			ownerFootstep2 = TournamentPlayer(Owner).FootStep2;
			ownerFootstep3 = TournamentPlayer(Owner).FootStep3;
			TournamentPlayer(Owner).FootStep1 = None;
			TournamentPlayer(Owner).FootStep2 = None;
			TournamentPlayer(Owner).FootStep3 = None;
			TournamentPlayer(Owner).Style = STY_Translucent;
		}
		else if(Bot(Owner) != None)
		{
			ownerFootstep1 = Bot(Owner).FootStep1;
			ownerFootstep2 = Bot(Owner).FootStep2;
			ownerFootstep3 = Bot(Owner).FootStep3;
			Bot(Owner).FootStep1 = None;
			Bot(Owner).FootStep2 = None;
			Bot(Owner).FootStep3 = None;
			Bot(Owner).Style = STY_Translucent;
		}
		ownerLand = Pawn(Owner).Land;
		Pawn(Owner).Land = None;
	}

	function EndState()
	{
		local Inventory I;

		SetTimer(0.0, false);
		super.EndState();
		Pawn(Owner).SoundDampening = ownerSoundDampening;
		ownerSoundDampening = 0.0;
		Pawn(Owner).AmbientSound = ownerAmbientSound;
		ownerAmbientSound = None;
		Pawn(Owner).SoundRadius = ownerSoundRadius;
		ownerSoundRadius = 0;

		if( TournamentPlayer(Owner) != None )
		{
			TournamentPlayer(Owner).FootStep1 = ownerFootstep1;
			TournamentPlayer(Owner).FootStep2 = ownerFootstep2;
			TournamentPlayer(Owner).FootStep3 = ownerFootstep3;
			ownerFootstep1 = None;
			ownerFootstep2 = None;
			ownerFootstep3 = None;
			TournamentPlayer(Owner).Style = STY_Normal;
		}
		else if(Bot(Owner) != None)
		{
			Bot(Owner).FootStep1 = ownerFootstep1;
			Bot(Owner).FootStep2 = ownerFootstep2;
			Bot(Owner).FootStep3 = ownerFootstep3;
			ownerFootstep1 = None;
			ownerFootstep2 = None;
			ownerFootstep3 = None;
			Bot(Owner).Style = STY_Normal;
		}
		Pawn(Owner).Land = ownerLand;
		ownerLand = None;
	}
}

defaultproperties
{
   ShellSkin=None
   bRotatingPickup=True
   PickupMessage="Stealth Relic: Be ghostlike!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Mesh=Mesh'oneupA'
	PickupSound=Sound'Headhunter'
	Icon=Texture'StealthTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.N_Shield'
	MultiSkins(1)=Texture'stealth'
   CollisionHeight=40.00
   LightHue=185
   LightSaturation=0
   RotationRate=(Pitch=12250,Yaw=-12000,Roll=12500),
}