
class RelicTeammateInventory expands RelicInventory;

#exec TEXTURE IMPORT NAME=teammate FILE=Textures\teammate.bmp
#exec TEXTURE IMPORT NAME=TeammateTile FILE=Textures\TeammateTile.bmp
#exec AUDIO IMPORT FILE="Sounds\ComboKing.WAV" NAME="ComboKing"

var float health;

state Activated
{
	function BeginState()
	{
		super.BeginState();
		SetTimer( 5.0, true );
	}

	function EndState()
	{
		SetTimer( 0.0, false );
		super.EndState();
	}

	function Timer()
	{
		local Pawn P;

		foreach RadiusActors( class'Pawn', P, 750, Owner.location )
		{
			if((P != Pawn(Owner)) && (P.IsA('Bot') || P.IsA('PlayerPawn')))
			{
				if((P != None) && (P.PlayerReplicationInfo.Team == Pawn(Owner).PlayerReplicationInfo.Team))
				{
					if(Owner.IsA('PlayerPawn'))
						PlayerPawn(Owner).PlaySound(sound'RegenHiss', SLOT_None, (2.7 * Pawn(Owner).SoundDampening));

					if(P.IsA('PlayerPawn'))
						PlayerPawn(P).ClientPlaySound(sound'RegenHiss', false);

					P.Health = FMin(150, P.Health + 5);
				}
			}
		}
		super.Timer();
	}
}

defaultproperties
{
   bRotatingPickup=True
   PickupMessage="Teammate Relic: Heals teammates if they are close!"
   PickupViewMesh=Mesh'oneupA'
   PickupViewScale=0.70
   Mesh=Mesh'oneupA'
	PickupSound=Sound'ComboKing'
	Icon=Texture'TeammateTile'
   MultiSkins(0)=FireTexture'Belt_fx.ShieldBelt.BlueShield'
	MultiSkins(1)=Texture'teammate'
   CollisionHeight=40.00
   RotationRate=(Pitch=-12250,Yaw=-12000,Roll=12500),
}

