
class HGPlasmaSphere extends Projectile;

#exec TEXTURE IMPORT NAME=HGpblst00 FILE=TEXTURES\HGpblst00.bmp LODSET=2
#exec TEXTURE IMPORT NAME=HGpblst01 FILE=TEXTURES\HGpblst01.bmp LODSET=2
#exec TEXTURE IMPORT NAME=HGpblst02 FILE=TEXTURES\HGpblst02.bmp LODSET=2
#exec TEXTURE IMPORT NAME=HGpblst03 FILE=TEXTURES\HGpblst03.bmp LODSET=2
#exec TEXTURE IMPORT NAME=HGpblst04 FILE=TEXTURES\HGpblst04.bmp LODSET=2

var bool bExploded, bExplosionEffect, bHitPawn;
var() texture ExpType;
var() Sound EffectSound1;
var() texture SpriteAnim[20];
var() int NumFrames;
var Float AnimTime;

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    SetTimer(0.8, true);
    if ( Level.NetMode == NM_Client )
        LifeSpan = 2.0;
    else
        Velocity = Speed * vector(Rotation);
    if ( Level.bDropDetail )
        LightType = LT_None;
}

simulated function Timer()
{
    if ( Level.bDropDetail )
        LightType = LT_None;
    if ( (Physics == PHYS_None) && (LifeSpan > 0.5) )
        LifeSpan = 0.5;
}

simulated function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
                    Vector momentum, name damageType)
{
    bExploded = True;
}

function BlowUp(vector HitLocation)
{
    PlaySound(EffectSound1,,7.0);   
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
    if ( !bExplosionEffect )
    {
        if ( Role == ROLE_Authority )
            BlowUp(HitLocation);
        bExplosionEffect = true;
        if ( !Level.bHighDetailMode || bHitPawn || Level.bDropDetail )
        {
            if ( bExploded )
            {
                Destroy();
                return;
            }
            else
                DrawScale = 0.45;
        }
        else
        DrawScale = 0.65;
        LightType = LT_Steady;
        LightRadius = 5;
        SetCollision(false,false,false);
        LifeSpan = 0.5;
        Texture = ExpType;
        DrawType = DT_SpriteAnimOnce;
        Style = STY_Translucent;
        if ( Region.Zone.bMoveProjectiles && (Region.Zone.ZoneVelocity != vect(0,0,0)) )
        {
            bBounce = true;
            Velocity = Region.Zone.ZoneVelocity;
        }
        else
            SetPhysics(PHYS_None);
    }
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
    If ( Other!=Instigator  && PlasmaSphere(Other)==None )
    {
        if ( Other.bIsPawn )
        {
            bHitPawn = true;
            bExploded = !Level.bHighDetailMode || Level.bDropDetail;
        }
        if ( Role == ROLE_Authority )
            Other.TakeDamage( Damage, instigator, HitLocation, MomentumTransfer*Vector(Rotation), MyDamageType);    
        Explode(HitLocation, vect(0,0,1));
    }
}

auto State Flying
{
Begin:
    LifeSpan = 2.0;
}

defaultproperties
{
    ExpType=Texture'HGpblst00'
    EffectSound1=Sound'Botpack.PulseGun.PulseExp'
    SpriteAnim(0)=Texture'HGpblst00'
    SpriteAnim(1)=Texture'HGpblst01'
    SpriteAnim(2)=Texture'HGpblst02'
    SpriteAnim(3)=Texture'HGpblst03'
    SpriteAnim(4)=Texture'HGpblst04'
    SpriteAnim(5)=Texture'HGpblst04'
    SpriteAnim(6)=Texture'HGpblst03'
    SpriteAnim(7)=Texture'HGpblst02'
    SpriteAnim(8)=Texture'HGpblst01'
    SpriteAnim(9)=Texture'HGpblst00'
    SpriteAnim(10)=Texture'HGpblst01'
    NumFrames=11
    speed=1450.00
    Damage=30.00
    MomentumTransfer=10000
    MyDamageType=Pulsed
    ExploWallOut=10.00
    ExplosionDecal=Class'MH2BoltScorch'
    RemoteRole=2
    LifeSpan=0.50
    DrawType=1
    Style=3
    Texture=Texture'HGpblst00'
    DrawScale=0.19
    AmbientGlow=187
    bUnlit=True
    SoundRadius=10
    SoundVolume=218
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightRadius=3
    bFixedRotationDir=True
}
