
class HittyBase expands Mutator config(HitmanModv8);

#exec AUDIO IMPORT FILE="Sounds\HitsoundEnemy1.wav" NAME="HitsoundEnemy" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\QFeedbackArmourWav.wav" NAME="QFeedbackArmourWav" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\HitsoundTeam.wav" NAME="HitsoundTeam" GROUP="QFeedback"

var bool bHaveQueenDests, Initialized;

var int AmpCount, kakuCount, HealthCount;

var config int AmmoInterval, AmpSpawnTime, DeemerSpawnTime, HealthAwardTime, HealthRegenPerSec, MaxHealth, MaxRegenHealth,
               HealthRegenPerKill, DefaultHealth, maxJumps, jumpType, MaxDamage;

var config bool bUseRandomWeapon, bUseRegenAmmo, bUseRegenHealth, bGiveArmor, bUseHittyTimer, bUseMonsterHUD, bUseAntiBoost, bFixCrushingMover,
                bGhostCarcass, bHitsounds, bAltScoring, bCheckMonsterAttack, stopPlayerCollision, replaceinvis, VisibleMonsterEnds,
                DoubleJump, UseAltSniper, GiveAllWeapons, bDropWeaponsOnDeath, UseMHTrans, UseLimeLight, UseMH2JumpBoots, UseServerStats, AdjustToMaxHealth;

var config String bServerInfo, CommandOpen, CommandClose, HealGunSummon;

var config float HitVolume, retainScoreOnDeathPercent, jumpHeight;

var float LastMonsterAttackTime;

var String HittyNaliFruit, HittyMedBox, HittyHealthPack, HittyUnrealHealth, HittyHealthVial, HittyShieldBelt, HittyUDamage, HittyJumpBoots;

var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

function PreBeginPlay()
{
   local NavigationPoint NP;

    	if ( Initialized )
		return;

	Super.PreBeginPlay();

        if(UseServerStats)
        Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Stats'));

        NP = Level.NavigationPointList;

        while (!bHaveQueenDests && NP != None)
           {
              if (QueenDest(NP) != None)
              bHaveQueenDests = True;
              NP = NP.nextNavigationPoint;
           }

        if ( NextMutator != None )
           NextMutator.PreBeginPlay();
}

function PostBeginPlay()
{
        local string newhud;
	local class newclass;
	local NavigationPoint NP;
	local MonsterEnd ME;
	local exmhend ex;

	if (Initialized)
		return;

	Log("*** HitmanModv8 mutator is locked and loaded ");
	Initialized = True;
	kakuCount = 0;
	HealthCount = 0;
	if(DefaultHealth < 1)
		DefaultHealth = 100;
	if(bUseHittyTimer)
		SetTimer(1, True);
	if(bUseMonsterHUD)
	{
	     if(Level.Game.HUDType !=none)
		Level.Game.HUDType = class'HittyHUD';
        }
        if(Level.Game.ScoreBoardType !=none)
        {
           if(UseServerStats)
	   Level.Game.ScoreBoardType=Class'HittyScoreBoard';
           else
           Level.Game.ScoreBoardType=Class'HittyScoreBoard';
        }

	Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));
	Level.Game.RegisterDamageMutator(Self);

	TournamentGameInfo(Level.Game).GameName = bServerInfo;

	fixmover();

	if(VisibleMonsterEnds)
 	   fixmymonsterend();

	foreach AllActors(class'MonsterEnd', ME)
	{
		ex=Spawn(class'exmhend',,,ME.location+vect(-1,-1,-1)); // right next to it
                ex.tag=ME.Tag;
		ex.event=ME.Event;
		ex.AttachTag=ME.AttachTag;
		ex.SetCollisionSize(ME.CollisionRadius, ME.CollisionHeight);
		if (ME.bInitiallyActive)
			ex.bInitiallyActive=True;
		else
			ex.bInitiallyActive=False;
	}

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

function fixmover()
{
	local mover M;
	foreach AllActors( class 'Mover', M)
	{
	     if(bFixCrushingMover)
                {
		   if(M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
			M.MoverEncroachType = ME_IgnoreWhenEncroach;
                }
	     if(M.bUseTriggered == True)
			M.bUseTriggered = False;
	}
}

function fixmymonsterend()
{
   local MonsterEnd T;
   foreach AllActors( class 'MonsterEnd', T)
      {
         if(T.bHidden == True)
 	    T.bHidden = False;
      }
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
        if (Other.isA('Weapon') && Other.Instigator != None && Other.Instigator.IsA('ScriptedPawn'))
	{
		return true;
	}
        if(Other.IsA('Pickup'))
	{
			Pickup(Other).bAutoActivate=True;
	}
        //Health classes
	if(Other.Class==Class'NaliFruit')
	{
			ReplaceWith(Other,HittyNaliFruit);
				return false;
	}
	if(Other.Class==Class'Bandages')
	{
			ReplaceWith(Other,"HitmanModv8.HittyBandages");
				return false;
	}
	if(Other.Class==Class'Health')
	{
			ReplaceWith(Other,"HitmanModv8.HittyUnrealHealth");
				return false;
	}
	if(Other.Class==Class'SuperHealth')
	{
			ReplaceWith(Other,"HitmanModv8.HittySuperHealth");
				return false;
	}
	if(Other.Class==Class'MedBox')
	{
			ReplaceWith(Other,"HitmanModv8.HittyMedBox");
			return false;
	}
	if(Other.Class==Class'HealthPack')
	{
			ReplaceWith(Other,"HitmanModv8.HittyHealthPack");
			return false;
	}
	if(Other.Class==Class'HealthVial')
	{
			ReplaceWith(Other,"HitmanModv8.HittyHealthVial");
				return false;
	}
        //Armor pickups
        if(Other.Class==Class'ShieldBelt')
	{
			ReplaceWith(Other,"HitmanModv8.HittyU1ShieldBelt");
				return false;
	}
        if(Other.Class==Class'PowerShield')
	{
			ReplaceWith(Other,"HitmanModv8.HittyU1ShieldBelt");
				return false;
	}
	if(Other.Class==Class'UT_ShieldBelt')
	{
			ReplaceWith(Other,"HitmanModv8.HittyShieldBelt");
				return false;
	}
	if(Other.Class==Class'ThighPads')
	{
			ReplaceWith(Other,"HitmanModv8.HittyThighPads");
				return false;
	}
        if(Other.Class==Class'Armor2')
	{
			ReplaceWith(Other,"HitmanModv8.HittyArmor2");
				return false;
	}
        //Gear pickups
        if(UseLimeLight)
        {
             if(Other.Class==Class'Flashlight')
	     {
              		ReplaceWith(Other,"HitmanModv8.LimeLight");
				return false;
	     }
	}
	if(UseMH2JumpBoots)
	{
	     if(Other.Class==Class'JumpBoots')
	     {
			ReplaceWith(Other,"HitmanModv8.HittyJumpBoots");
				return false;
	     }
        }
	if(Other.Class==Class'UT_JumpBoots')
	{
	    if(InStr ( Level.Title, "Andromeda" ) == -1)  //Stupid hack to let the people play with the everlasting jump boots
            {
                      ReplaceWith(Other,"HitmanModv8.HittyJumpBoots");
				return false;
            }
        }
        if(ReplaceInvis)
	{
            if(Other.Class==Class'Invisibility')
            {
                      ReplaceWith(Other,"HitmanModv8.HittyMedBox");
                                return false;
            }
            if(Other.Class==Class'UT_Invisibility')
            {
                      ReplaceWith(Other,"HitmanModv8.HittyMedBox");
                                return false;
            }
            if(Other.Class==Class'UT_Stealth')
            {
                      ReplaceWith(Other,"HitmanModv8.HittyMedBox");
                                return false;
            }
        }
        if(Other.Class==Class'SCUBAgear')
	{
	   	      ReplaceWith(Other,"HitmanModv8.HittyScuba");
				return false;
	}
	//Carcass (special check)
        if(Other.IsA('Carcass'))
        {
            if(bGhostCarcass)
            {
                      Other.Style = STY_Translucent;
                      Other.SetCollision(False);
                                return True;
            }
        }
	//Fix for the canseeme crash
	if (Other.Class==Class'BiterFishSchool')
	{
		ReplaceWith(Other,"HitmanModv8.UMHBiterFishSchool");
		return False;
	}
        //Weapons
        if(Other.Class==Class'QuadShot') //Quad has buggy graphics
	{
			ReplaceWith(Other,"Botpack.UT_FlakCannon");
				return false;
	}
        if(Other.Class==Class'SniperRifle')
        {
           if(UseAltSniper)
              {
                 ReplaceWith(Other, "HitmanModv8.HitmansRifle");
   	      }
   	  else
              ReplaceWith(Other,"Botpack.SniperRifle");
				return false;
   	}
	if(Other.Class==Class'WarHeadLauncher')
	{
	                ReplaceWith(Other, "HitmanModv8.UMBombGun");
	                        return false;
	}
        //Unreal1 weaponry
        if ( Other.IsA('Weapon') )
        {
		if ( Other.IsA('TournamentWeapon') )
			return true;

		if ( Other.IsA('UIWeapon') )
			return true;
		if(Other.Class==Class'Stinger')
		{
			ReplaceWith(Other, "MonsterHunt.OLStinger");
			return false;
		}

		if(Other.Class==Class'Rifle')
		{
			ReplaceWith( Other, "MonsterHunt.OLRifle" );
			Return false;
		}
	
		if(Other.Class==Class'Razorjack')
		{
			ReplaceWith(Other, "MonsterHunt.OLRazorjack");
			Return false;
		}

		if(Other.Class==Class'Minigun')
		{
			ReplaceWith( Other, "MonsterHunt.OLMinigun" );
			return false;
		}
	
		if(Other.Class==Class'AutoMag')
		{
			ReplaceWith( Other, "MonsterHunt.OLAutoMag" );
			return false;
		}

		if(Other.Class==Class'Eightball')
		{
			ReplaceWith( Other, "MonsterHunt.OLEightball" );
			return false;
		}
	
		if(Other.Class==Class'FlakCannon')
		{
			ReplaceWith( Other, "MonsterHunt.OLFlakCannon" );
			return false;
		}
		
		if(Other.Class==Class'ASMD')
		{
			ReplaceWith( Other, "MonsterHunt.OLASMD" );
			return false;
		}

		if(Other.Class==Class'GesBioRifle')
		{
			ReplaceWith( Other, "MonsterHunt.OLGESBioRifle" );
			return false;
		}
      	}
  bSuperRelevant = 0;
  return true;
}

function GiveAmp(Pawn PlayerPawn)
{
	local UDamage damage;

	if( (PlayerPawn.FindInventoryType(class'UDamage') != None) ||
		(PlayerPawn.Health <= 0) )
		return;
	damage = spawn(class'UDamage',PlayerPawn,,PlayerPawn.Location);
	if( damage != None )
	{
		damage.RespawnTime = 0.0;
		damage.GiveTo(PlayerPawn);
		damage.Activate();
       	}
}

function MutatorTakeDamage (out int ActualDamage,Pawn Victim,Pawn InstigatedBy,out Vector HitLocation,out Vector Momentum,name DamageType)
{
	local Pawn P;

	if(DamageType == 'Impact') // hammer x5 ii !
	{
	   ActualDamage *= 5;
	}

	if(bUseAntiBoost)
	{
	    if(Victim != None && InstigatedBy != None)
	       {
                  if (InstigatedBy.IsA('PlayerPawn') && Victim.IsA('PlayerPawn'))
		     {
			Momentum = Vect(0,0,0);
                        ActualDamage = 0;
                        if (string(DamageType)=="RedeemerDeath")
                           {
			      Velocity = Vect(0,0,0);
			      Victim.Velocity = (Victim.Velocity * 0);
                           }
                     }
		}
	}
	if(bHitsounds)
	{
	     if(Victim != None && InstigatedBy != None)
	     {
                  if ( InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) )
	          {
		       if( Victim.IsA('PlayerPawn') || Victim.IsA('Bot') )  // When player shoot other player
		       {
			    PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
			    PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
			    PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
		       }
		       if( Victim.IsA('ScriptedPawn') )  // When player shoots a monster
		       {   	// Cows and rabbits are friends
			    if(Victim.IsA('Cow')|| Victim.IsA('BabyCow')|| Victim.IsA('NaliRabbit'))
                            {
	                         PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_None, HitVolume, false);
			         PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interface, HitVolume, false);
		    	         PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundTeam', SLOT_Interact, HitVolume, false);
			    }
		            else // ScriptedPawn is an enemy
			    {
				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_None, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interface, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interact, HitVolume, false);
			    }
                       }
	          }
	     }
	}
	if(bAltScoring)
	{
	   if (Victim != None && InstigatedBy != None)
	      {
                 if ( Victim.IsA('ScriptedPawn') && instigatedBy.IsA('ScriptedPawn') || Victim == instigatedBy && Victim.IsA('ScriptedPawn'))
                      actualDamage=0;
                 if ( actualDamage < 0 )
                      return;
                 else if ( actualDamage > 1000 )
                      actualDamage=MaxDamage;

                 if (ActualDamage > Victim.Health)
                     ActualDamage = Victim.Health;

                 if (Victim != None && InstigatedBy != None && Victim != InstigatedBy)
	            {
	               if (Victim.IsA('ScriptedPawn') && InstigatedBy.bIsPlayer)
		          {
		             InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
	                  }
                    }
	     }
	 }
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function ModifyPlayer(Pawn Other)
{
	local int randm;
	local inventory inv;
	local class<DJ_InventoryItem> InventoryClass;
	local DJ_InventoryItem DJ_Inv;

	if(!Other.IsA('TournamentPlayer'))return;
	 TournamentPlayer(Other).PlayerReplicationInfo.Team = 0; // kyouseitekini team 0

	Other.Health = DefaultHealth;

        if (stopPlayerCollision == true)
        Other.bBlockPlayers = false;

        if (UseMHTrans)
        DeathMatchPlus(Level.Game).GiveWeapon(Other,"HitmanModv8.MHTranslocator");

        InventoryClass = class<DJ_InventoryItem>(DynamicLoadObject("HitmanModv8.DJ_InventoryItem", class'Class'));

        if(DoubleJump)
	   {
              DJ_Inv = Spawn(class'DJ_InventoryItem', Other,, Other.Location);
              if( DJ_Inv != None )
	         {
		    DJ_Inv.RespawnTime = 0.0;
		    DJ_Inv.GiveTo(Other);
		    DJ_Inv.maxJumps = maxJumps;
		    DJ_Inv.jumpType = jumpType;
		    DJ_Inv.jumpHeight = jumpHeight;
	         }
           }
         if (bUseSpawnProt)
            {
               Inv = Other.FindInventoryType(class'SpawnProtEffect');
               if ( Inv != None )
                  SpawnProtEffect(Inv).Duration = SpawnProtDuration;
               else
                  {
                     inv = Spawn(class'SpawnProtEffect');
                     if( inv != None )
                        {
                           SpawnProtEffect(Inv).Duration = SpawnProtDuration;
                           inv.GiveTo(Other);
                           inv.Activate();
                        }
                 }
            }  
         if(GiveAllWeapons)
            {
               GiveWeapon(Other,class'PulseGun');
	       GiveWeapon(Other,class'ShockRifle');
	       GiveWeapon(Other,class'UT_FlakCannon');
	       GiveWeapon(Other,class'Botpack.UT_BioRifle');
	       GiveWeapon(Other,class'Botpack.Minigun2');
	       GiveWeapon(Other,class'Botpack.Ripper');
	       GiveWeapon(Other,class'Botpack.UT_Eightball');

	       if(UseAltSniper)
	          {
                    GiveWeapon(Other,class'HitmansRifle');
                  }
               else
                  {
                     GiveWeapon(Other,class'Botpack.SniperRifle');
                  }
            }

	if (bUseRandomWeapon && Other.IsA('TournamentPlayer') ) // players only
	{
		randm = Rand(10);
		switch(randm)
		{
			case 0:
				GiveWeapon(Other,class'UT_Biorifle');
			        break;
			case 1:
				GiveWeapon(Other,class'Shockrifle');
			        break;
			case 2:
				GiveWeapon(Other,class'Pulsegun');
			        break;
			case 3:
				GiveWeapon(Other,class'ripper');
			        break;
			case 4:
				GiveWeapon(Other,class'minigun2');
			        break;
			case 5:
				GiveWeapon(Other,class'UT_Flakcannon');
			        break;
			case 6:
				GiveWeapon(Other,class'UT_EightBall');
		                break;
			case 7:
				if(UseAltSniper)
				{
                                GiveWeapon(Other,class'HitmansRifle');
				}
				else
                                GiveWeapon(Other,class'SniperRifle');
		                break;
			case 8:
				GiveWeapon(Other,class'UMBombGun');
			        break;
			case 9:
				GiveWeapon(Other,class'ImpactHammer');
			        break;
		}
		if(bGiveArmor)
		{
			inv = Spawn(class'HittyArmor2');
			if( inv != None )
			{
				inv.bHeldItem = true;
				inv.RespawnTime = 0.0;
				inv.GiveTo(Other);
				inv.Charge = Inv.Default.Charge;
			}
		}
		Other.ReceiveLocalizedMessage( class'HittyGetWeaponMessage', randm, Other.PlayerReplicationInfo, Other.PlayerReplicationInfo );
	}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
	local Weapon NewWeapon;

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		PlayerPawn.PendingWeapon = None;
		if ( !newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator') )
                {
			newWeapon.GiveAmmo(PlayerPawn);
			newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
		}
	}
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	if(Killer == None)return; // sui
	if(!Killer.bIsHuman)return; // bot iran
	if(Killer.PlayerReplicationInfo.bIsABot) return; // bot irane-
	if(Killer.IsA('ScreptedPawn'))return;
	if(Killer.IsA('ScreptedPawn') && Other.IsA('ScreptedPawn'))return;
	if ( (Killer == None) && (Other == None) )return; // ?
	if ( Killer.bIsPlayer && Other.bIsPlayer )return; // tk

        //Check this to be sure
        if ((Killer.IsA('PlayerPawn')) && (Other.IsA('ScriptedPawn')))
		IPRI(PlayerPawn(Killer).PlayerReplicationInfo).KilledMonsters += 1;

	if ( Other.Spree > 1 && Other.bIsPlayer)
		EndSpree(Killer, Other);
	if(Other.bIsPlayer)Other.Spree = 0;
		if ( (Killer != None) && Killer.bIsPlayer && (Killer != Other) )
		{
			if(Killer.Health <= MaxHealth)
                        {
                              Killer.Health += HealthRegenPerKill;
                        }
                        if(AdjustToMaxHealth)
                        {
			     if(Killer.Health > MaxHealth)
                                Killer.Health = MaxHealth;
                        }
			Killer.Spree+=1;
			if ( Killer.Spree > 14 )
				NotifySpree(Killer, Killer.Spree);

			if ( (TournamentPlayer(Killer).Level.TimeSeconds - TournamentPlayer(Killer).LastKillTime < 3))
			{
				TournamentPlayer(Killer).MultiLevel++;
				if(TournamentPlayer(Killer).MultiLevel >= 41)TournamentPlayer(Killer).MultiLevel = 40;
				TournamentPlayer(Killer).ReceiveLocalizedMessage( class'HittyMultiKillMessage', TournamentPlayer(Killer).MultiLevel );
				CheckBroadCast(Killer,TournamentPlayer(Killer).MultiLevel);
			}
			else TournamentPlayer(Killer).MultiLevel = 0;

			TournamentPlayer(Killer).LastKillTime = TournamentPlayer(Killer).Level.TimeSeconds;
		}
}

function CheckBroadCast(Pawn Killer,int num)
{
	if(Killer.bIsPlayer && !Killer.PlayerReplicationInfo.bIsABot)
	BroadCastMessage(Killer.PlayerReplicationInfo.PlayerName@GetText(num));
}

function string GetText(int Switch)
{
	switch (Switch)
	{
		case 1:
			return " has Double Kill!";
			break;
		case 2:
			return " has Multi Kill!";
			break;
		case 3:
			return " has Mega Kill!";
			break;
		case 4:
			return " has ULTRA KILL!!";
			break;
		case 5:
			return " has M O N S T E R  K I L L !!!";
			break;
		case 6:
			return " has L U D I C R O U S  K I L L !!!!";
			break;
		case 7:
		case 8:
		case 9:
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:
		case 15:
		case 16:
		case 17:
		case 18:
		case 19:
		case 20:
		case 21:
		case 22:
		case 23:
		case 24:
		case 25:
		case 26:
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
		case 32:
		case 33:
		case 34:
		case 35:
		case 36:
		case 37:
		case 38:
		case 39:
		        return " has H  O  L  Y   S  H  I  T !!!!!!!";
			break;
		case 40:
			return " is still going.... !!!!!!!!!!!";
			break;
	}
	return "";
}
function NotifySpree(Pawn Other, int num)
{
	local Pawn P;

	if ( num == 30 )
		num = 0;
	else if ( num == 45 )
		num = 1;
	else if ( num == 60 )
		num = 2;
	else if ( num == 90 )
		num = 3;
	else if ( num == 125 )
		num = 4;
	else if ( num == 250 )
		num = 5;
	else if ( num == 500 )
                num = 6;
        else if ( num == 1000 )
                num = 7;
	else
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
			P.ReceiveLocalizedMessage( class'HittyKillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function EndSpree(Pawn Killer, Pawn Other)
{
	local Pawn P;

	if ( !Other.bIsPlayer || Killer.PlayerReplicationInfo.bIsABot)
		return;
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	if ( P.IsA('TournamentPlayer') )
	{
		if(Other.IsA('ScriptedPawn'))
			P.ReceiveLocalizedMessage( class'HittyKillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo,  Killer.PlayerReplicationInfo );
		else
			P.ReceiveLocalizedMessage( class'HittyKillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo );
	}
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	local bool pd;

        pd=Super.PreventDeath(Killed,Killer,DamageType,HitLocation);

        if (Killed != none && !pd)
        {
            if (!Killed.IsA('ScriptedPawn'))
    	    {
                 if(bDropWeaponsOnDeath)
                 {
    	             if (Killer != none && Killer.IsA('ScriptedPawn'))
    		         DiscardInventory(Killed);
                 }
    	         if (Killed.bIsPlayer)
                     Killed.PlayerReplicationInfo.Score *= retainScoreOnDeathPercent;
            }
        }
	return pd;
}

function DiscardInventory (Pawn Other)
{
	local Actor dropped;
	local Inventory Inv;
        local class<Weapon> Initial1;
        local class<Weapon> Initial2;

    if (Other != none)
    {
    	if ( Other.DropWhenKilled != None )
    	{
    		dropped=Spawn(Other.DropWhenKilled,,,Other.Location);
    		Inv=Inventory(dropped);
    		if ( Inv != None )
    		{
    			Inv.RespawnTime=0.00;
    			Inv.BecomePickup();
    		}
    		if ( dropped != None )
    		{
    			dropped.RemoteRole=ROLE_DumbProxy;
    			dropped.SetPhysics(PHYS_Falling);
    			dropped.bCollideWorld=True;
    			dropped.Velocity=Other.Velocity + VRand() * 280;
    		}
    		if ( Inv != None )
    		{
    			Inv.GotoState('Pickup','dropped');
    		}                                                     
    	}

        Inv=Other.Inventory;
    JL0111:
    	if ( Inv != None )
    	{
    		if ( Inv.IsA('Weapon') )
    		{
    			if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
    			{
                           if (Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer')
                    	   DropWeapon(Other,Inv);
    			}
    		}
    		Inv.Destroy();
    		Inv=Inv.Inventory;
    		goto JL0111;
    	}
   	}
}

function DropWeapon (Pawn Other, Inventory Inv)
{
	local Inventory DropInv;
	local int DropPitch;
	local int DropYaw;
	local Rotator DropRot;

	DropInv=Spawn(Inv.Class,,,Other.Location);
	if ( DropInv == None )
	{
		return;
	}
	DropRot=Other.ViewRotation;
	DropPitch=Rand(32768);
	DropYaw=Rand(65536);
	DropRot.Pitch=DropPitch;
	DropRot.Yaw=DropYaw;
        Weapon(DropInv).bWeaponStay = false;
	DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
	DropInv.RespawnTime=0.00;
	DropInv.BecomePickup();
	DropInv.NetPriority=2.50;
	DropInv.RemoteRole=ROLE_DumbProxy;
	DropInv.SetPhysics(PHYS_Falling);
	DropInv.bCollideWorld=True;
	DropInv.GotoState('Pickup','dropped');
}

simulated function Tick (float DT)
{
    Super.Tick(DT);

    if ( Level.Game.bGameEnded ) return;

    if ((bCheckMonsterAttack) && (LastMonsterAttackTime < Level.TimeSeconds)) // call every x secs
        MonsterAttackCheck();
}

function Timer()
{
	local Pawn P;
	local Inventory Inv;
	local skaarjtrooper sp;
	
	Super.Timer();

        if ( Level.Game.bGameEnded ) return;

        for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
           if (P.IsA('skaarjtrooper'))
           {
              sp=skaarjtrooper(P);
              sp.bIsPlayer = False;
              if(sp.weapontype==none)
              GiveWeapon(sp,Class'botpack.minigun2');
              if (sp.weapon !=none)
              sp.weapon.bCanThrow=False;
           }
        }

	if (AmpCount < AmpSpawnTime)AmpCount++;

	else if (AmpCount == AmpSpawnTime)
        {
		BroadcastLocalizedMessage( class'HittyAmpMessage',,, None, None );
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('Bot')  || P.IsA('TournamentPlayer'))
			     GiveAmp(P);
		        AmpCount = 0;
	}
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('Bot')  || P.IsA('TournamentPlayer'))
                {
			if (P.Health > 0)
                        {
				if(bUseRegenAmmo)
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					if ( (Ammo(Inv)!=None) && (P.bFire==0) && (P.bAltFire==0) )
						if (Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo * 10) 
                                                {
							Ammo(Inv).AmmoAmount += (Ammo(Inv).Default.AmmoAmount/ AmmoInterval);
							if (Ammo(Inv).AmmoAmount > Ammo(Inv).MaxAmmo * 10)
								Ammo(Inv).AmmoAmount = Ammo(Inv).MaxAmmo * 10;
						}
				}
				if(bUseRegenHealth)
				{
				     if ( P.Health < MaxRegenHealth && !P.Region.Zone.bWaterZone)       // waterzone stoppage of health regen
				     {
                                          if (P.IsInState('FeigningDeath'))
                                              P.Health = FMin(MaxRegenHealth, P.Health + (3 * HealthRegenPerSec));
                                          else
                                              P.Health = FMin(MaxRegenHealth, P.Health + HealthRegenPerSec);
                                     }
				}
			}
               }
    P = GetRandomPlayer();
    if(P != None)
    {
        if (kakuCount < DeemerSpawnTime)kakuCount ++;
  	if (HealthCount < HealthAwardTime)HealthCount ++;

        if(DeemerSpawnTime-kakuCount < 5 &&  DeemerSpawnTime-kakuCount > 0)
        {
         BroadcastLocalizedMessage(class'HittyRandomDeemerMsg',DeemerSpawnTime-kakuCount,P.PlayerReplicationInfo  );
        }

	if(HealthAwardTime-HealthCount < 5 && HealthAwardTime-HealthCount > 0)
	{
   	 BroadcastLocalizedMessage(class'HittyRandomHealthMsg',HealthAwardTime-HealthCount,P.PlayerReplicationInfo  );
   	}
        if (kakuCount >= DeemerSpawnTime)
        {
   	     kakuCount = 0;
             P = GetRandomPlayer();
             if(P.bIsPlayer)
             {
               BroadcastLocalizedMessage(class'HittyRandomDeemerMsg',kakuCount,P.PlayerReplicationInfo  );
               GiveRedeemer(P);
             }
        }
        if (HealthCount >= HealthAwardTime)
        {
	     HealthCount = 0;
             P = GetRandomPlayer();
             if(P.bIsPlayer)
             {
               BroadcastLocalizedMessage(class'HittyRandomHealthMsg',HealthCount,P.PlayerReplicationInfo  );
               GiveHealth(P);
             }
	}
    }
}

function GiveRedeemer(Pawn PlayerPawn)
{
	local UMBombGun  rede;
	local bool NoNeed;

	rede= spawn(class'UMBombGun');
	if( rede!= None )
	{
	   if (PlayerPawn.FindInventoryType(class'UMBombGun') != None)
            NoNeed = true;

           rede.RespawnTime = 0.0;
           rede.GiveTo(PlayerPawn);
           rede.SetSwitchPriority(PlayerPawn);
           PlayerPawn.AddInventory(rede);
           rede.PickupAmmoCount = 1;
	   rede.GiveAmmo(PlayerPawn);
	   if (NoNeed)
	       rede.Destroy();
	}
}

function MonsterAttackCheck()
{
    local ScriptedPawn S;
    local Queen Q;
    local Pawn P;

    for ( P=Level.PawnList; P!=None; P=P.nextPawn )
    {
        S = ScriptedPawn(P);
        Q = Queen(P);
        
        if (S != None && S.Enemy != None && S.Enemy.IsA('ScriptedPawn'))
        {
            S.Hated = None;
            S.Enemy = None;
            if (S.OldEnemy!=None && S.OldEnemy.IsA('ScriptedPawn'))
                S.OldEnemy = none;
            S.WhatToDoNext('Waiting','');
        }
        // Dirty fix for the teleport looping queen
        if (!bHaveQueenDests)
        {
            Q = Queen(P);
            
            if (Q != none)
            {
                if (Q.IsInState('Teleporting'))
                Q.GotoState('Attacking');
            }
        }
    }
    LastMonsterAttackTime = Level.TimeSeconds;
}

function GiveHealth(Pawn PlayerPawn)
{
	PlayerPawn.Health+=500;
}

function Pawn GetRandomPlayer()
{
  local Pawn N;
  local PlayerPawn Dest;
  local Pawn Candidate[32];
  local int num;

  for (N=Level.PawnList; N!=None; N=N.NextPawn)
  {
    Dest=PlayerPawn(N);
    if (Dest!=None && Dest.bIsPlayer && !Dest.PlayerReplicationInfo.bIsSpectator)
    {
      if (num<32) Candidate[num] = Dest;
      else if (Rand(num) < 32) Candidate[Rand(32)] = Dest;
      num++;
    }
  }

  if(num==0) return None;
  return Candidate[Rand(Min(32,num))];
}

function Mutate(string MutateString, PlayerPawn Sender)
{
   local mover M;
   
   if(MutateString ~= CommandOpen)
      {
         Sender.ClientMessage("Movers in range opened (Action was logged to the server admin)...");
         foreach RadiusActors(class'Mover', M, 250, Sender.Location)
            {
               log("## ADMIN- Mover opened:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
               M.DoOpen();
            }
      }
      else if(MutateString ~= CommandClose)
      {
          Sender.ClientMessage("Movers in range closed (Action was logged to the server admin)...");
          foreach RadiusActors(class'Mover', M, 250, Sender.Location)
            {
               log("## ADMIN- Mover closed:"@M@" by player:"@Sender.PlayerReplicationInfo.PlayerName);
               M.DoClose();
            }
      }
   if(MutateString~="light")
   {
       Sender.ClientMessage("Toggling personal light on");
       Sender.AmbientGlow = 254;
       Sender.LightEffect=LE_NonIncidence;
       Sender.LightBrightness=255;
       Sender.LightHue=210;
       Sender.LightRadius=30;
       Sender.LightSaturation=200;
       Sender.LightType=LT_Steady;
   }
   if(MutateString~="dark")
   {
       Sender.ClientMessage("Toggling personal light off");
       Sender.AmbientGlow = Owner.Default.AmbientGlow;
       Sender.LightType = LT_None;
   }
   if(MutateString ~= HealGunSummon)
   {
       spawn(class'HitmanModv8.HealingGun',,,Sender.Location);
   }

   if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
}

simulated function bool AlwaysKeep(Actor Other)
{
	if (Other.IsA('ScriptedPawn'))
	    ScriptedPawn(Other).bIsPlayer = False;
        if ( ((PlayerPawn(Other) != None) || (Bot(Other) != None)) &&  !Other.IsA('SkaarjBot') )
	{
		Pawn(Other).PlayerReplicationInfoClass=Class'IPRI';
		return True;
	}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

defaultproperties
{
    AmmoInterval=3
    AmpSpawnTime=400
    DeemerSpawnTime=120
    HealthAwardTime=500
    HealthRegenPerSec=10
    MaxHealth=500
    MaxRegenHealth=500
    HealthRegenPerKill=10
    DefaultHealth=500
    maxJumps=3
    jumpType=2
    MaxDamage=1000
    bUseRandomWeapon=True
    bUseRegenAmmo=True
    bUseRegenHealth=True
    bGiveArmor=True
    bUseHittyTimer=True
    bUseMonsterHUD=True
    bGhostCarcass=True
    bHitsounds=True
    bAltScoring=True
    bCheckMonsterAttack=True
    stopPlayerCollision=True
    replaceinvis=True
    VisibleMonsterEnds=True
    DoubleJump=True
    UseAltSniper=True
    GiveAllWeapons=True
    bDropWeaponsOnDeath=True
    UseLimeLight=True
    AdjustToMaxHealth=True
    bServerInfo="Default message"
    CommandOpen="open"
    CommandClose="close"
    HealGunSummon="healgun"
    HitVolume=16.00
    retainScoreOnDeathPercent=0.75
    jumpHeight=2.00
    HittyNaliFruit="HitmanModv8.HittyNaliFruit"
    HittyMedBox="HitmanModv8.HittyMedBox"
    HittyHealthPack="HitmanModv8.HittyHealthPack"
    HittyUnrealHealth="HitmanModv8.HittyUnrealHealth"
    HittyHealthVial="HitmanModv8.HittyHealthVial"
    bUseSpawnProt=True
    SpawnProtDuration=10
}
