
class HittyHUD expands ChallengeTeamHUD config(HitmanModv8);

#exec texture IMPORT NAME=MHudIconHit  FILE=Textures\HUDIconHit.pcx GROUP="Hud" MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=MBlackStuff  FILE=Textures\BlackStuff.bmp GROUP="Hud" MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=MBlackStuff2  FILE=Textures\BlackStuff2.bmp GROUP="Hud" MIPS=OFF LODSET=0
#exec texture Import File=Textures\radarconsole.bmp Name=radarconsole Mips=Off Flags=2
#exec Texture Import File=Textures\Monsterpoint.pcx Name=monsterpoint Mips=Off
#exec TEXTURE IMPORT NAME=F2logo FILE=Textures\F2Logo.bmp Group=HUD MIPS=ON
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

//var config bool UseMHRadar;

var color HitColor, Deemercolor;

var texture tex;

var() config enum ES_Position
{
    RADAR_TopLeft,
    RADAR_TopMiddle,
    RADAR_TopRight,
    RADAR_MiddleLeft,
    RADAR_MiddleRight,
    RADAR_BottomLeft,
    RADAR_BottomMiddle,
    RADAR_BottomRight
} Position;

var PlayerPawn Player;

var localized string RankString;
var localized string SpreadString;

var() config int Zscale;
var bool bActive;
var GameReplicationInfo GRI;
var int RespawnTimer;
var bool TimerFlip;

var PlayerReplicationInfo Ordered[32];

var() config bool bHideSpectatorBeacons;
var Texture TeamBeaconIcon;
var color BeaconColor;

simulated function PostBeginPlay ()
{
    Super.PostBeginPlay();

    Level.bHighDetailMode = true;

    bUseTeamColor=MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).bUseTeamSkins;
    RespawnTimer=0;
    SetTimer(0.50,True);
}

function Timer ()
{
    local int i, j;

    if ( PawnOwner.Health < 75  && !PawnOwner.IsInState('Dying'))
       PawnOwner.PlaySound(Sound'UnrealShare.Beep');

    if (PawnOwner.IsInState('Dying') && RespawnTimer==0) // delay the respawn so player can see SB
        RespawnTimer=10*2; // 10 sec
    else if (PawnOwner.IsInState('Dying') && RespawnTimer>0)
    {
        if (--RespawnTimer == 0)
            PlayerPawn(PawnOwner).ServerRestartPlayer();
    }
    if (TimerFlip)
	    UpdateRankAndSpread();
    TimerFlip = !TimerFlip;

//add
        if (!bDrawMessageArea)
    {
        if (MessageFadeCount > 0)
            MessageFadeCount--;
    }

    // Age the short message queue.
    for (i=0; i<4; i++)
    {
        // Purge expired messages.
        if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
            ClearMessage(ShortMessageQueue[i]);
    }

    // Clean empty slots.
    for (i=0; i<3; i++)
    {
        if ( ShortMessageQueue[i].Message == None )
        {
            for (j=i; j<4; j++)
            {
                if ( ShortMessageQueue[j].Message != None )
                {
                    CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
                    ClearMessage(ShortMessageQueue[j]);
                    break;
                }
            }
        }
    }

    // Age all localized messages.
    for (i=0; i<10; i++)
    {
        // Purge expired messages.
        if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
            ClearMessage(LocalMessages[i]);
    }

    // Clean empty slots.
    for (i=0; i<9; i++)
    {
        if ( LocalMessages[i].Message == None )
        {
            CopyMessage(LocalMessages[i],LocalMessages[i+1]);
            ClearMessage(LocalMessages[i+1]);
        }
    }

    if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
        || (PawnOwner.PlayerReplicationInfo == None) )
        return;
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
//	HighScore = -100;
	HighScore = 0;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
    local float XL, YL, XOffset, YOffset, YOffsetSafe;
    local inventory Inv;
    local int BootCharges;
    local int FlashCharges;
    local string Spread;
    local int i;
    local UMBombGun W;

    if ( (PawnOwner.PlayerReplicationInfo == None)
        || PawnOwner.PlayerReplicationInfo.bIsSpectator )
        return;


    i = 0;
    Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
//    Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
    //Canvas.DrawColor = WhiteColor;
    Canvas.DrawColor = GoldColor;
    Canvas.StrLen(RankString, XL, YL);
    if ( bHideAllWeapons )
        YOffset = Canvas.ClipY - YL*6;
    else if ( HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale )
        YOffset = Canvas.ClipY - 64*scale - YL*6;
    else
        YOffset = Canvas.ClipY - 128*Scale - YL*6;

    Canvas.SetPos(0, YOffset + (YL/2));
	Canvas.DrawText(RankString@Rank@"/"@PlayerCount, False);

	if (Lead > 0)
        {
		Spread = SpreadString$" +"$Lead;
        Canvas.DrawColor = GreenColor;
	}
	else if (Lead < 0)
        {
		Spread = SpreadString$" "$Lead;
        Canvas.DrawColor = RedColor;
	}
	else
        {
		Spread = SpreadString$" "$Lead;
        Canvas.DrawColor = GoldColor;
        }

    Canvas.SetPos(0, YOffset + YL + (YL/2));
	Canvas.DrawText(Spread, False);

    //Canvas.DrawColor = WhiteColor;
    Canvas.DrawColor = GoldColor;
    if (MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).bUseLives)
    {
        Canvas.SetPos(0, YOffset + YL + YL + YL);
        Canvas.DrawColor = GoldColor;
        Canvas.DrawText(" Deaths: "$MonsterReplicationInfo(PlayerOwner.GameReplicationInfo).Lives - int(PawnOwner.PlayerReplicationInfo.Deaths), false);
    }
    YOffsetSafe = YOffset; // make a safe copy
    YOffSet -= YL + YL;

    for ( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
    {
        if ( Inv.IsA('HittySCUBA'))
        {
           Canvas.DrawColor = GoldColor;
           if ((Inv.Charge/10) < 25) Canvas.DrawColor = RedColor;
           Canvas.SetPos(0, YOffset);
           Canvas.DrawText(" Scuba: "@(Inv.Charge/10), False);
           YOffSet -= YL;
        }
        else if ( Inv.IsA('JumpBoots') || Inv.IsA('UT_Jumpboots') )
        {
            BootCharges=Inv.Charge;
            Canvas.DrawColor = GoldColor;
            Canvas.SetPos(0, YOffset);
            Canvas.DrawText(" Jumps left: "@Inv.Charge, False);
            YOffSet -= YL;
        }
        else if ( Inv.IsA('FlashLight'))
        {
            FlashCharges=Inv.Charge;
            Canvas.DrawColor = GoldColor;
            if ((Inv.Charge/10) < 100) Canvas.DrawColor = RedColor;
            Canvas.SetPos(0, YOffset);
            Canvas.DrawText(" Flashlight: "@(Inv.Charge/10), False);
            YOffSet -= YL;
        }
   		else
		{
			i++;
			if ( i > 100 )
				break; // can occasionally get temporary loops in netplay
		}
    }
    YOffset = YOffsetSafe;
    
    
    Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
    Canvas.DrawColor = GoldColor;
    Canvas.SetPos(0, YOffset + YL + YL + YL + YL);

    for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
       {
          if ( Inv.IsA('UMBombGun') )
             {
                W = UMBombGun(Inv);
                if (W.AmmoType.AmmoAmount > 0)
                   {
                      Canvas.DrawColor = RedColor;
                      Canvas.DrawText(" Redeemers: "@(W.AmmoType.AmmoAmount), False);
                   }
                else
                   {
                       Canvas.DrawColor = Goldcolor;
                       Canvas.DrawText(" No Redeemer", False);
                   }
             }
       }
    Canvas.DrawColor = GoldColor;
    if ((MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Monsters) < 10) Canvas.DrawColor = RedColor;
        Canvas.SetPos(0, YOffset + YL + YL + YL + YL + YL);
    Canvas.DrawText(" Monsters Left: "$string(MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Monsters), False);
    Canvas.DrawColor = WhiteColor;
}

simulated function DrawFragCount (Canvas Canvas)
{
	local float Whiten;
	local int X;
	local int Y;

	if ( PawnOwner.PlayerReplicationInfo == None )
	{
		return;
	}
	Canvas.Style=Style;
	if ( bHideAllWeapons || (HUDScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale) )
	{
		Y=Canvas.ClipY - 63.50 * Scale;
	}
	else
	{
		Y=Canvas.ClipY - 127.50 * Scale;
	}
	if ( bHideAllWeapons )
	{
		X=0.50 * Canvas.ClipX - 256 * Scale;
	}
	Canvas.CurX=X;
	Canvas.CurY=Y;
	Canvas.DrawColor=HUDColor;
	Whiten=Level.TimeSeconds - ScoreTime;
	if ( Whiten < 3.00 )
	{
		if ( HUDColor==GoldColor )
		{
			Canvas.DrawColor=WhiteColor;
		}
		else
		{
			Canvas.DrawColor=GoldColor;
		}
		if ( Level.bHighDetailMode )
		{
			Canvas.CurX=X - 64 * Scale;
			Canvas.CurY=Y - 32 * Scale;
			Canvas.Style=3;
			Canvas.DrawTile(Texture'HUDWeapons',256.00 * Scale,128.00 * Scale,0.00,128.00,256.00,128.00);
		}
		Canvas.CurX=X;
		Canvas.CurY=Y;
		Whiten=4.00 * Whiten - 4 * Whiten;
		Canvas.DrawColor=Canvas.DrawColor + (HUDColor - Canvas.DrawColor) * Whiten;
	}
	Canvas.DrawTile(Texture'HudElements1',128.00 * Scale,64.00 * Scale,0.00,128.00,128.00,64.00);
	Canvas.DrawColor=WhiteColor;

    if (int(PawnOwner.PlayerReplicationInfo.Score) >= 9999) {
    	Canvas.SetPos(X + 10 * Scale,Y + 16 * Scale);
    	Canvas.Font=MyFonts.GetHugeFont(Canvas.ClipX);
    	Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score));
    }
    else
	   DrawBigNum(Canvas, int(PawnOwner.PlayerReplicationInfo.Score), X + 40 * Scale, Y + 16 * Scale);
}

simulated function DrawAmmo(Canvas Canvas)
{
    local int X,Y;

    Canvas.Style = Style;
    Canvas.DrawColor = HUDColor;
    if ( bHideAllWeapons || (HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale) )
        Y = Canvas.ClipY - 63.5 * Scale;
    else
        Y = Canvas.ClipY - 127.5 * Scale;
    if ( bHideAllWeapons )
        X = 0.5 * Canvas.ClipX + 128 * Scale;
    else
        X = Canvas.ClipX - 128 * Scale;
    Canvas.SetPos(X, Y);
    Canvas.DrawTile(Texture'BotPack.HudElements1', 128*Scale, 64*Scale, 128, 192, 128.0, 64.0);

    if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) )
        return;

    Canvas.DrawColor = WhiteColor;

    if (PawnOwner.Weapon.AmmoType.AmmoAmount <= 999)
        DrawBigNum(Canvas, PawnOwner.Weapon.AmmoType.AmmoAmount, X + 8 * Scale, Y + 16 * Scale);
    else {
        Canvas.Font=MyFonts.GetHugeFont(Canvas.ClipX);
        Canvas.SetPos(X + 10 * Scale,Y + 16 * Scale);
        Canvas.DrawText(PawnOwner.Weapon.AmmoType.AmmoAmount);
    }
}

simulated function DrawStatus(Canvas Canvas)
{
    local float X, Y;

    //Super.DrawStatus(Canvas);

    //Canvas.DrawColor = HUDColor;  // Sets the logo tile to HUD color
    if ( bHideStatus && bHideAllWeapons )
    {
        X = 0.5 * Canvas.ClipX - 128 * Scale;
        Y = Canvas.ClipY - 64 * Scale;
    }
    else
    {
        //X = Canvas.ClipX - 128 * Scale * StatusScale - 140 * Scale;
        X = Canvas.ClipX - 128 * Scale * StatusScale - 1 * Scale;
        Y = 128 * Scale;
    }

    Canvas.SetPos(X, Y);
    Canvas.DrawTile(Texture'MHudIconHit', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);
    DrawPlayerPic(Canvas);
}

simulated function DrawPlayerPic(Canvas Canvas)
{
    local float StatScale, ChestAmount, ThighAmount, H1, H2, X, Y, DamageTime;
    Local int ArmorAmount,CurAbs,i;
    Local inventory Inv,BestArmor;
    local bool bChestArmor, bShieldbelt, bThighArmor, bJumpBoots, bHasDoll;
    local Bot BotOwner;
    local TournamentPlayer TPOwner;
    local texture Doll, DollBelt;

    ArmorAmount = 0;
    CurAbs = 0;
    i = 0;
    BestArmor=None;

    for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
    {
        if (Inv.bIsAnArmor)
        {
            if ( Inv.IsA('UT_Shieldbelt') )
                bShieldbelt = true;
            else if ( Inv.IsA('Thighpads') )
            {
                ThighAmount += Inv.Charge;
                bThighArmor = true;
            }
            else
            {
                bChestArmor = true;
                ChestAmount += Inv.Charge;
            }
            ArmorAmount += Inv.Charge;
        }
        else if ( Inv.IsA('UT_JumpBoots') )
            bJumpBoots = true;
        else
        {
            i++;
            if ( i > 100 )
                break; // can occasionally get temporary loops in netplay
        }
    }

    if ( !bHideStatus )
    {
        TPOwner = TournamentPlayer(PawnOwner);
        if ( Canvas.ClipX < 400 )
            bHasDoll = false;
        else if ( TPOwner != None)
        {
            Doll = TPOwner.StatusDoll;
            DollBelt = TPOwner.StatusBelt;
            bHasDoll = true;
        }
        else
        {
            BotOwner = Bot(PawnOwner);
            if ( BotOwner != None )
            {
                Doll = BotOwner.StatusDoll;
                DollBelt = BotOwner.StatusBelt;
                bHasDoll = true;
            }
        }
        if ( bHasDoll )
        {
            Canvas.Style = ERenderStyle.STY_Translucent;
            StatScale = (Scale * StatusScale)/1.6;  // shrink the playerpic
            X = Canvas.ClipX - 128 * StatScale;
            Canvas.SetPos(X, 0);
            if (PawnOwner.DamageScaling > 2.0)
                Canvas.DrawColor = PurpleColor;
            else
                Canvas.DrawColor = HUDColor;
            Canvas.DrawTile(Doll, 128*StatScale, 256*StatScale, 0, 0, 128.0, 256.0);
            Canvas.DrawColor = HUDColor;
            if ( bShieldBelt )
            {
                Canvas.DrawColor = BaseColor;
                Canvas.DrawColor.B = 0;
                Canvas.SetPos(X, 0);
                Canvas.DrawIcon(DollBelt, StatScale);
            }
            if ( bChestArmor )
            {
                ChestAmount = FMin(0.01 * ChestAmount,1);
                Canvas.DrawColor = HUDColor * ChestAmount;
                Canvas.SetPos(X, 0);
                Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 0, 128, 64);
            }
            if ( bThighArmor )
            {
                ThighAmount = FMin(0.02 * ThighAmount,1);
                Canvas.DrawColor = HUDColor * ThighAmount;
                Canvas.SetPos(X, 64*StatScale);
                Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 64, 128, 64);
            }
            if ( bJumpBoots )
            {
                Canvas.DrawColor = HUDColor;
                Canvas.SetPos(X, 128*StatScale);
                Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 128, 128, 64);
            }
            Canvas.Style = Style;
            if ( (PawnOwner == PlayerOwner) && Level.bHighDetailMode && !Level.bDropDetail )
            {
                for ( i=0; i<4; i++ )
                {
                    DamageTime = Level.TimeSeconds - HitTime[i];
                    if ( DamageTime < 1 )
                    {
                        Canvas.SetPos(X + HitPos[i].X * StatScale, HitPos[i].Y * StatScale);
                        if ( (HUDColor.G > 100) || (HUDColor.B > 100) )
                            Canvas.DrawColor = RedColor;
                        else
                            Canvas.DrawColor = (WhiteColor - HudColor) * FMin(1, 2 * DamageTime);
                        Canvas.DrawColor.R = 255 * FMin(1, 2 * DamageTime);
                        Canvas.DrawTile(Texture'BotPack.HudElements1', StatScale * HitDamage[i] * 25, StatScale * HitDamage[i] * 64, 0, 64, 25.0, 64.0);
                    }
                }
            }
        }
    }
    Canvas.DrawColor = HUDColor;
    if ( bHideStatus && bHideAllWeapons )
    {
        X = 0.5 * Canvas.ClipX;
        Y = Canvas.ClipY - 64 * Scale;
    }
    else
    {
        X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
        Y = 64 * Scale;
    }
    Canvas.SetPos(X,Y);
//  if ( PawnOwner.Health < 50 )
    if ( PawnOwner.Health < 75 )
    {
        H1 = 1.5 * TutIconBlink;
        H2 = 1 - H1;
        Canvas.DrawColor = WhiteColor * H2 + (HUDColor - WhiteColor) * H1;
    }
    else
        Canvas.DrawColor = HUDColor;
    Canvas.DrawTile(Texture'BotPack.HudElements1', 128*Scale, 64*Scale, 128, 128, 128.0, 64.0);

//  if ( PawnOwner.Health < 50 )
    if ( PawnOwner.Health < 75 )
    {
        H1 = 1.5 * TutIconBlink;
        H2 = 1 - H1;
        Canvas.DrawColor = Canvas.DrawColor * H2 + (WhiteColor - Canvas.DrawColor) * H1;
    }
    else
        Canvas.DrawColor = WhiteColor;

    DrawBigNum(Canvas, Max(0, PawnOwner.Health), X + 4 * Scale, Y + 16 * Scale, 1);

    Canvas.DrawColor = HUDColor;
    if ( bHideStatus && bHideAllWeapons )
    {
        X = 0.5 * Canvas.ClipX - 128 * Scale;
        Y = Canvas.ClipY - 64 * Scale;
    }
    else
    {
        X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
        Y = 0;
    }
    Canvas.SetPos(X, Y);
    Canvas.DrawTile(Texture'BotPack.HudElements1', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);
    if ( bHideStatus && bShieldBelt )
        Canvas.DrawColor = GoldColor;
    else
        Canvas.DrawColor = WhiteColor;
    DrawBigNum(Canvas, Min(150,ArmorAmount), X + 4 * Scale, Y + 16 * Scale, 1);
}


simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

    if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') ||
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		}
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	}
	else
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message)
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640)
								== Message.Static.GetOffset(Switch, 24, 640)) )
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}

        for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
    local int i;
    local Class<LocalMessage> MessageClass;

    switch (MsgType)
    {
        case 'Say':
            MessageClass = class'SayMessagePlus';
            break;
        case 'TeamSay':
            MessageClass = class'TeamSayMessagePlus';
            break;
        case 'CriticalEvent':
            MessageClass = class'CriticalStringPlus';
            LocalizedMessage( MessageClass, 0, None, None, None, Msg );
            return;

        case 'MonsterCriticalEvent':
            MessageClass = class'MonsterCriticalString';
            LocalizedMessage( MessageClass, 0, None, None, None, Msg );
            return;

        case 'DeathMessage':
            MessageClass = class'RedSayMessagePlus';
            break;
        case 'Pickup':
            PickupTime = Level.TimeSeconds;
        default:
            MessageClass = class'StringMessagePlus';
            break;
    }

    if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') ||
                     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
    {
        FaceTexture = PRI.TalkTexture;
        FaceTeam = TeamColor[PRI.Team];
        if ( FaceTexture != None )
            FaceTime = Level.TimeSeconds + 3;
        if ( Msg == "" )
            return;
    }

    for (i=0; i<4; i++)
    {
        if ( ShortMessageQueue[i].Message == None )
        {
            // Add the message here.
            ShortMessageQueue[i].Message = MessageClass;
            ShortMessageQueue[i].Switch = 0;
            ShortMessageQueue[i].RelatedPRI = PRI;
            ShortMessageQueue[i].OptionalObject = None;
            ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
            if ( MessageClass.Default.bComplexString )
                ShortMessageQueue[i].StringMessage = Msg;
            else
                ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
            return;
        }
    }

    // No empty slots.  Force a message out.
    for (i=0; i<3; i++)
        CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

    ShortMessageQueue[3].Message = MessageClass;
    ShortMessageQueue[3].Switch = 0;
    ShortMessageQueue[3].RelatedPRI = PRI;
    ShortMessageQueue[3].OptionalObject = None;
    ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
    if ( MessageClass.Default.bComplexString )
        ShortMessageQueue[3].StringMessage = Msg;
    else
        ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}


simulated function DrawMBlackStuff( canvas Canvas )
{
    Canvas.DrawColor = WhiteColor;
    Canvas.Style = ERenderStyle.STY_Modulated;

    Canvas.SetPos(0, 0);
    Canvas.DrawTile(Texture'MBlackStuff', Canvas.ClipX, 160*Scale, 0, 0, 16, 64);
    Canvas.SetPos(0, Canvas.ClipY - (160*Scale));
    Canvas.DrawTile(Texture'MBlackStuff2', Canvas.ClipX, 160*Scale, 0, 0, 16, 64);

    Canvas.Style = ERenderStyle.STY_Translucent;
}

simulated function PostRender( Canvas Canvas )
{
    super.HUDSetup(canvas);

    if (Canvas == none) return;

    super.PostRender(Canvas);

    if ( MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).bUseLives
         && (PawnOwner.PlayerReplicationInfo.Deaths < 1) && !PawnOwner.IsA('Spectator'))
        DrawMBlackStuff(Canvas);

    if ( PawnOwner == PlayerOwner ) 
        DrawMonsterName(Canvas);

    DrawRadar(Canvas);

    if ( !bHideHUD && PawnOwner == PlayerOwner )
		DrawIdentifyInfo(Canvas);

    if (!PlayerOwner.bShowScores && !bForceScores)
		DrawPlayerLists (Canvas);
}

simulated function DrawPlayerLists (Canvas C)
{
    local float XL, YL, YOffSetP, YOffSetS;
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
    local string playerString;

    if (PlayerOwner.PlayerReplicationInfo == none || C == none) return;

	C.Font=C.SmallFont;
//	C.Font=C.MedFont;
	C.DrawColor=HitColor;

	C.StrLen("[Player(LOCATION)] ", XL, YL);
	C.SetPos(C.ClipX - XL, C.ClipY / 4);
	C.DrawText("[Soldier(LOCATION)]",False);

	C.StrLen("[Spectators] ",XL,YL);
	C.SetPos(C.ClipX - XL,C.ClipY / 1.5);
	C.DrawColor=RedColor;
	C.DrawText("[Spectators] ",False);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}

	SortScores(PlayerCount);

    YOffSetP = C.ClipY/4 + YL;
    YOffSetS = C.ClipY/1.5 + YL;

    for (i = 0; i < playerCount; ++i)
    {
        if (Ordered[i].PlayerName ~= "player")
        {
        }
        else
        {

            playerString = Ordered[i].PlayerName;
            if (!Ordered[i].bIsSpectator)
            {
                if (Ordered[i].PlayerLocation != none && Ordered[i].PlayerLocation.LocationName != "")
                    playerString = playerString@"("$Ordered[i].PlayerLocation.LocationName$")";
                else if (Ordered[i].PlayerZone != none && Ordered[i].PlayerZone.ZoneName != "")
                    playerString = playerString@"("$Ordered[i].PlayerZone.ZoneName$")";
            }

            if (len(playerstring) > 30)
               playerString = left(playerString, 30)$")"; // truncate if longer than 30 chars

            C.StrLen (playerString$" ", XL, YL);
            if (Ordered[i].bIsSpectator) {
                C.SetPos(C.ClipX - XL, YOffSetS);
                YOffSetS += YL;
            }
            else {
                C.SetPos(C.ClipX - XL, YOffSetP);
                YOffSetP += YL;
            }
            if (!Ordered[i].bIsSpectator && PlayerOwner.PlayerReplicationInfo.PlayerName == Ordered[i].PlayerName)
                C.DrawColor=GoldColor;
            else
                C.DrawColor=WhiteColor;

            C.DrawText (playerString, False);
        }
    }
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;

	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	local float XL, YL, XOffset, X1;
	local Pawn P;

    if (Canvas == none || MyFonts == none) return false;

	if ( !TraceIdentify(Canvas))
		return false;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

    if (Canvas.Font == none) return false;

	if( IdentifyTarget.PlayerName != "" )
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);

	Canvas.StrLen("MYTEST", XL, YL);
	if( PawnOwner.PlayerReplicationInfo.Team == IdentifyTarget.Team )
	{
		P = Pawn(IdentifyTarget.Owner);
		Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
		if ( P != None )
			DrawTwoColorID(Canvas,IdentifyHealth,string(P.Health), (Canvas.ClipY - 256 * Scale) + 1.5 * YL);
	}

	return true;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	if ( type == 0 )
		Canvas.DrawColor = AltTeamColor[IdentifyTarget.Team] * 0.333 * IdentifyFadeTime;
	else
		Canvas.DrawColor = TeamColor[IdentifyTarget.Team] * 0.333 * IdentifyFadeTime;
}

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 2500.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function DrawMonsterName(Canvas C)
{
	local ScriptedPawn thisPawn;
	local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
	local rotator CamRot;
	local Actor Camera;
	local float BaseBeaconScale, BeaconScale, Dist, DistScale;
	local float TanFOVx, TanFOVy;
	local float TanX, TanY;
	local float dx, dy, FontY;
	local string BeaconText;

	C.Style = ERenderStyle.STY_Masked;

	if (C.ClipX > 1024)
		C.Font = Font'BeaconNameFontLarge';
	else if (C.ClipX > 640)
		C.Font = Font'BeaconNameFontMedium';
	else
		C.Font = Font'BeaconNameFontSmall';
	
	C.SetPos(0, 0);
	C.TextSize("X", dx, FontY);
	BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;
	
        C.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(C.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
	TanFOVy = (C.ClipY / C.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	C.bNoSmooth = False;
	C.Style = ERenderStyle.STY_Masked;
	foreach AllActors(class'ScriptedPawn', thisPawn)
        {
		//if (thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden && thisPawn.PlayerReplicationInfo != None && thisPawn.PlayerReplicationInfo.Team < 4 && (C.Viewport.Actor.PlayerReplicationInfo.bIsSpectator && !bHideSpectatorBeacons || !C.Viewport.Actor.PlayerReplicationInfo.bIsSpectator && thisPawn.PlayerReplicationInfo.Team != C.Viewport.Actor.PlayerReplicationInfo.Team)) {
		  //if (thisPawn != Camera && thisPawn.Health > 0)
		  if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden && thisPawn.Team < 4)
		    {
                        TargetDir = thisPawn.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
			TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
			DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);

			if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc) || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc))) 
                        {
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;
				
				dx = C.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = C.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				
				C.DrawColor = BeaconColor;
				C.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);
				//C.DrawIcon(TeamBeaconIcon, BeaconScale);

				// only draw name if close enough

				if (DistScale == 1.0)
                                {
					//BeaconText = thisPawn.PlayerReplicationInfo.PlayerName;
					if (C.ClipX > 600)
						//BeaconText = BeaconText @ "(" $ thisPawn.Health $ ")";
						BeaconText = "" $ thisPawn.Health $ "";

					// shadow

					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
					C.DrawColor = BeaconColor * 0.125;
					C.DrawTextClipped(BeaconText, False);

					// color
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
					C.DrawColor = BeaconColor;
					C.DrawTextClipped(BeaconText, False);
				}

			}
		}
	}
}

simulated function drawRadar(canvas Canvas)
{
    local ScriptedPawn Monster;
    local int index, radius;
    local int originX, originY;
    local Pawn P;

    if(!Owner.IsA('PlayerPawn'))
        {
        Log("Owner: ("$Owner$") does not want me loaded", Class.Name);
        return;
    }

    Canvas.Reset();

//    radius = Canvas.sizeY/16;
    radius = Canvas.sizeY/13;

        switch(Position)
        {
    case RADAR_TopLeft:
        originX = 30;
        originY = 30;
        break;
    case RADAR_TopMiddle:
        originX = Canvas.SizeX/2 - radius;
        originY = 30;
        break;
    case RADAR_TopRight:
        originX = Canvas.SizeX - radius*2 - 30;
        originY = 30;
        break;
    case RADAR_MiddleLeft:
        originX = 10;
//        originY = Canvas.SizeY/2 - radius;
        originY = Canvas.SizeY/1.75 - radius;
        break;
    case RADAR_MiddleRight:
//        originX = Canvas.SizeX - radius - 80;
        originX = Canvas.SizeX - radius - 100;
//        originY = Canvas.SizeY/2 - radius;
        originY = Canvas.SizeY/1.7 - radius;
        break;
    case RADAR_BottomLeft:
        originX = 30;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
    case RADAR_BottomMiddle:
        originX = Canvas.SizeX/2 - radius;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
    case RADAR_BottomRight:
        originX = Canvas.SizeX - radius*2 - 30;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
    }
    Canvas.Style = ERenderStyle.STY_Translucent;    // new attempt at transparency
    Canvas.SetPos(originX, originY);
    Canvas.DrawTile(tex, radius*2, radius*2, 0, 0, 128, 128);

    foreach AllActors(class'ScriptedPawn', Monster)
        {
        if(Monster.Health <= 0) continue;
        drawBlip(Monster, Canvas, originX, originY, radius);
        }
}

simulated function drawBlip(Pawn other, canvas Canvas, int originX, int originY, int radius)
{
    local rotator myRotation, monsterRotation, blipRotation;
    local int x, y, monsterDistance;
    local Vector point, myLocation, monsterLocation;
    local Weapon weapon;
    local PlayerPawn pOwner;

    if(other.Health <= 0) {
                Canvas.DrawColor.R = 255;
        Canvas.DrawColor.G = 0;
        Canvas.DrawColor.B = 0;
    } else {
                Canvas.DrawColor.R = 255;
        Canvas.DrawColor.G = 255;
        Canvas.DrawColor.B = 255;
    }
//Error logging
    if(Owner == none)
    {
        Log("draw MonsterPoint: I don't have an owner!", Class.Name);
        return;
    }

    pOwner = PlayerPawn(Owner);
    if(pOwner == none)
    {
        Log("draw Monster Point: pOwner is null!", Class.Name);
        return;
    }

    if(Canvas == none || other == none)
    {
        Log("draw Monster Point: Canvas: "$Canvas$", other: "$other, Class.Name);
        return;
    }

    weapon = pOwner.Weapon;
    if(Weapon != none && Weapon.IsA('WarheadLauncher') &&
       WarheadLauncher(Weapon).bGuiding &&
       WarheadLauncher(Weapon).GuidedShell != none) {
        myLocation = WarheadLauncher(Weapon).GuidedShell.Location;
    } else {
        myLocation = Owner.Location;
    }
    myLocation.z = 0;

    myRotation = pOwner.ViewRotation;
    myRotation.Yaw  += 16384;
    myRotation.Pitch = 0;
    myRotation.Roll  = 0;

    monsterLocation   = other.Location;
    monsterLocation.z = 0;
    point = myLocation - monsterLocation;
    monsterDistance = VSize(point);
    monsterRotation = rotator(point);
    monsterRotation.Pitch = 0;
    monsterRotation.Roll  = 0;

    blipRotation = myRotation - monsterRotation;

    point = monsterDistance * vector(blipRotation);

    if(VSize(point) < radius*50)
        {
                point.x = -point.x / 50 + radius + originX;
        point.y = point.y / 50 + radius + originY;
            Canvas.SetPos(point.x, point.y);
        Canvas.DrawTile(Texture'monsterpoint', 3, 3, 0, 0, 2, 2);
    }
}

function setZscale(int value)
{
    if(value < 1) value = 1;
    scale = value;
}

simulated function DrawInfo(canvas Canvas)
{
    local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
    local actor Other;
    local Pawn PawnOwner;
    local rotator AdjustedAim;

    PawnOwner = Pawn(Owner);

    GetAxes(PawnOwner.ViewRotation,X,Y,Z);

    StartTrace  = Owner.Location + PawnOwner.Eyeheight * Z;
    AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 0, False, False);
    X           = vector(AdjustedAim);
    EndTrace    = StartTrace + 10000 * X;
    Other       = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

    ProcessTrace(Canvas, Other);
}

simulated function ProcessTrace(canvas Canvas, Actor Other)
{
    local int originX, originY;
    local Pawn pawnOther;

    originX   = Canvas.SizeX / 2 - 100;
    originY   = Canvas.SizeY / 2 + 100;

    if(Other == none || !Other.IsA('ScriptedPawn')) return;

    Canvas.Reset();

    Canvas.DrawColor.R = 255;
    Canvas.DrawColor.G = 255;
    Canvas.DrawColor.B = 255;
    Canvas.Font        = Canvas.smallFont;

    pawnOther = Pawn(Other);

    Canvas.setPos(originX, originY);
    Canvas.drawText("Name: " $ pawnOther.getHumanName());
    Canvas.setPos(originX, originY+10);
    Canvas.drawText("Health: " $ pawnOther.Health);
} 

defaultproperties
{
    HitColor=(R=0,G=204,B=51,A=0),
    Deemercolor=(R=138,G=43,B=226,A=0),
    Tex=Texture'radarconsole'
    Position=3
    RankString=" Rank:"
    SpreadString=" Spread:"
    Zscale=50
    TeamBeaconIcon=Texture'TeamBeacon2'
    BeaconColor=(R=0,G=150,B=0,A=0),
    bAlwaysRelevant=True
    bNetTemporary=True
}
