
class HittyJumpBoots extends UT_JumpBoots;

#exec TEXTURE IMPORT NAME=UMBoots FILE=Textures\UMBoots0.bmp GROUP=Skins FLAGS=2

var int TimeCharge;

function PickupFunction(Pawn Other)
{
    TimeCharge = 0;
    SetTimer(1.0, True);
}

function ResetOwner()
{
    local pawn P;

    P = Pawn(Owner);
    P.JumpZ = P.Default.JumpZ * Level.Game.PlayerJumpZScaling();
    if ( Level.Game.IsA('DeathMatchPlus') )
        P.AirControl = DeathMatchPlus(Level.Game).AirControl;
    else
        P.AirControl = P.Default.AirControl;
    P.bCountJumps = False;
}

function OwnerJumped()
{
    if ( !Pawn(Owner).bIsWalking )
    {
        TimeCharge=0;
        if ( Charge <= 0 ) 
        {
            if ( Owner != None )
            {
                Owner.PlaySound(DeActivateSound);
                ResetOwner();                       
            }       
            UsedUp();
        }
        else
            Owner.PlaySound(sound'BootJmp');
        Charge -= 1;
    }
    if( Inventory != None )
        Inventory.OwnerJumped();
}

function Timer()
{
    if ( Charge <= 0 ) 
    {
        if ( Owner != None )
        {
            if ( Owner.Physics == PHYS_Falling )
            {
                SetTimer(0.3, true);
                return;
            }
            Owner.PlaySound(DeActivateSound);
            ResetOwner();                       
        }       
        UsedUp();
        return;
    }

    if ( !Pawn(Owner).bAutoActivate )
    {   
        TimeCharge++;
        if (TimeCharge>20)
        {
            OwnerJumped();
            TimeCharge = 0;
        }
    }
}

state Activated
{
    function endstate()
    {
        ResetOwner();
        bActive = false;        
    }
Begin:
    Pawn(Owner).bCountJumps = True;
    Pawn(Owner).AirControl = 1.0;
    Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * 3;
    Owner.PlaySound(ActivateSound);     
}

state DeActivated
{
Begin:      
}

defaultproperties
{
    ExpireMessage="The Jump Boots have drained."
    PickupMessage="You picked up the UM Jump boots."
    RespawnTime=2.00
    Charge=4
    MultiSkins(1)=Texture'Skins.UMBoots'
}
