
class HittyRandomHealthMsg expands CriticalEventPlus;

#exec AUDIO IMPORT FILE="Sounds\placeholder.wav" NAME=placeholder
#exec AUDIO IMPORT FILE="Sounds\assist.wav" NAME=heala

var(Message) string	RHealthMessage[5];
var(Message) sound	RHealthSound[5];

static function string GetString(optional int Switch, optional PlayerReplicationInfo RelatedPRI_1,
optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject)
{
	if(Switch == 0)
       	return RelatedPRI_1.PlayerName$Default.RHealthMessage[Switch];
	else
       	return Default.RHealthMessage[Switch];
}

static simulated function ClientReceive( PlayerPawn P, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1,
optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject)
{
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	if(Switch < 5)P.ClientPlaySound(Default.RHealthSound[Switch],, true);
}

defaultproperties
{
    RHealthMessage(0)=" Gets HP +500!!"
    RHealthMessage(1)="1.. "
    RHealthMessage(2)="2.. "
    RHealthMessage(3)="3.. "
    RHealthMessage(4)=" Random Health Coming Up!"
    RHealthSound(0)=Sound'heala'
    RHealthSound(4)=Sound'Botpack.Generic.RespawnSound2'
}
