
class HittySuperHealth extends SuperHealth config(HitmanModv8);

var config int MaxHealth;

auto state Pickup
{   
        function Touch( actor Other )
        {
                local Pawn P;

                if ( ValidTouch(Other) )
                {
                        P = Pawn(Other);
                        if (bSuperHeal) MaxHealth = Min(MaxHealth, MaxHealth * 2.0);
                        if (P.Health < MaxHealth)
                        {
                                if (Level.Game.LocalLog != None)
                                        Level.Game.LocalLog.LogPickup(Self, P);
                if (Level.Game.WorldLog != None)
                    Level.Game.WorldLog.LogPickup(Self, P);
                P.Health += HealingAmount;
                if (P.Health > MaxHealth) P.Health = MaxHealth;
                PlayPickupMessage(P);
                PlaySound (PickupSound,,2.5);
                    Other.MakeNoise(0.1 * Level.Game.Difficulty);
                SetRespawn();
            }
        }
    }
}

defaultproperties
{
    MaxHealth=500
    RespawnTime=2.00
}
