// Class used by permission of TheCatcher
// Heavily modified from AKA
// See him for permissions on this class
// TheCatcher@OHNOSoftware.com

class MH2PlayerLog expands Mutator config(HittyPlayerList);

var bool Initialized;
var bool bUpdate;
var config int NameCheckDelaySeconds;
var config bool bAutoAddIPToNameEntries;
var config bool bChangeNames;
var config int KeepNameHistory;
var config string IPToName[5000];
var config string LastPlayed[5000];

function PostBeginPlay()
{
	if (!Initialized)
	    {
    	        Initialized = true;
		bUpdate = false;
		if ( NameCheckDelaySeconds > 0 )
				settimer(NameCheckDelaySeconds, true); // call us every NameCheckDelaySeconds...
	    }
	Super.PostBeginPlay();
}

function ModifyPlayer(Pawn Other)
{
        local int iNameChanged;
        local string PawnIP, OrigName;
        local bool bFound;

	if ( ( ( Other.bIsPlayer ) || ( Other.IsA('MessagingSpectator') ) )
		&&	(PlayerPawn(Other)!=None) && (NetConnection(PlayerPawn(Other).Player)!=None ) )
		{
		OrigName = Other.PlayerReplicationInfo.PlayerName;
		PawnIP = "";
		bFound = CheckName( Other, OrigName, PawnIP, bChangeNames, iNameChanged );	// Only sets the name if it needs to be set
		if ( ( ( bFound ) && ( ( KeepNameHistory == 1 ) || ( KeepNameHistory == 3 ) ) )
			|| ( ( ! bFound ) && ( ( KeepNameHistory == 2 ) || ( KeepNameHistory == 3 ) ) ) )
			NameHistory( Other, OrigName, PawnIP, iNameChanged );
		}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function Timer()
{
	CheckNames( bChangeNames );
	Super.Timer();
}


function CheckNames( bool bChangeName )
{
        local int iNameChanged;
        local Pawn pPawn;
        local string PawnIP, OrigName;
        local bool bFound;

	for (pPawn = Level.PawnList; pPawn != None; pPawn = pPawn.NextPawn)
		{
		if ( ( ( pPawn.bIsPlayer ) || ( pPawn.IsA('MessagingSpectator') ) )
			&&	(PlayerPawn(pPawn)!=None) && (NetConnection(PlayerPawn(pPawn).Player)!=None ) )
			{
			PawnIP = "";
			bFound = CheckName( pPawn, OrigName, PawnIP, bChangeName, iNameChanged );
			if ( ( iNameChanged != 0 )
				&& ( ( ( bFound ) && ( ( KeepNameHistory == 1 ) || ( KeepNameHistory == 3 ) ) )
					|| ( ( ! bFound ) && ( ( KeepNameHistory == 2 ) || ( KeepNameHistory == 3 ) ) ) ) )
				NameHistory( pPawn, OrigName, PawnIP, iNameChanged );
			}
		}
}

function bool CheckName( Pawn pPawn, out string OrigName, out string MatchingIP, bool bChangeName, out int iNameChanged )
{
        local int i, ii, iAsterick, iColon;
        local string IPPort, IP, PawnIP, OutName, MatchingIPToName;
        local bool bFound;

	bFound = false;
	iNameChanged = 0;

	IPPort = PlayerPawn(pPawn).GetPlayerNetworkAddress();
	iColon = InStr( IPPort, ":" );
	PawnIP = Left( IPPort, iColon );
	OrigName = pPawn.PlayerReplicationInfo.PlayerName;

	for ( i = 0; ( ( i < 5000 ) && ( Len( IPToName[ i ] ) > 0 ) ); i++ )
		{
		iColon = InStr( IPToName[ i ], ":" );
		IP = Left( IPToName[ i ], iColon );

		iAsterick = InStr(IP,"*");
		if ( iAsterick <= 0 )
			iAsterick = 0;

		if ( ( iAsterick != 0 ) && ( Left(IP, iAsterick ) == Left(PawnIP, iAsterick ) )
			|| ( ( iAsterick == 0 ) && ( IP == PawnIP ) ) )
			{
			bFound = true;
			MatchingIP = IP;
			MatchingIPToName = IPToName[ i ];
			OutName = Mid( IPToName[ i ], iColon + 1 );
			if ( ( bChangeName ) && ( OutName != OrigName ) )
				{
				pPawn.PlayerReplicationInfo.PlayerName = OutName;
				iNameChanged = 1;
				}
			break;
			}
		}

	if ( ! bFound )
		{
		MatchingIP = PawnIP;
		if ( bAutoAddIPToNameEntries )
			{
			bFound = true;
			MatchingIPToName = MatchingIP $ ":" $ OrigName;
			if ( i >= 5000 )
				i = 4999;
			}
		}

	// if bFound then move entry to the top of the IPToName list
	if ( bFound )
		{
		for( ii = i; ii > 0; ii-- )			// Move all the previous entries down
			IPToName[ ii ] = IPToName[ ii - 1 ];
		IPToName[ 0 ] = MatchingIPToName;			// Put this entry at the top of the list
		bUpdate = true;
		}

	return( bFound );
}

function NameHistory( Pawn pPawn, string OrigName, string PawnIP, int iNameChanged )
{
        local int i, ii, iComa1, iComa2, iNamePos;
        local string IPPort, IP, OutEntry, NewNamesTail, TempStr, TempStr2, DateStr, CurName;
        local bool bFound;

	bFound = false;

	DateStr = string( Level.Year ) $ "-" $ Right( "00"$string( Level.Month ), 2 ) $ "-" $ Right( "00"$string( Level.Day ), 2 ) $ " " $ Right( "00"$string( Level.Hour ), 2 ) $ ":" $ Right( "00"$string( Level.Minute ), 2 ) $ ":" $ Right( "00"$string( Level.Second ), 2 );
	CurName = pPawn.PlayerReplicationInfo.PlayerName;

	for ( i = 0; ( ( i < 5000 ) && ( Len( LastPlayed[ i ] ) > 0 ) ); i++ )
		{
		iComa1 = InStr( LastPlayed[ i ], "," );
		IP = Left( LastPlayed[ i ], iComa1 );

		if ( PawnIP == IP )
			{
			TempStr = Mid( LastPlayed[ i ], iComa1 + 1 );	// Skip past the IP
			iComa2 = InStr( TempStr, "," );			// Skip past the Date & Time
			TempStr = Mid( TempStr, iComa2 );

			iNamePos = InStr( Caps( TempStr ), "," $ Caps( OrigName ) );	// Remove the old occurances of the current name
			if ( iNamePos >= 0 )
				TempStr2 = Left(TempStr, iNamePos) $ Right(TempStr, Len(TempStr) - iNamePos - (Len(OrigName)+1));
			else
				TempStr2 = TempStr;

			iNamePos = InStr( Caps( TempStr2 ), "," $ Caps( CurName ) );	// Remove the old occurances of the current name
			if ( iNamePos >= 0 )
				NewNamesTail = Left(TempStr2, iNamePos) $ Right(TempStr2, Len(TempStr2) - iNamePos - (Len(CurName)+1));
			else
				NewNamesTail = TempStr2;

			if ( Caps( OrigName ) != Caps( CurName ) )
				OutEntry = PawnIP $ "," $ DateStr $ "," $ CurName $ "," $ OrigName $ NewNamesTail;	// Build the new entry
			else
				OutEntry = PawnIP $ "," $ DateStr $ "," $ OrigName $ NewNamesTail;	// Build the new entry
			bFound = true;
			break;
			}
		}
	if ( ! bFound )
		{
		if ( Caps( OrigName ) != Caps( CurName ) )
			OutEntry = PawnIP $ "," $ DateStr $ "," $ CurName $ "," $ OrigName;	// Build the new entry
		else
			OutEntry = PawnIP $ "," $ DateStr $ "," $ OrigName;	// Build the new entry
		}
	for( ii = i; ii > 0; ii-- )			// Move all the previous entries down
		LastPlayed[ ii ] = LastPlayed[ ii - 1 ];
	LastPlayed[ 0 ] = OutEntry;			// Put this entry at the top of the list
	bUpdate = true;
}

function bool HandleEndGame()
{
	if ( bUpdate )
		SaveConfig();

	if ( NextMutator != None )
		return NextMutator.HandleEndGame();

        return false;
}

defaultproperties
{
    bAutoAddIPToNameEntries=True
    KeepNameHistory=3
}
