class MHPoweredMonster extends Mutator config(HitmanModv8);

var config int StrongLevel;
var config int DrawScaleMultiplier;
var config string ExcludeMaps[128];
var config float PowerUpPercent;
var config float maxMonsterHealth;

function PostBeginPlay()
{
	local ScriptedPawn S;
    local string MapName;

    Log("***");
    Log("*** MH Powered Monster Mutator initialized.....");
    Log("***");
    if (StrongLevel > 0)
    {
        GetCurrentMapName(MapName);
        if (!IsMapExcluded(MapName))
        {
            Log ("Checking monster stats....");

        	foreach AllActors(class'ScriptedPawn', S)
                PowerUpMonsterStats(S);

        	SetTimer(5.0,True); // powerup damage is now called from timer
        }
        else
        {
            Log ("Map:"@MapName@"is in the exclude map list for powered monsters");
        }
    }
    else
        Log ("StrongLevel is disabled!");

    Log(" ");
    Log("Checking max monster health...");
    Log ("Max health is set to"@maxMonsterHealth);

	foreach AllActors(class'ScriptedPawn', S)
        if (S.Health >= maxMonsterHealth)
        {
           Log ("Found:"@S.Class@"with health"@S.Health@"drawscale"@S.DrawScale);
           if (S.DrawScale > 1.0)
              S.Health = maxMonsterHealth/(int(S.DrawScale)/Default.DrawScale);
           else
              S.Health = maxMonsterHealth;
           Log ("set to"@S.Health);
        }

    Log("");
	SaveConfig();

	Super.PostBeginPlay();
}

function string trim(string source)
{
	local int index;
	local string result;

	// Remove leading spaces.
	result = source;
	while (index < len(result) && mid(result, index, 1) == " ")
        {
		index++;
	}
	result = mid(result, index);

	// Remove trailing spaces.
	index = len(result) - 1;
	while (index >= 0 && mid(result, index, 1) == " ")
        {
		index--;
	}
	result = left(result, index + 1);

	// Return new string.
	return result;
}

function bool GetCurrentMapName (out string MapName)
{
	local int i;

	MapName=string(self);
	i=InStr(MapName,".");
	if ( i != -1 )
	{
		MapName=Left(MapName,i);
		return True;
	}
	return False;
}

function bool IsMapExcluded (string MapName)
{
    local int index;
    local string MapNameUNR;

    MapNameUNR = MapName$".unr";

	while (index < arrayCount(ExcludeMaps))
        {
        if ((trim(ExcludeMaps[index]) ~= MapName) || (trim(ExcludeMaps[index]) ~= MapNameUNR))
            return true;
        ++index;
	}
	return false;
}

simulated function Timer()
{
	local ScriptedPawn S;
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        {
 	    if ( P.IsA('TournamentPlayer') )
	    {
		    if(P.DamageScaling == 1.0)
      			P.DamageScaling = 1.5;
	    }
        }

	foreach AllActors(class'ScriptedPawn', S)
        {
		SetMonsterWeapon(S);
        PowerUpMonsterDamage(S);
        //CheckDamages (S);
	}
}

function CheckDamages (ScriptedPawn S)
{
	if (S.IsA('Brute'))
	{
        if (Brute(S).WhipDamage < Brute(S).default.WhipDamage)
           Log ("***Detected damage reset on Brute WhipDamage***");
	}
	else if (S.IsA('Gasbag'))
	{
        if (Gasbag(S).PunchDamage < Gasbag(S).default.PunchDamage)
           Log ("***Detected damage reset on Gasbag PunchDamage***");
        if (Gasbag(S).PoundDamage < Gasbag(S).default.PoundDamage)
           Log ("***Detected damage reset on Gasbag PoundDamage***");
	}
	else if (S.IsA('Titan'))
	{
        if (Titan(S).PunchDamage < Titan(S).default.PunchDamage)
           Log ("***Detected damage reset on Titan PunchDamage***");
        if (Titan(S).SlapDamage < Titan(S).default.SlapDamage)
           Log ("***Detected damage reset on Titan SlapDamage***");
	}
	else if (S.IsA('Krall'))
	{
        if (Krall(S).StrikeDamage < Krall(S).default.StrikeDamage)
           Log ("***Detected damage reset on Krall StrikeDamage***");
        if (Krall(S).ThrowDamage < Krall(S).default.ThrowDamage)
           Log ("***Detected damage reset on Krall ThrowDamage***");
        if (Krall(S).PoundDamage < Krall(S).default.PoundDamage)
           Log ("***Detected damage reset on Krall PoundDamage***");
	}
	else if (S.IsA('Manta'))
	{
        if (Manta(S).StingDamage < Manta(S).default.StingDamage)
           Log ("***Detected damage reset on Manta StingDamage***");
        if (Manta(S).WhipDamage < Manta(S).default.WhipDamage)
           Log ("***Detected damage reset on Manta WhipDamage***");
	}
	else if (S.IsA('Mercenary'))
	{
        if (Mercenary(S).PunchDamage < Mercenary(S).default.PunchDamage)
           Log ("***Detected damage reset on Mercenary PunchDamage***");
	}
	else if (S.IsA('Skaarj'))
	{
        if (Skaarj(S).ClawDamage < Skaarj(S).default.ClawDamage)
           Log ("***Detected damage reset on Skaarj ClawDamage***");
        if (Skaarj(S).LungeDamage < Skaarj(S).default.LungeDamage)
           Log ("***Detected damage reset on Skaarj LungeDamage***");
        if (Skaarj(S).SpinDamage < Skaarj(S).default.SpinDamage)
           Log ("***Detected damage reset on Skaarj SpinDamage***");
	}
	else if (S.IsA('Pupae'))
	{
        if (Pupae(S).BiteDamage < Pupae(S).default.BiteDamage)
           Log ("***Detected damage reset on Pupae BiteDamage***");
        if (Pupae(S).LungeDamage < Pupae(S).default.LungeDamage)
           Log ("***Detected damage reset on Pupae LungeDamage***");
	}
	else if (S.IsA('Queen'))
	{
        if (Queen(S).ClawDamage < Queen(S).default.ClawDamage)
           Log ("***Detected damage reset on Queen ClawDamage***");
        if (Queen(S).StabDamage < Queen(S).default.StabDamage)
           Log ("***Detected damage reset on Queen StabDamage***");
	}
	else if (S.IsA('Slith'))
	{
        if (Slith(S).ClawDamage < Slith(S).default.ClawDamage)
           Log ("***Detected damage reset on Slith ClawDamage***");
	}
	else if (S.IsA('Warlord'))
	{
        if (Warlord(S).StrikeDamage < Warlord(S).default.StrikeDamage)
           Log ("***Detected damage reset on Warlord StrikeDamage***");
	}
}

function PowerUpMonsterStats(ScriptedPawn S)
{
    if (S.Aggressiveness > 0)
        S.Aggressiveness = (S.Aggressiveness * PowerUpPercent) / 100;
    if (S.ReFireRate > 0)
	    S.ReFireRate = (S.ReFireRate * PowerUpPercent) / 100;
    if (S.CombatStyle > 0)
	    S.CombatStyle = (S.CombatStyle * PowerUpPercent) / 100;
    if (S.ProjectileSpeed > 0)
	    S.ProjectileSpeed = (S.ProjectileSpeed * PowerUpPercent) / 100;
    if (S.AccelRate > 0)
        S.AccelRate = (S.AccelRate * PowerUpPercent) / 100;
    if (S.MeleeRange > 0)
        S.MeleeRange = (S.MeleeRange * PowerUpPercent) / 100;

	if (S.IsA('Brute'))
	{
        if (Brute(S).Health <= 510) Brute(S).Health = 700;
	}
	else if (S.IsA('Gasbag'))
	{

	}
	else if (S.IsA('Titan'))
	{
	}
	else if (S.IsA('Krall'))
	{
        if (Krall(S).Health <= 280) Krall(S).Health = 300;
	}
	else if (S.IsA('Manta'))
	{
        if (Manta(S).Health <= 80) Manta(S).Health = 120;
	}
	else if (S.IsA('Mercenary'))
	{
	}
	else if (S.IsA('Skaarj'))
	{
	}
	else if (S.IsA('Pupae'))
	{
		if (Pupae(S).Health <= 65) Pupae(S).Health = 120;
	}
	else if (S.IsA('Queen'))
	{
	}
	else if (S.IsA('Slith'))
	{
 	    if (Slith(S).Health <= 210) Slith(S).Health = 250;
	}
	else if (S.IsA('Warlord'))
	{
	}
        else if (S.IsA('Tentacle'))
	{
        if (Tentacle(S).Health <= 50) Tentacle(S).Health = 250;
        }
        else if (S.IsA('Fly'))
	{
        if (Fly(S).Health <= 30) Fly(S).Health = 90;
        }
}

function byte AddVals (out byte Val1, byte Val2)

{
    if (Val1+Val2 > 255)
        Val1 = 255;
    else
        Val1 += Val2;

    return Val1;
}

function PowerUpMonsterDamage(ScriptedPawn S)
{
	if (S.IsA('Brute'))
	{
        if (Brute(S).WhipDamage <= Brute(S).default.WhipDamage)
        {
            Brute(S).WhipDamage = Brute(S).default.WhipDamage;

            if ((DrawScaleMultiplier > 0) && (Brute(S).DrawScale > 1.0))
    		    AddVals (Brute(S).WhipDamage, Brute(S).DrawScale * DrawScaleMultiplier);

   		    AddVals (Brute(S).WhipDamage, StrongLevel);
        }
	}
	else if (S.IsA('Gasbag'))
	{
        if (Gasbag(S).PunchDamage <= Gasbag(S).default.PunchDamage)
        {
            Gasbag(S).PunchDamage = Gasbag(S).default.PunchDamage;

    		if ((DrawScaleMultiplier > 0) && (GasBag(S).DrawScale > 1.0))
                AddVals (GasBag(S).PunchDamage, GasBag(S).DrawScale * DrawScaleMultiplier);

            AddVals (GasBag(S).PunchDamage, StrongLevel);
        }

        if (Gasbag(S).PoundDamage <= Gasbag(S).default.PoundDamage)
        {
            Gasbag(S).PoundDamage = Gasbag(S).default.PoundDamage;

    		if ((DrawScaleMultiplier > 0) && (GasBag(S).DrawScale > 1.0))
                AddVals (GasBag(S).PoundDamage, GasBag(S).DrawScale * DrawScaleMultiplier);

            AddVals (GasBag(S).PoundDamage, StrongLevel);
        }
	}
	else if (S.IsA('Titan'))
	{
        if (Titan(S).PunchDamage <= Titan(S).default.PunchDamage)
        {
            Titan(S).PunchDamage = Titan(S).default.PunchDamage;

    		if ((DrawScaleMultiplier > 0) && (Titan(S).DrawScale > 1.0))
                AddVals (Titan(S).PunchDamage, Titan(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Titan(S).PunchDamage, StrongLevel);
        }

        if (Titan(S).SlapDamage <= Titan(S).default.SlapDamage)
        {
            Titan(S).SlapDamage = Titan(S).default.SlapDamage;

    		if ((DrawScaleMultiplier > 0) && (Titan(S).DrawScale > 1.0))
                AddVals (Titan(S).SlapDamage, Titan(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Titan(S).SlapDamage, StrongLevel);
        }
	}
	else if (S.IsA('Krall'))
	{
        if (Krall(S).StrikeDamage <= Krall(S).default.StrikeDamage)
        {
            Krall(S).StrikeDamage = Krall(S).default.StrikeDamage;

    		if ((DrawScaleMultiplier > 0) && (Krall(S).DrawScale > 1.0))
    		   AddVals (Krall(S).StrikeDamage, Krall(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Krall(S).StrikeDamage, StrongLevel);
        }

        if (Krall(S).ThrowDamage <= Krall(S).default.ThrowDamage)
        {
            Krall(S).ThrowDamage = Krall(S).default.ThrowDamage;

    		if ((DrawScaleMultiplier > 0) && (Krall(S).DrawScale > 1.0))
    		   AddVals (Krall(S).ThrowDamage, Krall(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Krall(S).ThrowDamage, StrongLevel);
        }

        if (Krall(S).PoundDamage <= Krall(S).default.PoundDamage)
        {
            Krall(S).PoundDamage = Krall(S).default.PoundDamage;

    		if ((DrawScaleMultiplier > 0) && (Krall(S).DrawScale > 1.0))
    		   AddVals (Krall(S).PoundDamage, Krall(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Krall(S).PoundDamage, StrongLevel);
        }
	}
	else if (S.IsA('Manta'))
	{
        if (Manta(S).StingDamage <= Manta(S).default.StingDamage)
        {
            Manta(S).StingDamage = Manta(S).default.StingDamage;

    		if ((DrawScaleMultiplier > 0) && (Manta(S).DrawScale > 1.0))
    		   AddVals (Manta(S).StingDamage, Manta(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Manta(S).StingDamage, StrongLevel);
        }

        if (Manta(S).WhipDamage <= Manta(S).default.WhipDamage)
        {
            Manta(S).WhipDamage = Manta(S).default.WhipDamage;

    		if ((DrawScaleMultiplier > 0) && (Manta(S).DrawScale > 1.0))
    		   AddVals (Manta(S).WhipDamage, Manta(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Manta(S).WhipDamage, StrongLevel);
        }
	}
	else if (S.IsA('Mercenary'))
	{
        if (Mercenary(S).PunchDamage <= Mercenary(S).default.PunchDamage)
        {
            Mercenary(S).PunchDamage = Mercenary(S).default.PunchDamage;

    		if ((DrawScaleMultiplier > 0) && (Mercenary(S).DrawScale > 1.0))
    		   AddVals (Mercenary(S).PunchDamage, Mercenary(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Mercenary(S).PunchDamage, StrongLevel);
        }
	}
	else if (S.IsA('Skaarj'))
	{
        if (Skaarj(S).ClawDamage <= Skaarj(S).default.ClawDamage)
        {
            Skaarj(S).ClawDamage = Skaarj(S).default.ClawDamage;

    		if ((DrawScaleMultiplier > 0) && (Skaarj(S).DrawScale > 1.0))
    		   AddVals (Skaarj(S).ClawDamage, Skaarj(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Skaarj(S).ClawDamage, StrongLevel);
        }

        if (Skaarj(S).LungeDamage <= Skaarj(S).default.LungeDamage)
        {
            Skaarj(S).LungeDamage = Skaarj(S).default.LungeDamage;

    		if ((DrawScaleMultiplier > 0) && (Skaarj(S).DrawScale > 1.0))
    		   AddVals (Skaarj(S).LungeDamage, Skaarj(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Skaarj(S).LungeDamage, StrongLevel);
        }

        if (Skaarj(S).SpinDamage <= Skaarj(S).default.SpinDamage)
        {
            Skaarj(S).SpinDamage = Skaarj(S).default.SpinDamage;

    		if ((DrawScaleMultiplier > 0) && (Skaarj(S).DrawScale > 1.0))
    		   AddVals (Skaarj(S).SpinDamage, Skaarj(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Skaarj(S).SpinDamage, StrongLevel);
        }
	}
	else if (S.IsA('Pupae'))
	{
        if (Pupae(S).BiteDamage <= Pupae(S).default.BiteDamage)
        {
            Pupae(S).BiteDamage = Pupae(S).default.BiteDamage;

    		if ((DrawScaleMultiplier > 0) && (Pupae(S).DrawScale > 1.0))
                AddVals (Pupae(S).BiteDamage, Pupae(S).DrawScale * DrawScaleMultiplier);

            AddVals (Pupae(S).BiteDamage, StrongLevel);
        }

        if (Pupae(S).LungeDamage <= Pupae(S).default.LungeDamage)
        {
            Pupae(S).LungeDamage = Pupae(S).default.LungeDamage;

    		if ((DrawScaleMultiplier > 0) && (Pupae(S).DrawScale > 1.0))
                AddVals (Pupae(S).LungeDamage, Pupae(S).DrawScale * DrawScaleMultiplier);

            AddVals (Pupae(S).LungeDamage, StrongLevel);
        }
	}
	else if (S.IsA('Queen'))
	{
        if (Queen(S).ClawDamage <= Queen(S).default.ClawDamage)
        {
            Queen(S).ClawDamage = Queen(S).default.ClawDamage;

    		if ((DrawScaleMultiplier > 0) && (Queen(S).DrawScale > 1.0))
    		   Queen(S).ClawDamage += (Queen(S).DrawScale * DrawScaleMultiplier);

    		Queen(S).ClawDamage += StrongLevel;
        }

        if (Queen(S).StabDamage <= Queen(S).default.StabDamage)
        {
            Queen(S).StabDamage = Queen(S).default.StabDamage;

    		if ((DrawScaleMultiplier > 0) && (Queen(S).DrawScale > 1.0))
    		   Queen(S).StabDamage += (Queen(S).DrawScale * DrawScaleMultiplier);

    		Queen(S).StabDamage += StrongLevel;
        }
	}
	else if (S.IsA('Slith'))
	{
        if (Slith(S).ClawDamage <= Slith(S).default.ClawDamage)
        {
            Slith(S).ClawDamage = Slith(S).default.ClawDamage;

    		if ((DrawScaleMultiplier > 0) && (Slith(S).DrawScale > 1.0))
    		   AddVals (Slith(S).ClawDamage, Slith(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Slith(S).ClawDamage, StrongLevel);
        }
	}
	else if (S.IsA('Warlord'))
	{
        if (Warlord(S).StrikeDamage <= Warlord(S).default.StrikeDamage)
        {
            Warlord(S).StrikeDamage = Warlord(S).default.StrikeDamage;

    		if ((DrawScaleMultiplier > 0) && (Warlord(S).DrawScale > 1.0))
    		   AddVals (Warlord(S).StrikeDamage, Warlord(S).DrawScale * DrawScaleMultiplier);

    		AddVals (Warlord(S).StrikeDamage, StrongLevel);
        }
	}
    else if (S.IsA('Tentacle'))
	{
        }
    else if (S.IsA('Fly'))
	{
        }
}


function SetMonsterWeapon(ScriptedPawn S)
{
  local int big;
  big = 0;
      if (S.IsA('Queen'))
	{
      if (Queen(S).DrawScale>=2.0)
      {
       big = 1;
      }
     if (Queen(S).rangedprojectile == class'QueenProjectile')
     {
  	  if(big == 1)
      {
	   switch(rand(5))
		{
		 case 0:
			S.RangedProjectile = class'WickedProj2';
		 break;
		 case 1:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 2:
			S.RangedProjectile = class'BioGlob';
		 break;
		 case 3:
			S.RangedProjectile = class'Razor2';
		 break;
		 case 4:
			S.RangedProjectile = class'WickedProj2';
		 break;
		}


      }
      else
      {
		switch(rand(5))
		{
		 case 0:
			S.RangedProjectile = class'UT_Grenade';
		 break;
		 case 1:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 2:
			S.RangedProjectile = class'BioGlob';
		 break;
		 case 3:
			S.RangedProjectile = class'Razor2';
		 break;
		 case 4:
			S.RangedProjectile = class'UTFlakShell';
		 break;
		}
      }
     }
	}

	if (S.IsA('Brute'))
	{
     if (S.rangedprojectile == class'BruteProjectile')
     {
		switch(rand(9))
		{
		 case 0:
			S.RangedProjectile = class'BioGlob';
		 break;
		 case 1:
		 case 2:
		 case 3:
			S.RangedProjectile = class'Razor2';
		 break;
		 case 4:
			S.RangedProjectile = class'UnrealI.RazorBladeAlt';
		 break;
		 case 5:
			S.RangedProjectile = class'UT_Grenade';
		 break;
		 case 7:
		 case 8:
			S.RangedProjectile = class'RocketMk2';
		 break;
		}
     }
	}

	if (S.IsA('Gasbag'))
	{
     if (Gasbag(S).rangedprojectile == class'GasBagBelch')
     {
		 switch(rand(5))
		{
		 case 0:
			S.RangedProjectile = class'UTFlakShell';
		 break;
		 case 1:
		 case 2:
			S.RangedProjectile = class'ShockProj';
		 break;
		 case 3:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 4:
			S.RangedProjectile = class'UT_Grenade';
		 break;
		}
     }
	}


	if (S.IsA('Krall'))
	{
       if ((S.rangedprojectile == class'KraalBolt')||(S.rangedprojectile == class'EliteKrallBolt'))
        {

            switch(rand(7))
            {
             case 0:
             case 1:
             case 2:
                S.RangedProjectile = class'ShockProj';
             break;
             case 3:
             case 4:
                S.RangedProjectile = class'DAmmo4';
             break;
             case 5:
                S.RangedProjectile = class'DAmmo5';
             break;
             case 6:
            }
        }
	}

	if (S.IsA('Mercenary'))
	{
     if (Mercenary(S).rangedprojectile == class'MercRocket')
     {
		switch(rand(4))
		{
		 case 0:
		 case 1:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 2:
		 case 3:
			S.RangedProjectile = class'UT_Grenade';
		 break;
		}
     }
	}


	if (S.IsA('Skaarj'))
	{
     if (Skaarj(S).rangedprojectile == class'SkaarjProjectile')
     {
		switch(rand(6))
		{
		 case 0:
		 case 1:
			S.RangedProjectile = class'DAmmo4';
		 break;
		 case 2:
		 case 3:
			S.RangedProjectile = class'ShockProj';
		 break;
		 case 4:
		 case 5:
			S.RangedProjectile = class'RocketMk2';
		 break;
		}
     }
	}

	if (S.IsA('Tentacle'))
	{
	 if (Tentacle(S).rangedprojectile == class'TentacleProjectile')
     {
		switch(rand(6))
		{
		 case 0:
		 case 1:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 2:
		 case 3:
			S.RangedProjectile = class'BioGlob';
		 break;
		 case 4:
		 case 5:
			S.RangedProjectile = class'UT_Grenade';
		 break;
 		}
     }
	}


	if (S.IsA('Warlord'))
	{
     if (Warlord(S).rangedprojectile == class'WarlordRocket')
     {
		switch(rand(4))
		{
		 case 0:
			S.RangedProjectile = class'Razor2Alt';
		 break;
		 case 1:
			S.RangedProjectile = class'Dammo4';
		 break;
		 case 2:
			S.RangedProjectile = class'RocketMk2';
		 break;
		 case 3:
			S.RangedProjectile = class'UTFlakShell';
		 break;
		}
     }
	}

}

defaultproperties
{
    StrongLevel=5
    DrawScaleMultiplier=5
    PowerUpPercent=150.00
    maxMonsterHealth=40000.00
}
