
class Stats extends Mutator config(HittyStats);

var config string Pname[5000], TopPname[10];
var config int Frags[5000], TopFrags[10], Games[5000], TopGames[10];

var string TempPname[64];
var int	TempFrags[64];

var bool bInit, bStatsTransfered, bMatchEnded;
var int Cycle;

function AssignTopInfo(PlayerPawn Other)
{
     local IPRI PRI;

		PRI = IPRI(Other.PlayerReplicationInfo);

		PRI.Name1 = TopPname[0];
		PRI.Name2 = TopPname[1];
		PRI.Name3 = TopPname[2];
		PRI.Name4 = TopPname[3];
		PRI.Name5 = TopPname[4];
		PRI.Name6 = TopPname[5];
		PRI.Name7 = TopPname[6];
		PRI.Name8 = TopPname[7];
		PRI.Name9 = TopPname[8];
		PRI.Name10 = TopPname[9];

		PRI.Frags1 = TopFrags[0];
		PRI.Frags2 = TopFrags[1];
		PRI.Frags3 = TopFrags[2];
		PRI.Frags4 = TopFrags[3];
		PRI.Frags5 = TopFrags[4];
		PRI.Frags6 = TopFrags[5];
		PRI.Frags7 = TopFrags[6];
		PRI.Frags8 = TopFrags[7];
		PRI.Frags9 = TopFrags[8];
		PRI.Frags10 = TopFrags[9];

		PRI.G1 = TopGames[0];
		PRI.G2 = TopGames[1];
		PRI.G3 = TopGames[2];
		PRI.G4 = TopGames[3];
		PRI.G5 = TopGames[4];
		PRI.G6 = TopGames[5];
		PRI.G7 = TopGames[6];
		PRI.G8 = TopGames[7];
		PRI.G9 = TopGames[8];
		PRI.G10 = TopGames[9];

		Other.Tag = 'tagged';
}

function PostBeginPlay()
{
        local int i;

	if (bInit)
		return;
	bInit = True;

	log("Stats mutator activated");

	settimer(0.001, true);

	for ( i=0; i<64; i++ )
		{
		TempPname[i] = "";
		TempFrags[i] = 0;
		}

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}
function Timer()
{
	DataHandler();
}

function DataHandler()
{
         local IPRI PRI;
         local Pawn P;
         local int i;

	 for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			PRI = IPRI(PlayerPawn(P).PlayerReplicationInfo);
			    // Stops incomplete stats being given to default name Player
			   if ( P.PlayerReplicationInfo.PlayerName != "Player" )
			   {

			      for ( i=0; i<64; i++ )
				{
				if (TempPname[i] == PRI.PlayerName || TempPname[i] == "")
					{
					TempPname[i] = PRI.PlayerName;
					TempFrags[i] = PRI.Score;
					if ( Pname[Cycle] == PRI.PlayerName )
						{
						PRI.Games = Games[Cycle];
						if ( !bMatchEnded )
							{
							PRI.TotalFrags = Frags[Cycle] + PRI.Score;
							}
						else
							{
							PRI.TotalFrags = Frags[Cycle];
							}
						}
					if ( P.Tag != 'tagged' )
						{
						AssignTopInfo(PlayerPawn(P));
						}
					i = 65;
					}
				}
                            }    	
			}
		}
	Cycle++;
	if ( Cycle > 5000 || Pname[Cycle] == "" )
		{
		Cycle = 0;
		}
}

function StatsActivated()
{
         local IPRI PRI;
         local Pawn P;
         local int i,ii;

	 if ( !bStatsTransfered )
		{
		DataHandler();

		for ( i=0; i<64; i++ )
			{
			if (TempPname[i] != "")
				{
				for ( ii=0; ii<5000; ii++ )
					{
					if ( Pname[ii] == TempPname[i] || Pname[ii] == "")
						{
						Pname[ii] = TempPname[i];
						if (TempFrags[i] > 30000)
						TempFrags[i] = 30000;
                                                TempFrags[i] = TempFrags[i] + (Games[i] * 100);
						Frags[ii] += TempFrags[i];
						Games[ii]++;
						ii = 30000;
						}
					}
				}
			}
		bStatsTransfered = True;
		log("Stats have been transfered to the database succesfully.");
		}
}

function GetTopPlayers()
{
         local int i;

	 for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[0] )
			{
			TopPname[0] = Pname[i];
			TopFrags[0] = Frags[i];
			TopGames[0] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[1] && PName[i] != TopPname[0])
			{
			TopPname[1] = Pname[i];
			TopFrags[1] = Frags[i];
			TopGames[1] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[2] && PName[i] != TopPname[0] && PName[i] != TopPname[1])
			{
			TopPname[2] = Pname[i];
			TopFrags[2] = Frags[i];
			TopGames[2] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[3] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2])
			{
			TopPname[3] = Pname[i];
			TopFrags[3] = Frags[i];
			TopGames[3] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[4] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3])
			{
			TopPname[4] = Pname[i];
			TopFrags[4] = Frags[i];
			TopGames[4] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[5] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4])
			{
			TopPname[5] = Pname[i];
			TopFrags[5] = Frags[i];
			TopGames[5] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[6] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5])
			{
			TopPname[6] = Pname[i];
			TopFrags[6] = Frags[i];
			TopGames[6] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[7] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6])
			{
			TopPname[7] = Pname[i];
			TopFrags[7] = Frags[i];
			TopGames[7] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[8] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6] && PName[i] != TopPname[7])
			{
			TopPname[8] = Pname[i];
			TopFrags[8] = Frags[i];
			TopGames[8] = Games[i];
			}
		}

	for ( i=0;i<5000;i++ )
		{
		if ( Frags[i] > TopFrags[9] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6] && PName[i] != TopPname[7] && PName[i] != TopPname[8])
			{
			TopPname[9] = Pname[i];
			TopFrags[9] = Frags[i];
			TopGames[9] = Games[i];
			}
		}
}

function bool HandleEndGame()
{
        Super.HandleEndGame();

	StatsActivated();
	GetTopPlayers();
	bMatchEnded = True;
	SaveConfig();
	log("Initiating transferring of stats to the database.");
}

defaultproperties
{
}
