
class UMBombShell extends Projectile;

#exec AUDIO IMPORT FILE=Sounds\redeemer_flight.wav NAME="redeemer_flight" GROUP=Redeemer
#exec mesh import mesh=deemah1 anivfile=Models\deemah1_a.3d datafile=Models\deemah1_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=deemah1 x=0 y=0 z=0
#exec mesh sequence mesh=deemah1 seq=All startframe=0 numframes=1
#exec meshmap new meshmap=deemah1 mesh=deemah1
#exec meshmap scale meshmap=deemah1 x=0.08607 y=0.08607 z=0.17214
#exec TEXTURE IMPORT NAME=RDMR_Missile FILE=Textures\MissileSkin.pcx GROUP=Skins

var float CannonTimer, SmokeRate;
var redeemertrail trail;
var() class<Decal> ExplosionDecalA;

simulated function Timer()
{
    local ut_SpriteSmokePuff b;

    if ( Trail == None )
        Trail = Spawn(class'RedeemerTrail',self);

    CannonTimer += SmokeRate;
    if ( CannonTimer > 0.6 )
    {
        WarnCannons();
        CannonTimer -= 0.6;
    }

    if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
    {
        SetTimer(SmokeRate, false);
        Return;
    }

    if ( Level.bHighDetailMode )
    {
        if ( Level.bDropDetail )
            Spawn(class'LightSmokeTrail');
        else
            Spawn(class'UTSmokeTrail');
        SmokeRate = 152/Speed; 
    }
    else 
    {
        SmokeRate = 0.15;
        b = Spawn(class'ut_SpriteSmokePuff');
        b.RemoteRole = ROLE_None;
    }
    SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
    if ( Trail != None )
        Trail.Destroy();
    Super.Destroyed();
}

simulated function PostBeginPlay()
{
    SmokeRate = 0.3;
    SetTimer(0.3,false); 
}

function WarnCannons()
{
    local Pawn P;

    for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
        if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
        {
            P.target = self;
            P.GotoState('TrackWarhead');
        }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
                        vector momentum, name damageType )
{
    if ( NDamage > 5 )
    {
        PlaySound(Sound'Expl03',,6.0);
        spawn(class'SmallRedeemerExplosion',,,Location);
        HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }
}

auto state Flying
{
    simulated function ZoneChange( Zoneinfo NewZone )
    {
        local waterring w;
        
        if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
        {
            w = Spawn(class'WaterRing',,,,rot(16384,0,0));
            w.DrawScale = 0.2;
            w.RemoteRole = ROLE_None; 
        }   
    }

    function ProcessTouch (Actor Other, Vector HitLocation)
    {
        if ( Other != instigator ) 
            Explode(HitLocation,Normal(HitLocation-Other.Location));
    }

    function Explode(vector HitLocation, vector HitNormal)
    {
        if ( Role < ROLE_Authority )
            return;

        HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );                 
        spawn(class'UMShockWave',,,HitLocation+ HitNormal*16);
        RemoteRole = ROLE_SimulatedProxy;
        Destroy();
    }

    function BeginState()
    {
        local vector InitialDir;

        initialDir = vector(Rotation);
        if ( Role == ROLE_Authority )   
            Velocity = speed*initialDir;
        Acceleration = initialDir*50;
    }
}

simulated function HitWall (vector HitNormal, actor Wall)
{
    if ( Role == ROLE_Authority )
    {
        if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
            Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');

        MakeNoise(1.0);
    }
    Explode(Location + ExploWallOut * HitNormal, HitNormal);
    if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
    
    	if ( FRand() < 0.80)
		Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
	else 
                Spawn(ExplosionDecalA,self,,Location, rotator(HitNormal));
}

defaultproperties
{
    ExplosionDecalA=Class'UMBombMark'
    speed=600.00
    Damage=1000.00
    MomentumTransfer=100000
    MyDamageType=RedeemerDeath
    ExplosionDecal=Class'Botpack.NuclearMark'
    bNetTemporary=False
    RemoteRole=2
    AmbientSound=Sound'Redeemer.redeemer_flight'
    Mesh=Mesh'deemah1'
    AmbientGlow=78
    bUnlit=True
    MultiSkins=Texture'Skins.RDMR_Missile'
    SoundRadius=100
    SoundVolume=255
    CollisionRadius=14.00
    CollisionHeight=7.00
    bProjTarget=True
}
