//=============================================================================
// BloodBurst.
//=============================================================================

class IMPBOT_BloodBurst extends ut_Blood2;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	PlayAnim  ( 'Burst', 1.0 );

	if ( Level.NetMode != NM_DedicatedServer )
		SpawnCloud();
	bRandomFrame = !Level.bDropDetail;
}

simulated function SpawnCloud()
{
	local Actor A;

	if ( Level.bDropDetail || !Level.bHighDetailMode )
		return;
	A = spawn(class'ImpossibleBotJRM.IMPBOT_BigBloodPuff');
	A.RemoteRole = ROLE_None;
}

defaultproperties
{
    bOwnerNoSee=True
    AnimSequence=burst
    LODBias=2.50
    Texture=Texture'IMBBD6'
    Skin=Texture'IMBBD6'
    DrawScale=0.20
    AmbientGlow=80
    MultiSkins(0)=Texture'IMBBD10'
    MultiSkins(1)=Texture'IMBBD3'
    MultiSkins(2)=Texture'IMBBD4'
    MultiSkins(3)=Texture'IMBBD6'
    MultiSkins(4)=Texture'IMBBD9'
    MultiSkins(5)=Texture'IMBBD6'
    MultiSkins(6)=Texture'IMBBD3'
    MultiSkins(7)=Texture'IMBBD10'
    LightType=1
    LightBrightness=128
    LightHue=180
    LightRadius=6
}
