//=============================================================================
// BloodBurst.
//=============================================================================
class IMP_BloodHit extends IMPBOT_BloodBurst;

simulated function SpawnCloud()
{
	local Actor A;

	A = spawn(class'ImpossibleBotJRM.IMPBOT_BloodPuff');
	A.RemoteRole = ROLE_None;
}

Auto State StartUp
{
	simulated function Tick(float DeltaTime)
	{
		local vector WallHit, WallNormal;
		local Actor WallActor;

		if ( Level.NetMode != NM_DedicatedServer )
		{
			WallActor = Trace(WallHit, WallNormal, Location + 300 * vector(Rotation), Location, false);
			if ( WallActor != None )	
				spawn(class'ImpossibleBotJRM.IMPBOTBloodSplat',,,WallHit + 20 * (WallNormal + VRand()), rotator(WallNormal));
		}
				
		Disable('Tick');
	}
}

defaultproperties
{
    Style=3
    MultiSkins(0)=Texture'impspark2'
    MultiSkins(2)=Texture'impspark4'
    MultiSkins(4)=Texture'impspark3'
    MultiSkins(5)=Texture'impspark2'
    MultiSkins(6)=Texture'impspark4'
    MultiSkins(7)=Texture'impspark2'
}
