//=============================================================================
// CreatureChunks.
//=============================================================================
class IMbotSetCarcBlud extends CreatureChunks;

var		IMPBOT_BloodTrail		trail;

simulated function PostBeginPlay()
{
	if ( Region.Zone.bDestructive || ((Level.Game != None) && Level.Game.bLowGore) )
	{
		Destroy();
		return;
	}
	if ( bMasterChunk && (Level.NetMode == NM_Client) ) //only if client
		ClientExtraChunks(true);
	else if ( Level.NetMode == NM_Client )
		SetTimer(0.05, false);

	Super.PostBeginPlay();
}

simulated function ClientExtraChunks(bool bSpawnChunks)
{
	local CreatureChunks carc;
	local IMPBOT_BloodPuff Blood;
	local IMP_BloodSpurt b;
	local int n;

	If ( Level.NetMode == NM_DedicatedServer )
		return;

	bMustSpawnChunks = false;
	b = Spawn(class 'ImpossibleBotJRM.IMP_BloodSpurt',,,,rot(16384,0,0));
	b.RemoteRole = ROLE_None;

	if ( !bSpawnChunks || (CarcassClass == None) )
		return;

	n = 1;

	while ( (n<8) && (CarcassClass.Default.bodyparts[n] != none) )
	{
		if ( CarcassClass.Static.AllowChunk(n, CarcassAnim) )
		{
			if ( CarcLocation == vect(0,0,0) ) CarcLocation = Location; 
			carc = Spawn(class 'ImpossibleBotJRM.IMbotSetCarcBlud',,, CarcLocation 
						+ CarcassClass.Default.ZOffset[n] * CarcHeight * vect(0,0,1));
			if (carc != None)
			{
				carc.TrailSize = CarcassClass.Default.Trails[n];
				carc.Mesh = CarcassClass.Default.bodyparts[n];
				carc.Initfor(self);
				carc.RemoteRole = ROLE_None;
			}
		}
		n++;
	}

	if ( Level.bHighDetailMode && !bGreenBlood )
	{
		Blood = spawn(class'ImpossibleBotJRM.IMPBOT_BloodPuff',,, CarcLocation);
		Blood.drawscale = 0.2 * CollisionRadius;
		Blood.RemoteRole = ROLE_None;
	}
}

simulated function ZoneChange( ZoneInfo NewZone )
{
	local float splashsize;
	local actor splash;

	if ( NewZone.bWaterZone )
	{
		if ( trail != None )
		{
			if ( Level.bHighDetailMode )
				bUnlit = false;
			trail.Destroy();
		}
		if ( Mass <= Buoyancy )
			SetCollisionSize(0,0);
		if ( bSplash && !Region.Zone.bWaterZone && (Abs(Velocity.Z) < 80) )
			RotationRate *= 0.6;
		else if ( !Region.Zone.bWaterZone && (Velocity.Z < -200) )
		{
			// else play a splash
			splashSize = FClamp(0.0001 * Mass * (250 - 0.5 * FMax(-600,Velocity.Z)), 1.0, 3.0 );
			if ( NewZone.EntrySound != None )
				PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
			if ( NewZone.EntryActor != None )
			{
				splash = Spawn(NewZone.EntryActor); 
				if ( splash != None )
					splash.DrawScale = splashSize;
			}
		}
		bSplash = true;
	}

	if ( NewZone.bDestructive || (NewZone.bPainZone  && (NewZone.DamagePerSec > 0)) )
		Destroy();
}
	

function Initfor(actor Other)
{
	local vector RandDir;

	if ( Other.IsA('Carcass') )
		PlayerOwner = Carcass(Other).PlayerOwner;
	bDecorative = false;
	DrawScale = Other.DrawScale;
	if ( DrawScale != 1.0 )
		SetCollisionSize(CollisionRadius * 0.5 * (1 + DrawScale), CollisionHeight * 0.5 * (1 + DrawScale));
	RotationRate.Yaw = Rand(200000) - 100000;
	RotationRate.Pitch = Rand(200000 - Abs(RotationRate.Yaw)) - 0.5 * (200000 - Abs(RotationRate.Yaw));
	RandDir = 700 * FRand() * VRand();
	RandDir.Z = 200 * FRand() - 50;
	if ( bMasterChunk )
		SetAsMaster(Other);
	else
	{
		Velocity = (0.2 + FRand()) * (other.Velocity + RandDir);
		If (Region.Zone.bWaterZone)
			Velocity *= 0.5;
	}
	if ( TrailSize > 0 )
	{
		if ( CreatureCarcass(Other) != None )
			bGreenBlood = CreatureCarcass(Other).bGreenBlood;
		else if ( (CreatureChunks(Other) != None) )
			bGreenBlood = CreatureChunks(Other).bGreenBlood;
	}
			
	if ( FRand() < 0.3 )
		Buoyancy = 1.06 * Mass; // float corpse
	else
		Buoyancy = 0.94 * Mass;

	if ( bMasterChunk ) // only if server
		ClientExtraChunks(bMustSpawnChunks);
}



function ChunkUp(int Damage)
{
	local IMP_BloodSpurt b;

	if (bHidden)
		return;
	b = Spawn(class 'ImpossibleBotJRM.IMP_BloodSpurt',,,,rot(16384,0,0));
	if (bPlayerCarcass)
	{
		bHidden = true;
		SetPhysics(PHYS_None);
		SetCollision(false,false,false);
		bProjTarget = false;
		if ( Trail != None )
			Trail.Destroy();
	}
	else
		destroy();
}

simulated function Landed(vector HitNormal)
{
	local rotator finalRot;
	local IMP_BloodSpurt b;

	if ( trail != None )
	{
		if ( Level.bHighDetailMode )
			bUnlit = false;
		trail.Destroy();
		trail = None;
	}
	finalRot = Rotation;
	finalRot.Roll = 0;
	finalRot.Pitch = 0;
	setRotation(finalRot);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		b = Spawn(class 'ImpossibleBotJRM.IMP_BloodSpurt',,,,rot(16384,0,0));
		b.RemoteRole = ROLE_None;
	}
	SetPhysics(PHYS_None);
	SetCollision(true, false, false);
}

simulated function HitWall(vector HitNormal, actor Wall)
{
	local float speed, decision;
	local IMP_BloodSpurt b;

	Velocity = 0.8 * (Velocity - 2 * HitNormal * (Velocity Dot HitNormal));
	Velocity.Z = FMin(Velocity.Z * 0.8, 700);
	speed = VSize(Velocity);
	if ( speed < 250 )
	{
		if ( trail != None )
		{
			if ( Level.bHighDetailMode )
				bUnlit = false;
			trail.Destroy();
			trail = None;
		}
		if ( speed < 120 )
		{
			bBounce = false;
			Disable('HitWall');
		}
	}
	else if ( speed > 350 )
	{
		if ( speed > 700 )
			velocity *= 0.8;
		if (  Level.NetMode != NM_DedicatedServer )
		{
			decision = FRand();
			if ( decision < 0.2 )
				PlaySound(sound 'ImpossibleBotJRMSounds.IMPJgibhit01');
			else if ( decision < 0.4 )
				PlaySound(sound 'ImpossibleBotJRMSounds.IMPJgibhit02');
			else if ( decision < 0.6 )
				PlaySound(sound 'ImpossibleBotJRMSounds.IMPJgibhit03');
			else if ( decision < 0.8 )
				PlaySound(sound 'ImpossibleBotJRMSounds.IMPJgibhit04');
			else 
				PlaySound(sound 'ImpossibleBotJRMSounds.IMPJgibhit02');
		}
	}
	if ( (trail == None) && (Level.NetMode != NM_DedicatedServer) )
	{
		b = Spawn(class 'ImpossibleBotJRM.IMP_BloodSpurt',,,,Rotator(HitNormal));
		if ( bGreenBlood )
			b.GreenBlood();		
		b.RemoteRole = ROLE_None;
	}
}

			

auto state Dying
{
	ignores TakeDamage;

Begin:
	if ( bDecorative )
		SetPhysics(PHYS_None);
	else if ( (TrailSize > 0) && !Region.Zone.bWaterZone )
	{
		trail = Spawn(class'ImpossibleBotJRM.IMPBOT_BloodTrail',self);
//		trail.DrawScale = TrailSize;
	}
	Sleep(0.35);
	SetCollision(true, false, false);
	bMasterChunk = false;
	GotoState('Dead');
}	

defaultproperties
{
    LODBias=9.50
    Texture=Texture'Skins.IMPJgibskin'
    Skin=Texture'Skins.IMPJgibskin'
    Mesh=LodMesh'impbotchunk1'
}
