//=============================================================================
// TBossMasterChunk
//=============================================================================
class ImpBotMasterChunk extends UTMasterCreatureChunk;

var		IMPBOT_BloodTrail	trail;

function ChunkUp(int Damage)
{
	local IMPBOT_BloodBurst b;

	if (bHidden)
		return;
	b = Spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',,,,rot(16384,0,0));

	if (bPlayerCarcass)
	{
		bHidden = true;
		SetPhysics(PHYS_None);
		SetCollision(false,false,false);
		bProjTarget = false;
		if ( Trail != None )
			Trail.Destroy();
	}
	else
		destroy();
}

simulated function Landed(vector HitNormal)
{
	local rotator finalRot;
	local IMPBOT_BloodBurst b,gnargh;
	local actor a;

	if ( trail != None )
	{
		if ( Level.bHighDetailMode && !Level.bDropDetail )
			bUnlit = false;
		trail.Destroy();
		trail = None;
	}
	finalRot = Rotation;
	finalRot.Roll = 0;
	finalRot.Pitch = 0;
	PlaySound(HitSounds[Rand(4)],,12);
	setRotation(finalRot);
	if ( (Level.NetMode != NM_DedicatedServer) && !Level.bDropDetail )
	{
		b = Spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',,,,rot(0,0,0));
		b.RemoteRole = ROLE_None;
		gnargh = Spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',,,,rot(0,0,0));
		gnargh.RemoteRole = ROLE_None;
		gnargh.DrawScale = gnargh.DrawScale*3;
		Spawn(class'ImpossibleBotJRM.IMPBOTBloodSplat',,,Location,rotator(HitNormal));
	}
	SetPhysics(PHYS_None);
	SetCollision(true, false, false);
}

simulated function HitWall(vector HitNormal, actor Wall)
{
	local float speed, decision;
	local IMPBOT_BloodBurst b;
	local actor a;

	Velocity = 0.8 * (Velocity - 2 * HitNormal * (Velocity Dot HitNormal));
	Velocity.Z = FMin(Velocity.Z * 0.8, 700);
	speed = VSize(Velocity);
	if ( speed < 350 )
	{
		if ( trail != None )
		{
			if ( Level.bHighDetailMode && !Level.bDropDetail )
				bUnlit = false;
			trail.Destroy();
			trail = None;
		}
		if ( speed < 120 )
		{
			bBounce = false;
			Disable('HitWall');
		}
	}
	else if ( speed > 150 )
	{
		if ( speed > 700 )
			velocity *= 0.8;
		if (  (Level.NetMode != NM_DedicatedServer) && Level.bHighDetailMode && !Level.bDropDetail
			&& (LifeSpan < 19.3) )
			PlaySound(HitSounds[Rand(4)],,12);
	}
	if ( (Level.NetMode != NM_DedicatedServer) )
	{
		if ( (trail == None) && !Level.bDropDetail )
		{ 
			b = Spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',,,,Rot(0,0,0));
			b.RemoteRole = ROLE_None;
		}
		if ( !bGreenBlood && (!Level.bDropDetail || (FRand() < 0.65)) )
			Spawn(class'ImpossibleBotJRM.IMPBOTBloodSplat',,,Location,rotator(HitNormal));
	}
}
simulated function ClientExtraChunks()
{
	local carcass carc,lumpy;
	local JRMbolta FlyingBoltOfDooma,FlyingBoltOfDoomb,FlyingBoltOfDoomc;
	local IMPBOT_BloodBurst b;
	local PlayerPawn P;

	If ( Level.NetMode == NM_DedicatedServer )
		return;
	if ( class'GameInfo'.Default.bLowGore )
	{
		Destroy();
		return;
	}

	b = Spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst');
	if ( bGreenBlood )
		b.GreenBlood();
	b.RemoteRole = ROLE_None;

	if ( (CarcassAnim != 'Dead4') && (CarcassAnim != 'Dead5') )
	{
		carc = Spawn(class'impbotchunk2');
		if ( carc != None )
			carc.Initfor(self);
	}

	if ( CarcassAnim != 'Dead5' )
	{
		if ( Level.bHighDetailMode && !Level.bDropDetail )
		{
			if ( FRand() < 0.3 )
			{
				carc = Spawn(class 'ImpossibleBotJRM.impbotchunk1');
				if (carc != None)
					carc.Initfor(self);
			}
			else if ( FRand() < 0.5 )
			{
				carc = Spawn(class 'ImpossibleBotJRM.impbotchunk2');
				if (carc != None)
					carc.Initfor(self);
			}
			else
			{
				carc = Spawn(class 'ImpossibleBotJRM.impbotchunk4');
				if (carc != None)
					carc.Initfor(self);
				lumpy = Spawn(class 'ImpossibleBotJRM.impbotchunk10');
				lumpy.DrawScale=5.000000;
				if (lumpy != None)
					lumpy.Initfor(self);
			}
			if ( FRand() < 0.5 )
			{
				carc = Spawn(class 'ImpossibleBotJRM.impbotchunk6');
				if (carc != None)
					carc.Initfor(self);
				lumpy = Spawn(class 'ImpossibleBotJRM.impbotchunk10');
				lumpy.DrawScale=5.000000;
				if (lumpy != None)
					lumpy.Initfor(self);
			}
		FlyingBoltOfDooma = Spawn(class 'ImpossibleBotJRM.JRMbolta');
		FlyingBoltOfDooma.Velocity.X =Frand()*128;
		FlyingBoltOfDooma.Velocity.Y =Frand()*128;
		FlyingBoltOfDooma.Velocity.Z =Frand()*128;
		FlyingBoltOfDooma.LodBias =8.000000;
		FlyingBoltOfDoomb = Spawn(class 'ImpossibleBotJRM.JRMbolta');
		FlyingBoltOfDoomb.Velocity.X =Frand()*128;
		FlyingBoltOfDoomb.Velocity.Y =Frand()*128;
		FlyingBoltOfDoomb.Velocity.Z =Frand()*128;
		FlyingBoltOfDoomb.LodBias =8.000000;
		FlyingBoltOfDoomc = Spawn(class 'ImpossibleBotJRM.JRMbolta');
		FlyingBoltOfDoomc.Velocity.X =Frand()*192;
		FlyingBoltOfDoomc.Velocity.Y =Frand()*192;
		FlyingBoltOfDoomc.Velocity.Z =Frand()*192;
		FlyingBoltOfDoomc.LodBias =8.000000;
		}
		carc = Spawn(class 'ImpossibleBotJRM.impbotchunk5');
		if (carc != None)
			carc.Initfor(self);
		carc = Spawn(class 'ImpossibleBotJRM.impbotchunk8');
		if (carc != None)
			carc.Initfor(self);
	}
	if ( !Level.bDropDetail )
	{
		carc = Spawn(class 'ImpossibleBotJRM.impbotchunk6');
		if (carc != None)
			carc.Initfor(self);
	}
	carc = Spawn(class 'ImpossibleBotJRM.impbotchunk7');
	if (carc != None)
		carc.Initfor(self);
}

auto state Dying
{
	ignores TakeDamage;

Begin:
	if ( bDecorative )
		SetPhysics(PHYS_None);
	else if ( (TrailSize > 0) && !Region.Zone.bWaterZone && (Level.NetMode != NM_DedicatedServer) )
	{
		trail = Spawn(class'ImpossibleBotJRM.IMPBOT_BloodTrail',self);
	}
	Sleep(0.35);
	SetCollision(true, false, false);
	GotoState('Dead');
}	


defaultproperties
{
    HitSounds(0)=Sound'ImpossibleBotJRMSounds.(All).IMPJgibhit01'
    HitSounds(1)=Sound'ImpossibleBotJRMSounds.(All).IMPJgibhit02'
    HitSounds(2)=Sound'ImpossibleBotJRMSounds.(All).IMPJgibhit03'
    HitSounds(3)=Sound'ImpossibleBotJRMSounds.(All).IMPJgibhit04'
    Texture=Texture'Skins.IMPJgibskin'
    Skin=Texture'Skins.IMPJgibskin'
    Mesh=LodMesh'impbotchunk3'
    DrawScale=2.00
}
