//=============================================================================
// ImpossibleBotJRM.
//=============================================================================
class ImpossibleBotJRM extends GenericMale;

#exec OBJ LOAD FILE=..\Sounds\ImpossibleBotJRMSounds.uax PACKAGE=ImpossibleBotJRMSounds

#exec TEXTURE IMPORT NAME=ImpossibleBotJRMDoll FILE=TEXTURES\ImpossibleBotJRMDoll.bmp GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=ImpossibleBotJRMBelt FILE=TEXTURES\ImpossibleBotJRMBelt.bmp GROUP="Icons" MIPS=OFF

#exec MESH MODELIMPORT MESH=ImpossibleBotJRM MODELFILE=models\ImpossibleBotJRM.PSK LODSTYLE=12
#exec MESH ORIGIN MESH=ImpossibleBotJRM X=0 Y=0 Z=135 YAW=192

#exec MESH WEAPONATTACH MESH=ImpossibleBotJRM BONE="Bip01 R Hand"
#exec MESH WEAPONPOSITION MESH=ImpossibleBotJRM YAW=0 PITCH=0 ROLL=128 X=1.0 Y=0.0 Z=0.0

#exec MESHMAP SCALE MESHMAP=ImpossibleBotJRM X=0.3125 Y=0.3125 Z=0.3125
#exec MESH DEFAULTANIM MESH=ImpossibleBotJRM ANIM=EpicUTPS2MaleAnimation

//#exec TEXTURE IMPORT NAME=ImpossibleBotJRMDoll FILE=TEXTURES\ImpossibleBotJRMSDoll.PCX GROUP="Icons" MIPS=OFF
//#exec TEXTURE IMPORT NAME=ImpossibleBotJRMBelt FILE=TEXTURES\ImpossibleBotJRMSBelt.PCX GROUP="Icons" MIPS=OFF



// **** MAke more sparks when flipping! ***


function PlayFlip()
{
	local Vector VentVectorPos;
	PlayAnim('Flip', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);

     VentVectorPos = Self.Location;
     VentVectorPos.Z=Self.Location.Z-60;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
     VentVectorPos.Z=Self.Location.Z-50;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
}

// Should make purple blood FOR DEATHHIT!***************************************

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local float rnd;
	local Bubble1 bub;
	local bool bServerGuessWeapon;
	local class<DamageType> DamageClass;
	local vector BloodOffset, Mo;
	local int iDam;

	if ( (Damage <= 0) && (ReducedDamageType != 'All') )
		return;

	//DamageClass = class(damageType);
	if ( ReducedDamageType != 'All' ) //spawn some blood
	{
		if (damageType == 'Drowned')
		{
			bub = spawn(class 'Bubble1',,, Location 
				+ 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
			if (bub != None)
				bub.DrawScale = FRand()*0.06+0.04; 
		}
		else if ( (damageType != 'Burned') && (damageType != 'Corroded') 
					&& (damageType != 'Fell') )
		{
			BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
			BloodOffset.Z = BloodOffset.Z * 0.5;
			if ( (DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded') )
			{
				Mo = Momentum;
				if ( Mo.Z > 0 )
					Mo.Z *= 0.5;
				spawn(class 'ImpossibleBotJRM.IMP_BloodHit',self,,hitLocation + BloodOffset, rotator(Mo));
			}
			else
				spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',self,,hitLocation + BloodOffset);
		}
	}	

	rnd = FClamp(Damage, 20, 60);
	if ( damageType == 'Burned' )
		ClientFlash( -0.009375 * rnd, rnd * vect(16.41, 11.719, 4.6875));
	else if ( damageType == 'Corroded' )
		ClientFlash( -0.01171875 * rnd, rnd * vect(9.375, 14.0625, 4.6875));
	else if ( damageType == 'Drowned' )
		ClientFlash(-0.390, vect(312.5,468.75,468.75));
	else 
		ClientFlash( -0.019 * rnd, rnd * vect(26.5, 4.5, 4.5));

	ShakeView(0.15 + 0.005 * Damage, Damage * 30, 0.3 * Damage); 
	PlayTakeHitSound(Damage, damageType, 1);
	bServerGuessWeapon = ( ((Weapon != None) && Weapon.bPointing) || (GetAnimGroup(AnimSequence) == 'Dodge') );
	iDam = Clamp(Damage,0,200);
	ClientPlayTakeHit(hitLocation - Location, iDam, bServerGuessWeapon ); 
	if ( !bServerGuessWeapon 
		&& ((Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer)) )
	{
		Enable('AnimEnd');
		BaseEyeHeight = Default.BaseEyeHeight;
		bAnimTransition = true;
		PlayTakeHit(0.1, hitLocation, Damage);
	}
}

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local Bubble1 bub;
	local vector Mo;

	if ( Region.Zone.bDestructive && (Region.Zone.ExitActor != None) )
		Spawn(Region.Zone.ExitActor);
	if (HeadRegion.Zone.bWaterZone)
	{
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * vector(Rotation) + 0.8 * EyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.2 * CollisionRadius * VRand() + 0.7 * EyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * VRand() + 0.6 * EyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
	}

	if ( (!Level.bDropDetail || (FRand() < 0.67))
			&& ((DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded')) )
	{
		Mo = Momentum;
		if ( Mo.Z > 0 )
			Mo.Z *= 0.5;
		spawn(class 'ImpossibleBotJRM.IMP_BloodHit',self,,hitLocation, rotator(Mo));
	}
	else if ( (damageType != 'Drowned') && (damageType != 'Corroded') )
		spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',self,'', hitLocation);
}




function PlayDying(name DamageType, vector HitLoc)
{
	BaseEyeHeight = Default.BaseEyeHeight;
	PlayDyingSound();
			
	if ( DamageType == 'Suicided' )
	{
		PlayAnim('Dead8',, 0.1);
		return;
	}

	// check for head hit
	if ( (DamageType == 'Decapitated') && !class'GameInfo'.Default.bLowGore )
	{
		PlayDecap();
		return;
	}

	if ( FRand() < 0.15 )
	{
		PlayAnim('Dead2',,0.1);
		return;
	}

	// check for big hit
	if ( (Velocity.Z > 250) && (FRand() < 0.75) )
	{
		if ( FRand() < 0.5 )
			PlayAnim('Dead1',,0.1);
		else
			PlayAnim('Dead11',, 0.1);
		return;
	}

	// check for repeater death
	if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
	{
		PlayAnim('Dead9',, 0.1);
		return;
	}
		
	if ( (HitLoc.Z - Location.Z > 0.7 * CollisionHeight) && !class'GameInfo'.Default.bLowGore )
	{
		if ( FRand() < 0.5 )
			PlayDecap();
		else
			PlayAnim('Dead7',, 0.1);
		return;
	}
	
	if ( Region.Zone.bWaterZone || (FRand() < 0.5) ) //then hit in front or back
		PlayAnim('Dead3',, 0.1);
	else
		PlayAnim('Dead8',, 0.1);
}


// ********************************************** FOOT SOUNDS ******

simulated function PlayFootStep()
{
	local sound step;
	local float decision;
	local Vector VentVectorPos;
     VentVectorPos = Self.Location;
     VentVectorPos.Z=Self.Location.Z-30;

	if ( FootRegion.Zone.bWaterZone )
	{
		PlaySound(sound 'LSplash', SLOT_Interact, 1, false, 1500.0, 1.0);
		return;
	}

	decision = FRand();
	if ( decision < 0.34 )
	{
		step = Footstep1;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}
    If (decision < 0.67 )
	{
		step = Footstep2;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}
   If ( decision > 0.66 || decision > 0.35 )
	{
		step = Footstep3;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}

	PlaySound(step, SLOT_Interact, 2.2, false, 1000.0, 1.0);
 }


//**********************************************

defaultproperties
{
    SkinInfo=Class'ImpossibleBotJRMSkinInfo'
    Deaths(0)=Sound'ImpossibleBotJRMSounds.(All).Die1'
    Deaths(1)=Sound'ImpossibleBotJRMSounds.(All).Die2'
    Deaths(2)=Sound'ImpossibleBotJRMSounds.(All).Die3'
    Deaths(3)=Sound'ImpossibleBotJRMSounds.(All).Die4'
    Deaths(4)=Sound'ImpossibleBotJRMSounds.(All).die5'
    Deaths(5)=Sound'ImpossibleBotJRMSounds.(All).die6'
    DefaultSkinName="ImpossibleBotJRMSkins.cuwo"
    DefaultPackage="ImpossibleBotJRMSkins."
    drown=Sound'ImpossibleBotJRMSounds.(All).ro_drown'
    breathagain=Sound'ImpossibleBotJRMSounds.(All).ro_gasp01'
    Footstep1=Sound'ImpossibleBotJRMSounds.(All).footfall01'
    Footstep2=Sound'ImpossibleBotJRMSounds.(All).footfall02'
    Footstep3=Sound'ImpossibleBotJRMSounds.(All).footfall03'
    HitSound3=Sound'ImpossibleBotJRMSounds.(All).hit03'
    HitSound4=Sound'ImpossibleBotJRMSounds.(All).hit05'
    UWHit1=Sound'ImpossibleBotJRMSounds.(All).uvhit'
    UWHit2=Sound'ImpossibleBotJRMSounds.(All).uvhit2'
    LandGrunt=Sound'ImpossibleBotJRMSounds.(All).uvhit2'
    StatusDoll=Texture'Icons.ImpossibleBotJRMDoll'
    StatusBelt=Texture'Icons.ImpossibleBotJRMBelt'
    CarcassType=Class'IMPBotJRMCarcass'
    JumpSound=Sound'ImpossibleBotJRMSounds.(All).hit05'
    SelectionMesh="ImpossibleBotJRM.ImpossibleBotJRM"
    HitSound1=Sound'ImpossibleBotJRMSounds.(All).hit01'
    HitSound2=Sound'ImpossibleBotJRMSounds.(All).hit02'
    Land=Sound'ImpossibleBotJRMSounds.(All).hit04'
    Die=Sound'ImpossibleBotJRMSounds.(All).die7'
    WaterStep=Sound'ImpossibleBotJRMSounds.(All).WaterStep'
    MenuName="ImpossibleBotJRM"
    VoiceType="IMBPBOTJRMVoices.IMBPBOTJRMVoices"
    AmbientSound=Sound'ImpossibleBotJRMSounds.(All).whumphamb'
    Mesh=SkeletalMesh'ImpossibleBotJRM'
    ScaleGlow=6.00
}
