//=============================================================================
// ImpossibleBotJRM Bot.
//=============================================================================
class ImpossibleBotJRMBot extends GenericMaleBot;

#exec OBJ LOAD FILE=..\Sounds\ImpossibleBotJRMSounds.uax PACKAGE=ImpossibleBotJRMSounds

#exec MESH DEFAULTANIM MESH=ImpossibleBotJRM ANIM=EpicUTPS2MaleAnimation

//**********************************************************************

//**********************************************************************

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local float rnd;
	local Bubble1 bub;
	local bool bOptionalTakeHit;
	local vector BloodOffset, Mo;

	if (Damage > 1) //spawn some blood
	{
		if (damageType == 'Drowned')
		{
			bub = spawn(class 'Bubble1',,, Location 
				+ 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * BaseEyeHeight * vect(0,0,1));
			if (bub != None)
				bub.DrawScale = FRand()*0.06+0.04; 
		}
		else if ( damageType != 'Corroded' )
		{
			BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
			BloodOffset.Z = BloodOffset.Z * 0.5;
			if ( bGreenBlood )
				spawn(class 'UT_GreenBloodPuff',self,,hitLocation + BloodOffset, rotator(BloodOffset));
			else if ( (!Level.bDropDetail || (FRand() < 0.67))
				&& ((DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded')) )
			{
				Mo = Momentum;
				if ( Mo.Z > 0 )
					Mo.Z *= 0.5;
				spawn(class 'ImpossibleBotJRM.IMP_BloodHit',self,,hitLocation + BloodOffset, rotator(Mo));
			}
			else
				spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',self,,hitLocation + BloodOffset);
		}
	}	

	bFireFalling = false;
	bOptionalTakeHit = ( (Level.TimeSeconds - LastPainTime > 0.3 + 0.25 * skill)
						&& (Damage * FRand() > 0.08 * Health) && (bNovice || (Skill < 2))
						&& (GetAnimGroup(AnimSequence) != 'MovingAttack') 
						&& (GetAnimGroup(AnimSequence) != 'Attack') ); 

	PlayTakeHitSound(Damage, damageType, 2);
	if ( ((Weapon == None) || !Weapon.bPointing)
		 && (GetAnimGroup(AnimSequence) != 'Dodge') 
		&& (bOptionalTakeHit || (Momentum.Z > 140) 
			 || (Damage * FRand() > (0.17 + 0.04 * skill) * Health)) ) 
	{
		PlayHitAnim(HitLocation, Damage);
		if ( (Enemy != None) && !bNovice && (FRand() * Skill > 0.5) )
		{
			NextState = 'FallingState';
			NextLabel = 'FireWhileFalling';
		}
	}
	else if ( (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z)
				&& (Momentum.Z/Region.Zone.ZoneGravity.Z < -0.5) )
		bFireFalling = true;
	else if (NextState == 'TakeHit')
		NextState = '';
}


// DEATH ************************************

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local Bubble1 bub;
	local IMPBOT_BloodBurst b;
	local vector Mo;

	if ( Region.Zone.bDestructive && (Region.Zone.ExitActor != None) )
		Spawn(Region.Zone.ExitActor);
	if (HeadRegion.Zone.bWaterZone)
	{
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * vector(Rotation) + 0.8 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.2 * CollisionRadius * VRand() + 0.7 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * VRand() + 0.6 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
	}
	if ( (DamageType == 'shot') || (DamageType == 'decapitated') )
	{
		Mo = Momentum;
		if ( Mo.Z > 0 )
			Mo.Z *= 0.5;
		spawn(class 'ImpossibleBotJRM.IMP_BloodHit',self,,hitLocation, rotator(Mo));
	}
	else if ( (damageType != 'Burned') && (damageType != 'Corroded') 
		 && (damageType != 'Drowned') && (damageType != 'Fell') )
	{
		b = spawn(class 'ImpossibleBotJRM.IMPBOT_BloodBurst',self,'', hitLocation);

	}
}

function PlayDying(name DamageType, vector HitLoc)
{
	BaseEyeHeight = Default.BaseEyeHeight;
	PlayDyingSound();
			
	if ( DamageType == 'Suicided' )
	{
		PlayAnim('Dead7',, 0.1);
		return;
	}

	// check for head hit
	if ( (DamageType == 'Decapitated') && !Level.Game.bVeryLowGore )
	{
		PlayDecap();
		return;
	}

	if ( FRand() < 0.15 )
	{
		PlayAnim('Dead2',,0.1);
		return;
	}

	// check for big hit
	if ( (Velocity.Z > 250) && (FRand() < 0.75) )
	{
		if ( FRand() < 0.5 )
			PlayAnim('Dead1',,0.1);
		else
			PlayAnim('Dead11',, 0.1);
		return;
	}

	// check for repeater death
	if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
	{
		LoopAnim('Dead9',, 0.1);
		return;
	}
		
	if ( (HitLoc.Z - Location.Z > 0.7 * CollisionHeight) && !Level.Game.bVeryLowGore )
	{
		if ( FRand() <= 0.5 )
			PlayDecap();
		else
			PlayAnim('Dead7',, 0.1);
		return;
	}
	
	if ( Region.Zone.bWaterZone || (FRand() < 0.5) ) //then hit in front or back
		PlayAnim('Dead3',, 0.1);
	else
		PlayAnim('Dead8',, 0.1);
}
// ********************************************** FOOT SOUNDS ******

simulated function PlayFootStep()
{
	local sound step;
	local float decision;
	local Vector VentVectorPos;
     VentVectorPos = Self.Location;
     VentVectorPos.Z=Self.Location.Z-30;

	if ( FootRegion.Zone.bWaterZone )
	{
		PlaySound(sound 'LSplash', SLOT_Interact, 1, false, 1500.0, 1.0);
		return;
	}

	decision = FRand();
	if ( decision < 0.34 )
	{
		step = Footstep1;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}
    If (decision < 0.67 )
	{
		step = Footstep2;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}
   If ( decision > 0.66 || decision > 0.35 )
	{
		step = Footstep3;
 		Spawn(class'ImpossibleBotJRM.IMPflySparkJ',,,VentVectorPos);
	}

	PlaySound(step, SLOT_Interact, 2.2, false, 1000.0, 1.0);
}


//**********************************************

defaultproperties
{
    MatchingPlayerClass=Class'ImpossibleBotJRM'
    CarcassType=Class'IMPBotJRMCarcass'
    drown=Sound'ImpossibleBotJRMSounds.(All).ro_drown'
    breathagain=Sound'ImpossibleBotJRMSounds.(All).ro_gasp01'
    Footstep1=Sound'ImpossibleBotJRMSounds.(All).footfall01'
    Footstep2=Sound'ImpossibleBotJRMSounds.(All).footfall02'
    Footstep3=Sound'ImpossibleBotJRMSounds.(All).footfall03'
    HitSound3=Sound'ImpossibleBotJRMSounds.(All).hit03'
    HitSound4=Sound'ImpossibleBotJRMSounds.(All).hit05'
    Deaths(0)=Sound'ImpossibleBotJRMSounds.(All).Die1'
    Deaths(1)=Sound'ImpossibleBotJRMSounds.(All).Die2'
    Deaths(2)=Sound'ImpossibleBotJRMSounds.(All).Die3'
    Deaths(3)=Sound'ImpossibleBotJRMSounds.(All).Die4'
    Deaths(4)=Sound'ImpossibleBotJRMSounds.(All).die5'
    Deaths(5)=Sound'ImpossibleBotJRMSounds.(All).die6'
    UWHit1=Sound'ImpossibleBotJRMSounds.(All).uvhit'
    UWHit2=Sound'ImpossibleBotJRMSounds.(All).uvhit2'
    LandGrunt=Sound'ImpossibleBotJRMSounds.(All).uvhit2'
    JumpSound=Sound'ImpossibleBotJRMSounds.(All).hit05'
    StatusDoll=Texture'Icons.ImpossibleBotJRMDoll'
    StatusBelt=Texture'Icons.ImpossibleBotJRMBelt'
    SelectionMesh="ImpossibleBotJRM.ImpossibleBotJRM"
    HitSound1=Sound'ImpossibleBotJRMSounds.(All).hit01'
    HitSound2=Sound'ImpossibleBotJRMSounds.(All).hit02'
    Land=Sound'ImpossibleBotJRMSounds.(All).hit04'
    Die=Sound'ImpossibleBotJRMSounds.(All).die7'
    WaterStep=Sound'ImpossibleBotJRMSounds.(All).WaterStep'
    MenuName="ImpossibleBotJRM"
    VoiceType="IMBPBOTJRMVoices.IMBPBOTJRMVoices"
    AmbientSound=Sound'ImpossibleBotJRMSounds.(All).whumphamb'
    Mesh=SkeletalMesh'ImpossibleBotJRM'
}
