
Class NutPounder Expands KFMonster;

#exec MESH MODELIMPORT MESH=NutPound MODELFILE=Models\NutPound.psk
#exec MESH LODPARAMS MESH=NutPound HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=NutPound X=0 Y=0 Z=70 YAW=-64 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=FleshPound_anim ANIMFILE=Models\FleshPound_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=NutPound X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PistolWhip  STARTFRAME=450 	NUMFRAMES=81 	RATE=81
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Punch  		STARTFRAME=531 	NUMFRAMES=81 	RATE=81
//add this to melee
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Punch1 		STARTFRAME=612 	NUMFRAMES=51 	RATE=51

#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Jump2  		STARTFRAME=398 	NUMFRAMES=45 	RATE=45
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Walk   		STARTFRAME=1203 	NUMFRAMES=300 	RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkFire  	STARTFRAME=3643 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Dead1  		STARTFRAME=4123 	NUMFRAMES=101 	RATE=101
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Hit  			STARTFRAME=167 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=GutHit  		STARTFRAME=208 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=LeftHit  	STARTFRAME=208 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=RightHit  	STARTFRAME=249 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Breath2  	STARTFRAME=36 		NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Charge  		STARTFRAME=3643 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=CockGun  	STARTFRAME=972 	NUMFRAMES=71 	RATE=71
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Fighter  	STARTFRAME=4123 	NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=GutShot  	STARTFRAME=4123 	NUMFRAMES=101 	RATE=101
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HeadHit  	STARTFRAME=167 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=StillLook  	STARTFRAME=2103 	NUMFRAMES=20 	RATE=20
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Precharg  	STARTFRAME=290 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Sleep   		STARTFRAME=663 	NUMFRAMES=309 	RATE=309
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=StillFire  	STARTFRAME=36 		NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=T8  			STARTFRAME=972		NUMFRAMES=71 	RATE=71

/*
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=DodgeB STARTFRAME=0 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=DodgeF STARTFRAME=9 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=DodgeL STARTFRAME=18 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=DodgeR STARTFRAME=27 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=DoorBash STARTFRAME=36 NUMFRAMES=80 RATE=80
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=FPRageAttack STARTFRAME=116 NUMFRAMES=51 RATE=51
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitF STARTFRAME=167 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitF2 STARTFRAME=208 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitF3 STARTFRAME=249 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitReactionB STARTFRAME=290 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitReactionF STARTFRAME=311 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitReactionL STARTFRAME=332 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=HitReactionR STARTFRAME=353 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=InAir STARTFRAME=374 NUMFRAMES=10 RATE=10
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Jump STARTFRAME=384 NUMFRAMES=14 RATE=14
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Jump2 STARTFRAME=398 NUMFRAMES=45 RATE=45
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=Landed STARTFRAME=443 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundAttack1 STARTFRAME=450 NUMFRAMES=81 RATE=81
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundAttack2 STARTFRAME=531 NUMFRAMES=81 RATE=81
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundAttack3 STARTFRAME=612 NUMFRAMES=51 RATE=51
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundIdle STARTFRAME=663 NUMFRAMES=309 RATE=309
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundRage STARTFRAME=972 NUMFRAMES=71 RATE=71
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundRun STARTFRAME=1043 NUMFRAMES=160 RATE=160
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=PoundWalk STARTFRAME=1203 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=RunL STARTFRAME=1503 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=RunR STARTFRAME=1803 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=TurnLeft STARTFRAME=2103 NUMFRAMES=20 RATE=20
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=TurnRight STARTFRAME=2123 NUMFRAMES=20 RATE=20
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkB STARTFRAME=2143 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkB_Headless STARTFRAME=2443 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkF_Headless STARTFRAME=2743 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkL_Headless STARTFRAME=3043 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkR_Headless STARTFRAME=3343 NUMFRAMES=300 RATE=300
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkF_Fire STARTFRAME=3643 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkB_Fire STARTFRAME=3763 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkL_Fire STARTFRAME=3883 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=WalkR_Fire STARTFRAME=4003 NUMFRAMES=120 RATE=120
#exec ANIM SEQUENCE ANIM=FleshPound_anim SEQ=KnockDown STARTFRAME=4123 NUMFRAMES=101 RATE=101
*/

#exec ANIM DIGEST ANIM=FleshPound_anim
#exec MESH DEFAULTANIM MESH=NutPound ANIM=FleshPound_anim

//Adds
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Punch1 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=FleshPound_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=NutRoar

var(Sounds) sound Drill;
var(Sounds) sound NutRoar1;
var(Sounds) sound NutRoar2;

function NutRoar()
{
   if (FRand() < 0.5)
      PlaySound(NutRoar1, SLOT_Interact);
   else
      PlaySound(NutRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.25,,0.4);
      return;
   }

   LoopAnim('Walk', 0.25,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayMeleeAttack()
{
   local float decision;
    
   decision = FRand();
   If (decision < 0.33)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip',0.5, 0.4);
   }
   else if (decision < 0.5)
   {
   	if (FRand() < 0.66)
        	PlaySound(Drill, SLOT_Interact);
      else
			PlaySound(Drill, SLOT_Interact);
      PlayAnim('Punch',0.5, 0.4);
   }
   else
   {
   	if (FRand() < 0.5)
        	PlaySound(Drill, SLOT_Interact);
      else
			PlaySound(Drill, SLOT_Interact);
      PlayAnim('Punch1',0.5, 0.4);
   }
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'NutPound'
   Multiskins(0)=NutPounder
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=30.000000
   CollisionHeight=70.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class''
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'PoundAttack1'
   PistolWhip1=Sound'PoundAttack2'
   Punch=Sound'PoundAttack3'
   Punch1=Sound'PoundAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'PoundDeath1'
   Die2=Sound'PoundDeath2'
   Die3=Sound'PoundDeath3'
   Die4=Sound'PoundDeath4'
   HitSound1=Sound'PoundPain1'
   HitSound2=Sound'PoundPain2'
   Acquire=Sound'PoundAcquire'
   Fear=Sound'PoundFear'
   Roam=Sound'PoundRoam'
   Threaten=Sound'PoundThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'PoundLand'
   NutRoar1=Sound'PoundRoar1'
   NutRoar2=Sound'PoundRoar2'
   Drill=Sound'PoundDrill'

   CarcassType=Class'DeerCarcass'
}