
Class PatriarchClause Expands KFMonster;

#exec MESH MODELIMPORT MESH=SantaClause_Patriarch MODELFILE=Models\SantaClause_Patriarch.psk
//#exec MESH MODELIMPORT MESH=SantaClause_Patriarch MODELFILE=Models\PatSanta.psk
#exec MESH LODPARAMS MESH=SantaClause_Patriarch HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=SantaClause_Patriarch X=0 Y=0 Z=70 YAW=-64 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Patriarch_anim ANIMFILE=Models\Patriarch_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=SantaClause_Patriarch X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=PistolWhip 		STARTFRAME=918 	NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Punch 				STARTFRAME=964 	NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=PistolWhip1 		STARTFRAME=1010 NUMFRAMES=46 RATE=46
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Punch1 			STARTFRAME=3334 NUMFRAMES=146 RATE=146
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Sleep 				STARTFRAME=2138 	NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Breath2 			STARTFRAME=2169 	NUMFRAMES=20 	RATE=20
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=CockGun 			STARTFRAME=2189 	NUMFRAMES=20 	RATE=20
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=GutHit 			STARTFRAME=315 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Hit 				STARTFRAME=324 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=HeadHit 			STARTFRAME=324 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=LeftHit 			STARTFRAME=333 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=RightHit 			STARTFRAME=342 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Jump2 				STARTFRAME=781 	NUMFRAMES=45 	RATE=45
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Walk 				STARTFRAME=2611 	NUMFRAMES=241 	RATE=241
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Charge 			STARTFRAME=1418 	NUMFRAMES=240 	RATE=240
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Dead1 				STARTFRAME=836 	NUMFRAMES=6 	RATE=6
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Fighter 			STARTFRAME=857 	NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=GutShot 			STARTFRAME=588 	NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=StillLook 		STARTFRAME=630 	NUMFRAMES=151 	RATE=151
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=Precharg 			STARTFRAME=2209 	NUMFRAMES=161 	RATE=161
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=StillFire 		STARTFRAME=588 	NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=T8 					STARTFRAME=588 	NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Patriarch_anim SEQ=WalkFire 			STARTFRAME=2370 	NUMFRAMES=241 	RATE=241

#exec ANIM DIGEST ANIM=Patriarch_anim
#exec MESH DEFAULTANIM MESH=SantaClause_Patriarch ANIM=Patriarch_anim

//Adds
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=WalkFire 		TIME=0.1 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=StillFire 		TIME=0.1 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=T8 				TIME=0.1 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=GutShot 		TIME=0.1 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=PistolWhip1 	TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Punch1 			TIME=0.1 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Patriarch_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=PatRoar

#exec TEXTURE IMPORT NAME=Gatling 			FILE=Textures\Gatling.bmp GROUP=Skins
//#Exec MESHMAP SETTEXTURE MESHMAP=MyMesh NUM=0 TEXTURE=HeadTexture
#Exec MESHMAP SETTEXTURE MESHMAP=SantaClause_Patriarch NUM=1 TEXTURE=Gatling
//#Exec MESHMAP SETTEXTURE MESHMAP=MyMesh NUM=2 TEXTURE=WeaponTexture

var(Sounds) sound PatRoar1;
var(Sounds) sound PatRoar2;

function PatRoar()
{
   if (FRand() < 0.5)
      PlaySound(PatRoar1, SLOT_Interact);
   else
      PlaySound(PatRoar2, SLOT_Interact);
}

function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayMeleeAttack()
{
   local float decision;
    
   decision = FRand();
   If (decision < 0.25)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip');
   }
   else If (decision < 0.5)
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch');
   }
   else If (decision < 0.75)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip1',0.3,0.1);  //Impaling attack
   }
   else
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch1',0.3,0.1);   //Radial spin attack
   }
}

function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.3,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.3,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.4,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayThreatening()
{
   local float decision;

   decision = FRand();

   if (decision < 0.7)
      PlayAnim('Breath2', 0.4, 0.3);
   else if (decision < 0.8)
      LoopAnim('PreCharg', 0.3, 0.25); //Slow the taunt a bit
   else
   {
      PlayThreateningSound();
      TweenAnim('Fighter', 0.3);
   }
}

function PlayRangedAttack()
{
   if ((AnimSequence == 'T8') || (VSize(Target.Location - Location) > 230))
      PlayAnim('StillFire');
   else
      PlayAnim('GutShot');
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'SantaClause_Patriarch'
   Multiskins(0)=patriarchsanta
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=35.000000
   CollisionHeight=70.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=True
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class'SantaRocket'
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'KevAttack1'
   PistolWhip1=Sound'KevAttack2'
   Punch=Sound'KevAttack3'
   Punch1=Sound'KevAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'KevDeath1'
   Die2=Sound'KevDeath2'
   Die3=Sound'KevDeath3'
   Die4=Sound'KevDeath4'
   HitSound1=Sound'KevPain1'
   HitSound2=Sound'KevPain2'
   Acquire=Sound'KevAcquire'
   Fear=Sound'KevFear'
   Roam=Sound'KevRoam'
   Threaten=Sound'KevThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'KevJump'
   PatRoar1=Sound'KevRoar1'
   PatRoar2=Sound'KevRoar2'

   CarcassType=Class'DeerCarcass'
}