
Class raindeer Expands KFMonster;

#exec MESH MODELIMPORT MESH=RainDeer MODELFILE=Models\RainDeer.psk
#exec MESH LODPARAMS MESH=RainDeer HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=RainDeer X=0 Y=0 Z=22 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Crawler_anim ANIMFILE=Models\Crawler_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=RainDeer X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=PistolWhip 	STARTFRAME=36 		NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Punch 		STARTFRAME=98 		NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Sleep 		STARTFRAME=139 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=CockGun 		STARTFRAME=701 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=StillLook 	STARTFRAME=722 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=StillFire 	STARTFRAME=722 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Jump2 		STARTFRAME=750 	NUMFRAMES=45 	RATE=45
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Breath2 		STARTFRAME=795 	NUMFRAMES=159 	RATE=159
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Hit 			STARTFRAME=1165 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=HeadHit 		STARTFRAME=1165 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=GutHit 		STARTFRAME=1165 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=LeftHit 		STARTFRAME=1165 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=RightHit 	STARTFRAME=1165 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Walk 			STARTFRAME=440 	NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=WalkFire 	STARTFRAME=440 	NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Charge 		STARTFRAME=985 	NUMFRAMES=60 	RATE=60
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Dead1 		STARTFRAME=743 	NUMFRAMES=7 	RATE=7
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Fighter 		STARTFRAME=67 		NUMFRAMES=31 	RATE=31
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=GutShot 		STARTFRAME=701 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=T8 			STARTFRAME=701 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Precharg 	STARTFRAME=795 	NUMFRAMES=159 	RATE=159

/*
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=HitF STARTFRAME=0 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=InAir_Attack1 STARTFRAME=21 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=InAir_Attack2 STARTFRAME=28 NUMFRAMES=8 RATE=8
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieLeap STARTFRAME=36 NUMFRAMES=31 RATE=31
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieLeapAttack STARTFRAME=67 NUMFRAMES=31 RATE=31
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieLeapAttack2 STARTFRAME=98 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieLeapIdle STARTFRAME=139 NUMFRAMES=301 RATE=301
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieScuttle STARTFRAME=440 NUMFRAMES=61 RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieScuttleB STARTFRAME=501 NUMFRAMES=61 RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieScuttleL STARTFRAME=562 NUMFRAMES=61 RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieScuttleR STARTFRAME=623 NUMFRAMES=61 RATE=61
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieSpring STARTFRAME=684 NUMFRAMES=17 RATE=17
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=TurnLeft STARTFRAME=701 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=TurnRight STARTFRAME=722 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Landed STARTFRAME=743 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=Jump2 STARTFRAME=750 NUMFRAMES=45 RATE=45
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=ZombieFeed STARTFRAME=795 NUMFRAMES=159 RATE=159
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=DoorBash STARTFRAME=954 NUMFRAMES=31 RATE=31
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=WalkF_Fire STARTFRAME=985 NUMFRAMES=60 RATE=60
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=WalkL_Fire STARTFRAME=1045 NUMFRAMES=60 RATE=60
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=WalkR_Fire STARTFRAME=1105 NUMFRAMES=60 RATE=60
#exec ANIM SEQUENCE ANIM=Crawler_anim SEQ=KnockDown STARTFRAME=1165 NUMFRAMES=100 RATE=100
*/

#exec ANIM DIGEST ANIM=Crawler_anim
#exec MESH DEFAULTANIM MESH=RainDeer ANIM=Crawler_anim

//Adds
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Crawler_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=DeerRoar

var(Sounds) sound DeerRoar1;
var(Sounds) sound DeerRoar2;

function DeerRoar()
{
   if (FRand() < 0.5)
      PlaySound(DeerRoar1, SLOT_Interact);
   else
      PlaySound(DeerRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.3, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.3, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.3, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}


defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'RainDeer'
   Multiskins(0)=ReinDeer
   Multiskins(1)=ReinDeer
   Multiskins(2)=ReinDeer
   CollisionRadius=30.000000
   CollisionHeight=25.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class''
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'DeerAttack1'
   PistolWhip1=Sound'DeerAttack2'
   Punch=Sound'DeerAttack3'
   Punch1=Sound'DeerAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'DeerDeath1'
   Die2=Sound'DeerDeath2'
   Die3=Sound'DeerDeath3'
   Die4=Sound'DeerDeath4'
   HitSound1=Sound'DeerPain1'
   HitSound2=Sound'DeerPain2'
   Acquire=Sound'DeerAcquire'
   Fear=Sound'DeerFear'
   Roam=Sound'DeerRoam'
   Threaten=Sound'DeerThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'DeerJump'
   DeerRoar1=Sound'DeerRoar1'
   DeerRoar2=Sound'DeerRoar2'

   CarcassType=Class'DeerCarcass'
}