
class SnowBigRock extends BigRock;

function SpawnChunks(int num)
{
   local int    NumChunks,i;
   local Snowball   TempRock;
   local float scale;

   if ( DrawScale < 1 + FRand() )
      return;

   NumChunks = 1+Rand(num);
   scale = sqrt(0.52/NumChunks);
   if ( scale * DrawScale < 1 )
   {
      NumChunks *= scale * DrawScale;
      scale = 1/DrawScale;
   }
   speed = VSize(Velocity);
   for (i=0; i<NumChunks; i++)
   {
      TempRock = Spawn(class'Snowball');
      if (TempRock != None )
         TempRock.InitFrag(self, scale);
   }
   InitFrag(self, 0.5);
}

defaultproperties
{
	MultiSkins(1)=Texture'SnowSkin'
}
