
Class StalkerClause Expands KFMonster;

#exec MESH MODELIMPORT MESH=StalkerClause2 MODELFILE=Models\StalkerClause2.psk
#exec MESH LODPARAMS MESH=StalkerClause2 HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=StalkerClause2 X=0 Y=0 Z=40 YAW=-64 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Stalker_anim ANIMFILE=Models\Stalker_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=StalkerClause2 X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Dead1 		STARTFRAME=1541 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Hit 			STARTFRAME=192 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HeadHit 		STARTFRAME=213 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=GutHit 		STARTFRAME=213 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=LeftHit 		STARTFRAME=234 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=RightHit 	STARTFRAME=255 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Jump2 		STARTFRAME=299 	NUMFRAMES=40 	RATE=40
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Sleep 		STARTFRAME=640 	NUMFRAMES=251 	RATE=251
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=StillLook 	STARTFRAME=927 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=StillFire 	STARTFRAME=948 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Walk 			STARTFRAME=1445 	NUMFRAMES=96 	RATE=96
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Charge 		STARTFRAME=1160 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkFire 	STARTFRAME=1160 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=T8 			STARTFRAME=1160 	NUMFRAMES=95 	RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Breath2 		STARTFRAME=640 	NUMFRAMES=251 	RATE=251
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=CockGun 		STARTFRAME=640 	NUMFRAMES=251 	RATE=251
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Fighter 		STARTFRAME=1541 	NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=GutShot 		STARTFRAME=36 		NUMFRAMES=33 	RATE=33
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Precharg 	STARTFRAME=36 		NUMFRAMES=33 	RATE=33
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=PistolWhip 	STARTFRAME=339 	NUMFRAMES=32 	RATE=32
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Punch 		STARTFRAME=570 	NUMFRAMES=70 	RATE=70

/*
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=DodgeF STARTFRAME=0 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=DodgeB STARTFRAME=9 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=DodgeL STARTFRAME=18 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=DodgeR STARTFRAME=27 NUMFRAMES=9 RATE=9
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=DoorBash STARTFRAME=36 NUMFRAMES=33 RATE=33
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitF STARTFRAME=69 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitF2 STARTFRAME=110 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitF3 STARTFRAME=151 NUMFRAMES=41 RATE=41
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitReactionB STARTFRAME=192 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitReactionF STARTFRAME=213 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitReactionL STARTFRAME=234 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=HitReactionR STARTFRAME=255 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=InAir STARTFRAME=276 NUMFRAMES=8 RATE=8
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Jump STARTFRAME=284 NUMFRAMES=15 RATE=15
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Jump2 STARTFRAME=299 NUMFRAMES=40 RATE=40
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=JumpAttack STARTFRAME=339 NUMFRAMES=32 RATE=32
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=Landed STARTFRAME=371 NUMFRAMES=7 RATE=7
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=RunL STARTFRAME=378 NUMFRAMES=96 RATE=96
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=RunR STARTFRAME=474 NUMFRAMES=96 RATE=96
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=StalkerAttack1 STARTFRAME=570 NUMFRAMES=70 RATE=70
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=StalkerIdle STARTFRAME=640 NUMFRAMES=251 RATE=251
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=StalkerSpinAttack STARTFRAME=891 NUMFRAMES=36 RATE=36
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=TurnLeft STARTFRAME=927 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=TurnRight STARTFRAME=948 NUMFRAMES=21 RATE=21
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkB STARTFRAME=969 NUMFRAMES=96 RATE=96
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkB_Fire STARTFRAME=1065 NUMFRAMES=95 RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkF_Fire STARTFRAME=1160 NUMFRAMES=95 RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkL_Fire STARTFRAME=1255 NUMFRAMES=95 RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=WalkR_Fire STARTFRAME=1350 NUMFRAMES=95 RATE=95
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=ZombieRun STARTFRAME=1445 NUMFRAMES=96 RATE=96
#exec ANIM SEQUENCE ANIM=Stalker_anim SEQ=KnockDown STARTFRAME=1541 NUMFRAMES=100 RATE=100
*/

#exec ANIM DIGEST ANIM=Stalker_anim
#exec MESH DEFAULTANIM MESH=StalkerClause2 ANIM=Stalker_anim

//Adds
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Stalker_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=StalkerRoar

var(Sounds) sound StalkerRoar1;
var(Sounds) sound StalkerRoar2;

function StalkerRoar()
{
   if (FRand() < 0.5)
      PlaySound(StalkerRoar1, SLOT_Interact);
   else
      PlaySound(StalkerRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.3, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.3);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.3);
      else
         PlayAnim('Breath2', 0.3, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.3, 0.4);
   else
      PlayAnim('Breath2', 0.3, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'StalkerClause2'
   Multiskins(0)=stalkerclaus
   Multiskins(1)=
   Multiskins(2)=
   CollisionRadius=23.000000
   CollisionHeight=40.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
   RangedProjectile=Class''
 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound''
   Footstep2=Sound''
   PistolWhip=Sound'StalkerAttack1'
   PistolWhip1=Sound'StalkerAttack2'
   Punch=Sound'StalkerAttack3'
   Punch1=Sound'StalkerAttack4'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'StalkerDeath1'
   Die2=Sound'StalkerDeath2'
   Die3=Sound'StalkerDeath3'
   Die4=Sound'StalkerDeath4'
   HitSound1=Sound'StalkerPain1'
   HitSound2=Sound'StalkerPain2'
   Acquire=Sound'StalkerAcquire'
   Fear=Sound'StalkerFear'
   Roam=Sound'StalkerRoam'
   Threaten=Sound'StalkerThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'StalkerJump'
   StalkerRoar1=Sound'StalkerRoar1'
   StalkerRoar2=Sound'StalkerRoar2'

   CarcassType=Class'StalkerCarcass'
}