
Class BloatSanta Expands KFMonster;

#exec MESH MODELIMPORT MESH=BloatSanta MODELFILE=Models\BloatSanta.psk
#exec MESH LODPARAMS MESH=BloatSanta HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=BloatSanta X=0 Y=0 Z=65 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Bloat_anim ANIMFILE=Models\bloatsanta.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=BloatSanta X=1.0 Y=1.0 Z=1.0 MAXKEYS=999999

#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=PistolWhip 			STARTFRAME=0 		NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Punch 					STARTFRAME=1815 	NUMFRAMES=45 	RATE=45
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=PreCharg 				STARTFRAME=2504 	NUMFRAMES=101 	RATE=101
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Sleep 					STARTFRAME=46 		NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=GutHit 					STARTFRAME=347 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=HeadHit 				STARTFRAME=429 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Hit 						STARTFRAME=470 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=LeftHit 				STARTFRAME=512 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=RightHit 				STARTFRAME=533 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=CockGun 				STARTFRAME=785 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=T8 						STARTFRAME=785 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Breath2 				STARTFRAME=806 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Charge 					STARTFRAME=1860 	NUMFRAMES=161 	RATE=161
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Walk 					STARTFRAME=827 	NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=WalkFire 				STARTFRAME=827 	NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=StillLook 				STARTFRAME=907 	NUMFRAMES=71 	RATE=41
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Dead1 					STARTFRAME=1779 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Dead2 					STARTFRAME=1788 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Dead3 					STARTFRAME=1797 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Dead4 					STARTFRAME=1806 	NUMFRAMES=9 	RATE=9
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Fighter 				STARTFRAME=2504 	NUMFRAMES=1
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=StillFire 				STARTFRAME=2504 	NUMFRAMES=1
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Gutshot 				STARTFRAME=2504 	NUMFRAMES=1
#exec ANIM SEQUENCE ANIM=Bloat_anim SEQ=Jump2 					STARTFRAME=570 	NUMFRAMES=46 	RATE=46

#exec ANIM DIGEST ANIM=Bloat_anim VERBOSE
#exec MESH DEFAULTANIM MESH=BloatSanta ANIM=Bloat_anim

//Adds
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Dead2 			TIME=0.5 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Dead3 			TIME=0.52 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Dead4 			TIME=0.71 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Bloat_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=SantaRoar

var(Sounds) sound Threaten1;
var(Sounds) sound SantaRoar1;
var(Sounds) sound SantaRoar2;

function SantaRoar()
{
   if (FRand() < 0.5)
      PlaySound(SantaRoar1, SLOT_Interact);
   else
      PlaySound(SantaRoar2, SLOT_Interact);
}

//Anim speed changes
state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}


//More sounds
function PlayThreateningSound()
{
   if (Threaten == None) return;
   if (FRand() < 0.6)
   {
    	if (FRand() < 0.5)
        	PlaySound(Threaten, SLOT_Talk,, true);
		else
			PlaySound(Threaten1, SLOT_Talk,, true);
	}
   else
      PlaySound(Acquire, SLOT_Talk,, true);
}

//Slowed down some of the resting anims
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.2 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.3)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',animspeed, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         //PlayAnim('Sleep', 0.3 + 0.3 * FRand());
         PlayAnim('Sleep', 0.1 + 0.3 * FRand());
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2 * animspeed,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', animspeed);
      else if (decision < 0.55)
         PlayAnim('CockGun', animspeed);
      else
         PlayAnim('Breath2', 0.3 + 0.3 * FRand(), 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', animspeed, 0.4);
   else
      PlayAnim('Breath2', 0.3 + 0.3 * FRand(), 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'BloatSanta'
   Multiskins(0)=BloatSantaSkin
   CollisionRadius=30.000000
   CollisionHeight=65.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
//   RangedProjectile=Class''
// 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound'UnrealShare.Brute.walk1br'
   Footstep2=Sound'UnrealShare.Brute.walk2br'
   PistolWhip=Sound'BloatHitPlayer1'
   PistolWhip1=Sound'BloatHitPlayer2'
   Punch=Sound'BloatAttack1'
   Punch1=Sound'BloatAttack2'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'BloatDeath1'
   Die2=Sound'BloatDeath1'
   Die3=Sound'BloatDeath1'
   Die4=Sound'BloatDeath1'
   HitSound1=Sound'BloatPain1'
   HitSound2=Sound'BloatPain2'
   Acquire=Sound'BloatAttack3'
   Fear=Sound'BloatIdle2'
   Roam=Sound'BloatIdle1'
   Threaten=Sound'BloatTalk1'
   Threaten1=Sound'BloatTalk2'
   SantaRoar1=Sound'BloatBarfAttack1'
   SantaRoar2=Sound'BloatBarfAttack2'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'BloatJump'

   CarcassType=Class'BloatSantaCarcass'
}
