
Class caroler Expands KFMonster;

#exec MESH MODELIMPORT MESH=Caroler MODELFILE=Models\caroler.psk
#exec MESH LODPARAMS MESH=Caroler HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=Caroler X=0 Y=0 Z=55 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Siren_anim ANIMFILE=Models\Siren_anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=Caroler X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=CockGun 		STARTFRAME=36 		NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Fighter 		STARTFRAME=36 		NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=GutHit 			STARTFRAME=159 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=GutShot 		STARTFRAME=159 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Dead1 			STARTFRAME=180 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Hit 				STARTFRAME=201 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=HeadHit 		STARTFRAME=222 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=LeftHit 		STARTFRAME=222 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=RightHit 		STARTFRAME=222 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Jump2 			STARTFRAME=267 	NUMFRAMES=45 	RATE=45
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Precharg 		STARTFRAME=921 	NUMFRAMES=36 	RATE=36
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=PistolWhip 	STARTFRAME=957 	NUMFRAMES=36 	RATE=36
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=StillLook 		STARTFRAME=993 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Sleep 			STARTFRAME=993 	NUMFRAMES=301 	RATE=301
//Scream anim
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=SirenScream 	STARTFRAME=1294 	NUMFRAMES=141 	RATE=141
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Walk 			STARTFRAME=1435 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Breath2 		STARTFRAME=1736 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=StillFire 		STARTFRAME=1757 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Charge 			STARTFRAME=1778 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=WalkFire 		STARTFRAME=1898 	NUMFRAMES=120 	RATE=120
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=Punch 			STARTFRAME=2258 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Siren_anim SEQ=T8 				STARTFRAME=2258 	NUMFRAMES=100 	RATE=100

#exec ANIM DIGEST ANIM=Siren_anim VERBOSE
#exec MESH DEFAULTANIM MESH=Caroler ANIM=Siren_anim

//Adds
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=SirenRoar
#exec ANIM NOTIFY ANIM=Siren_anim 	SEQ=SirenScream 	TIME=0.4		FUNCTION=ScreamPain

var(Sounds) sound SirenRoar1;
var(Sounds) sound SirenRoar2;

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//slow attack anims down
function PlayMeleeAttack()
{
   local float decision;

   decision = FRand();
   If (decision < 0.5)
   {
   	if (FRand() < 0.4)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip',0.5,0.1);
   }
   else If (decision < 0.8)
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch',0.7,0.1);
   }
   else //Scream attack
   {
		PlaySound(SirenRoar2, SLOT_Interact);
      PlayAnim('SirenScream',0.4,0.1);
   }
}

function ScreamPain()
{
   local EMPShockWave EMP;

   EMP=Spawn(class'EMPShockWave',,,Instigator.Location,);
   ClientFlashes();
}

simulated function ClientFlashes()
{
	local Vector EndFlashFog;
	local float f;
	local PlayerPawn p;

	EndFlashFog.X=60;	EndFlashFog.Y=1;	EndFlashFog.Z=0;
	foreach RadiusActors(class'PlayerPawn', p, 500, Instigator.Location)
   if (p != none)
   {
      if (p.Health > 0)
      {
         p.ClientFlash( 2, 1000*EndFlashFog );
      }
   }
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.3,,0.4);
      return;
   }

   LoopAnim('Walk', 0.3,,0.3);
}

function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.2,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.2,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.2);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.5);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.2, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

//Need to use the second roar for the scream attack
function SirenRoar()
{
   PlaySound(SirenRoar2, SLOT_Interact);
}

defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'Caroler'
   Multiskins(0)=Texture'UnrealShare.Skins.Jgfish1'
   Multiskins(1)=caroler
//   Multiskins(2)=
   CollisionRadius=15.000000
   CollisionHeight=55.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
//   RangedProjectile=Class''
// 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=140.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound'UnrealShare.Cow.walkC'
   Footstep2=Sound'UnrealShare.Cow.walkC'
   PistolWhip=Sound'SirenWhip1'
   PistolWhip1=Sound'SirenWhip2'
   Punch=Sound'SirenPunch1'
   Punch1=Sound'SirenPunch2'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'SirenDeath1'
   Die2=Sound'SirenDeath2'
   Die3=Sound'SirenDeath3'
   Die4=Sound'SirenDeath4'
   HitSound1=Sound'SirenHitsound1'
   HitSound2=Sound'SirenHitsound2'
   Acquire=Sound'SirenAcquire'
   Fear=Sound'SirenFear'
   Roam=Sound'SirenRoam'
   Threaten=Sound'SirenThreaten'
	AmbientSound=None
   Land=Sound'SirenLand'
   SirenRoar1=Sound'SirenRoar1'
   SirenRoar2=Sound'SirenRoar2'

   CarcassType=Class'UnrealShare.BruteCarcass'
}