
Class clotelf Expands KFMonster;

#exec MESH MODELIMPORT MESH=Clot_Elf MODELFILE=Models\Clot_Elf.psk
#exec MESH LODPARAMS MESH=Clot_Elf HYSTERESIS=0.00 STRENGTH=0.01 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN MESH=Clot_Elf X=0 Y=0 Z=45 YAW=194 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=Clot_Anim ANIMFILE=Models\Clot_Anim.psa COMPRESS=1
#exec MESHMAP SCALE MESHMAP=Clot_Elf X=1.0 Y=1.0 Z=1.0

#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=PistolWhip 	STARTFRAME=0 		NUMFRAMES=61 	RATE=61
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=PistolWhip1 STARTFRAME=61 		NUMFRAMES=70 	RATE=70
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Punch 		STARTFRAME=131 	NUMFRAMES=36 	RATE=36
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Punch1 		STARTFRAME=243 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=GutHit 		STARTFRAME=1212 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Hit 			STARTFRAME=1212 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=LeftHit 		STARTFRAME=1233 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=RightHit 	STARTFRAME=1254 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Jump2 		STARTFRAME=1901 	NUMFRAMES=46 	RATE=46
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Breath2 		STARTFRAME=2636 	NUMFRAMES=21 	RATE=21
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Charge 		STARTFRAME=3078 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Sleep 		STARTFRAME=4368 	NUMFRAMES=161 	RATE=161
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Walk 			STARTFRAME=284 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=WalkFire 	STARTFRAME=3078 	NUMFRAMES=100 	RATE=100
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=T8 			STARTFRAME=987 	NUMFRAMES=81 	RATE=81
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=StillFire 	STARTFRAME=1275 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Precharg 	STARTFRAME=1947 	NUMFRAMES=80 	RATE=80
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=StillLook 	STARTFRAME=1576 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=CockGun 		STARTFRAME=1576 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=HeadHit 		STARTFRAME=1068 	NUMFRAMES=41 	RATE=41
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Gutshot 		STARTFRAME=284 	NUMFRAMES=301 	RATE=301
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Fighter 		STARTFRAME=0 		NUMFRAMES=1 	RATE=1
#exec ANIM SEQUENCE ANIM=Clot_Anim SEQ=Dead1 		STARTFRAME=2027 	NUMFRAMES=7 	RATE=7

#exec ANIM DIGEST ANIM=Clot_Anim
#exec MESH DEFAULTANIM MESH=Clot_Elf ANIM=Clot_Anim

//add
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=StillFire 		TIME=0.5 	FUNCTION=SpawnLeftShot
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Punch 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=PistolWhip1 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Punch1 			TIME=0.5 	FUNCTION=PunchDamageTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Charge 			TIME=0.25 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Charge 			TIME=0.75 	FUNCTION=Step
#exec ANIM NOTIFY ANIM=Clot_Anim 	SEQ=Charge 			TIME=0.01 	FUNCTION=ElfRoar

var(Sounds) sound ElfRoar1;
var(Sounds) sound ElfRoar2;

function ElfRoar()
{
   if (FRand() < 0.5)
      PlaySound(ElfRoar1, SLOT_Interact);
   else
      PlaySound(ElfRoar2, SLOT_Interact);
}

//Single death anim on this model
function PlayBigDeath(name DamageType)
{
   PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
   PlayAnim('Dead1',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die3, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die4,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
   PlayAnim('Dead1',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

//added a couple more melee anims, they are too good not to use
function PlayMeleeAttack()
{
   local float decision;
    
   decision = FRand();
   If (decision < 0.25)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip');
   }
   else If (decision < 0.5)
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch');
   }
   else If (decision < 0.75)
   {
   	if (FRand() < 0.5)
        	PlaySound(PistolWhip, SLOT_Interact);
      else
			PlaySound(PistolWhip1, SLOT_Interact);
      PlayAnim('PistolWhip1');
   }
   else
   {
   	if (FRand() < 0.5)
        	PlaySound(Punch, SLOT_Interact);
      else
			PlaySound(Punch1, SLOT_Interact);
      PlayAnim('Punch1');
   }
}

//Slow things down
function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand();

   decision = FRand();
   if (AnimSequence == 'Sleep')
   {
      if (decision < 0.07)
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',0.5, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.3,0.4);
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',0.3,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', 0.2);
      else if (decision < 0.55)
         PlayAnim('CockGun', 0.2);
      else
         PlayAnim('Breath2', 0.5, 0.4);
   }
   else if (decision < 0.1)
      PlayAnim('StillLook', 0.2, 0.4);
   else
      PlayAnim('Breath2', 0.5, 0.4);
    
   if (AnimSequence == 'StillLook')
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else
      SetAlertness(0.0);
}

state Charging
{
	ignores SeePlayer, HearNoise;

   function AnimEnd()
   {
      If (bBerserk)
         LoopAnim('Charge', 0.5,,0.5);
      else
         PlayCombatMove();
   }

   function Timer()
   {
      if (bBerserk && bLongBerserk && (FRand() < 0.3))
      {
         AccelRate = Default.AccelRate;
         GroundSpeed = Default.GroundSpeed;
         AmbientSound=None;
         bBerserk = false;
      }
      bLongBerserk = bBerserk;
    
      Super.Timer();
   }
            
   function BeginState()
   {
      GoBerserk();
      Super.BeginState();
   }

   function EndState()
   {
      if (bBerserk)
      {
         GroundSpeed = Default.GroundSpeed;
         AccelRate = Default.AccelRate;
      }
      Super.EndState();
   }
}

function PlayRunning()
{
   if (Focus == Destination)
   {
      LoopAnim('Walk', 0.2,,0.4);
      return;
   }

   LoopAnim('Walk', 0.2,,0.3);
}

function PlayWalking()
{
   LoopAnim('Walk', 0.2,,0.4);
}


defaultproperties
{
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'Clot_Elf'
   Multiskins(0)=clotelf
//   Multiskins(1)=
//   Multiskins(2)=
   CollisionRadius=20.000000
   CollisionHeight=47.000000

   Health=340
   WhipDamage=20
   PunchDamage=20
   bHasRangedAttack=False
   bMovingRangedAttack=False
   bLeadTarget=True
   bCanStrafe=True
//   RangedProjectile=Class''
// 	ProjectileSpeed=700.000000
   MeleeRange=70.000000
   GroundSpeed=200.000000
   WaterSpeed=100.000000
   SightRadius=1500.000000

   footstep=Sound'UnrealShare.Brute.walk1br'
   Footstep2=Sound'UnrealShare.Brute.walk2br'
   PistolWhip=Sound'ClotAttack3'
   PistolWhip1=Sound'ClotAttack4'
   Punch=Sound'ClotAttack1'
   Punch1=Sound'ClotAttack2'
   PistolHit=Sound'UnrealShare.Brute.pstlhit1br'
   Die=Sound'ClotDeath1'
   Die2=Sound'ClotDeath2'
   Die3=Sound'ClotDeath3'
   Die4=Sound'ClotDeath4'
   HitSound1=Sound'ClotPain1'
   HitSound2=Sound'ClotPain2'
   Acquire=Sound'ClotAcquire'
   Fear=Sound'ClotFear'
   Roam=Sound'ClotRoam'
   Threaten=Sound'ClotThreaten'
	AmbientSound=Sound'UnrealShare.Brute.amb1br'
   Land=Sound'ClotJump'
   ElfRoar1=Sound'ClotRoar1'
   ElfRoar2=Sound'ClotRoar2'

   CarcassType=Class'ElfCarcass'
}